/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.agent.dataproviders;

import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.DataProvider;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.DataProviderConstants;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.HealthCenterLibraryFinder;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.HealthCenter;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.HealthCenterOptionHandler;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JLADataProvider
implements DataProvider,
DataProviderConstants {
    private static final String COMMA = ",";
    private static final String REPORT_TIME_EYECATCHER = "reportTime,";
    private static String VERSION = "1.0";
    private static String TAG = "JLASource";
    private static String PARSERTIME = "120";

    public JLADataProvider(HealthCenterOptionHandler handler) {
        this.startNativeJLA();
    }

    @Override
    public void startSession() {
    }

    public void startNativeJLA() {
        try {
            this.startJLA();
        }
        catch (UnsatisfiedLinkError e) {
            this.loadHealthCenterLibraryDirectly();
            try {
                this.startJLA();
            }
            catch (UnsatisfiedLinkError ee) {
                System.err.println(ee.getLocalizedMessage());
            }
        }
    }

    public void stopNativeJLA() {
        this.stopJLA();
    }

    @Override
    public boolean isDataSupported() {
        boolean available = false;
        try {
            try {
                if (this.reportJLA() != null) {
                    available = true;
                }
            }
            catch (UnsatisfiedLinkError e) {
                this.loadHealthCenterLibraryDirectly();
                if (this.reportJLA() != null) {
                    available = true;
                }
            }
        }
        catch (Throwable e) {
            System.err.println("Lock Analysis is not available: " + e);
            available = false;
        }
        return available;
    }

    @Override
    public Map<String, String> getLiveSourceDetails() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", TAG);
        map.put("version", VERSION);
        map.put("suggested_update_frequency", PARSERTIME);
        map.put("max_bytes_to_send", Integer.toString(-1));
        return map;
    }

    private native void startJLA();

    private native void stopJLA();

    private native String reportJLA();

    private String getLockingReport() {
        String jlaReport = null;
        jlaReport = this.reportJLA();
        return REPORT_TIME_EYECATCHER + System.currentTimeMillis() + COMMA + jlaReport;
    }

    private void loadHealthCenterLibraryDirectly() {
        File library = new HealthCenterLibraryFinder().findHealthCenterLibrary();
        if (library != null && library.exists()) {
            System.load(library.getAbsolutePath());
        }
    }

    @Override
    public byte[] getJMXData() {
        if (HealthCenter.isDebug) {
            System.out.println("returning reportNativeJLA");
        }
        try {
            return this.getLockingReport().getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            return this.getLockingReport().getBytes();
        }
    }

    @Override
    public void resetData() {
        this.startJLA();
    }

    @Override
    public void modify(String command, String ... params) {
    }
}

