/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.agent.dataproviders;

import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.Messages;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.ProviderModificationException;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.TraceDataProvider;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.HealthCenter;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.HealthCenterOptionHandler;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.TraceCommandParser;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TraceFileDataProvider
extends TraceDataProvider {
    private static String TRACESOURCE_SCOOPING_VERSION = "1.0";
    private static final String TAG = "TRACEFileSource";
    private File traceFileToRead;
    private long bytesRead = 0L;

    public TraceFileDataProvider(int pid, HealthCenterOptionHandler handler) {
        super(pid, handler);
        if (HealthCenter.isDebug) {
            System.out.println("add trace to source");
        }
    }

    @Override
    public boolean isDataSupported() {
        boolean available = false;
        File traceFile = this.getTraceFileToRead();
        if (traceFile != null) {
            available = true;
        } else if (HealthCenter.isDebug) {
            System.out.println(Messages.getString("TraceDataProvider.trace.file.not.available"));
        }
        return available;
    }

    protected File getTraceFileToRead() {
        if (this.traceFileToRead == null) {
            String[] vmargs = this.handler.getVMArgs();
            this.traceFileToRead = TraceCommandParser.getTraceOutputFile(vmargs, this._processID);
        }
        return this.traceFileToRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized byte[] getJMXData() {
        byte[] bufferToReturn;
        int cachedHeaderCorrection = 0;
        File traceFile = this.getTraceFileToRead();
        if (traceFile != null) {
            byte[] buf = new byte[]{};
            try {
                long fileSize = traceFile.length();
                if (HealthCenter.isDebug) {
                    System.out.println(MessageFormat.format("File size of trace file is {0}", fileSize));
                }
                long bytesAvailableToSend = fileSize - this.bytesRead;
                int _numBytesToTransmit = (int)Math.min(bytesAvailableToSend, (long)this.maxSendBytes);
                if (HealthCenter.isDebug) {
                    System.out.println(MessageFormat.format("Max bytes to send: {0} , sending back: {1} bytes", this.maxSendBytes, _numBytesToTransmit));
                }
                buf = new byte[_numBytesToTransmit];
                FileInputStream in = new FileInputStream(traceFile);
                BufferedInputStream bin = new BufferedInputStream(in);
                try {
                    bin.skip(this.bytesRead);
                    if (HealthCenter.isDebug) {
                        System.out.println(MessageFormat.format("_numBytesToTransmit is {0}", _numBytesToTransmit));
                    }
                    bin.read(buf, 0, _numBytesToTransmit);
                }
                finally {
                    bin.close();
                    in.close();
                }
                if (this.traceFileHeader == null) {
                    if (buf.length > 0) {
                        this.initialiseTraceFileHeader(buf);
                        this.maxSendBytes = this.maxSendBytes / this.traceBufferSize * this.traceBufferSize;
                    }
                } else if (this.needTraceHeader) {
                    cachedHeaderCorrection = this.sizeOfHeader;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            if (this.needTraceHeader) {
                if (this.traceFileHeader != null) {
                    this.needTraceHeader = false;
                    int numberOfCompleteBuffers = buf != null ? (buf.length - this.sizeOfHeader) / this.traceBufferSize : 0;
                    int sizeToSendBack = numberOfCompleteBuffers * this.traceBufferSize + this.sizeOfHeader;
                    bufferToReturn = new byte[sizeToSendBack];
                    if (cachedHeaderCorrection > 0) {
                        System.arraycopy(this.traceFileHeader, 0, bufferToReturn, 0, this.sizeOfHeader);
                        System.arraycopy(buf, 0, bufferToReturn, this.sizeOfHeader, numberOfCompleteBuffers * this.traceBufferSize);
                    } else {
                        System.arraycopy(buf, 0, bufferToReturn, 0, sizeToSendBack);
                    }
                } else {
                    bufferToReturn = new byte[]{};
                }
            } else {
                int numberOfCompleteBuffers = buf.length / this.traceBufferSize;
                int sizeToSendBack = numberOfCompleteBuffers * this.traceBufferSize;
                if (sizeToSendBack != buf.length) {
                    bufferToReturn = new byte[sizeToSendBack];
                    System.arraycopy(buf, 0, bufferToReturn, 0, sizeToSendBack);
                } else {
                    bufferToReturn = buf;
                }
            }
        } else {
            bufferToReturn = new byte[]{};
        }
        this.bytesRead += (long)(bufferToReturn.length - cachedHeaderCorrection);
        return bufferToReturn;
    }

    @Override
    protected void enableGCTracePoints(int[] gcTPs) {
        block3: {
            try {
                for (int tp : gcTPs) {
                    this.enableNormalTracePoint("j9mm." + tp);
                }
            }
            catch (ProviderModificationException e) {
                if (!HealthCenter.isDebug) break block3;
                System.out.println("Garbage Collection tracepoints unavailable");
            }
        }
    }

    @Override
    protected boolean setNoDynamicProperties(HealthCenterOptionHandler handler) {
        return false;
    }

    @Override
    public Map<String, String> getLiveSourceDetails() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", TAG);
        map.put("version", TRACESOURCE_SCOOPING_VERSION);
        map.put("suggested_update_frequency", "5");
        map.put("state", this.getEnabledTracePointsString());
        if (this.traceFileHeader != null) {
            map.put("max_bytes_to_send", Integer.toString(this.maxSendBytes));
        } else {
            map.put("max_bytes_to_send", Integer.toString(10));
        }
        map.put("size_of_header", Integer.toString(this.sizeOfHeader));
        map.put("complete_chunks_data", Boolean.TRUE.toString());
        return map;
    }

    @Override
    protected void init(int pid, HealthCenterOptionHandler handler) {
        this._processID = pid;
    }
}

