/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.agent.dataproviders;

import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.Messages;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.ProviderModificationException;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.TraceDataProvider;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.HealthCenter;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.HealthCenterOptionHandler;
import com.ibm.jvm.Trace;
import java.nio.ByteBuffer;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TraceSubscriberDataProvider
extends TraceDataProvider {
    private static String TRACESOURCE_JVMTI_VERSION = "2.0";
    private static final int DEFAULT_MAX_CIRCULAR_BUFFER_SIZE = 4000000;
    private static final String TAG = "TRACESubscriberSource";
    protected static final byte[] METADATA_EYE_CATCHER = new byte[]{72, 67, 84, 72};
    private boolean isSubscriberServiceAvailable;

    private native byte[] getTraceMetadata();

    private native boolean startTraceSubscriber(long var1, int var3);

    private native void flushTraceBuffers();

    private native byte[] getTraceBuffers(int var1);

    public TraceSubscriberDataProvider(int pid, HealthCenterOptionHandler handler) {
        super(pid, handler);
    }

    @Override
    public boolean isDataSupported() {
        return this.isSubscriberServiceAvailable;
    }

    @Override
    protected void init(int pid, HealthCenterOptionHandler handler) {
        long maxCircularBufferSize;
        block12: {
            String propertyValue;
            this._processID = pid;
            maxCircularBufferSize = 4000000L;
            if (handler != null && (propertyValue = handler.getMaxCircularBufferSize()) != null) {
                try {
                    maxCircularBufferSize = Long.valueOf(propertyValue);
                    if (maxCircularBufferSize < 0L) {
                        String message = Messages.getString("TraceDataProvider.negativeBufferSize");
                        String formatted = MessageFormat.format(message, 4000000);
                        this.logger.warning(formatted);
                        maxCircularBufferSize = 4000000L;
                    }
                }
                catch (NumberFormatException nfe) {
                    String message = Messages.getString("TraceDataProvider.invalidBufferSize");
                    this.logger.warning(MessageFormat.format(message, propertyValue, 4000000));
                    maxCircularBufferSize = 4000000L;
                }
            }
            try {
                byte[] metaDataBytes = this.getTraceMetadata();
                if (metaDataBytes != null) {
                    this.initialiseTraceFileHeader(metaDataBytes);
                }
            }
            catch (UnsatisfiedLinkError e) {
                e.printStackTrace();
                if (!HealthCenter.isDebug) break block12;
                System.out.println(e.getLocalizedMessage());
            }
        }
        if (this.traceFileHeader != null) {
            boolean startTraceSubscriber;
            block13: {
                startTraceSubscriber = false;
                try {
                    startTraceSubscriber = this.startTraceSubscriber(maxCircularBufferSize, this.traceBufferSize);
                }
                catch (UnsatisfiedLinkError e) {
                    if (!HealthCenter.isDebug) break block13;
                    System.out.println(e.getLocalizedMessage());
                }
            }
            if (startTraceSubscriber) {
                this.isSubscriberServiceAvailable = true;
                if (HealthCenter.isDebug) {
                    System.out.println("add jvmti trace to source");
                }
            }
        }
    }

    @Override
    public byte[] getJMXData() {
        byte[] bufferBytes;
        int bufferLength;
        if (HealthCenter.isDebug) {
            System.out.println("returning TraceData");
        }
        if ((bufferLength = (bufferBytes = this.getTraceBuffers(this.maxSendBytes)).length) < this.maxSendBytes) {
            if (HealthCenter.isDebug) {
                System.out.println("flushing trace buffers");
            }
            this.flushTraceBuffers();
        }
        if (this.needTraceHeader) {
            this.needTraceHeader = false;
            int dataLength = METADATA_EYE_CATCHER.length + 8 + this.sizeOfHeader + bufferLength;
            byte[] returnBytes = new byte[dataLength];
            ByteBuffer sendBuffer = ByteBuffer.wrap(returnBytes);
            sendBuffer.put(METADATA_EYE_CATCHER);
            sendBuffer.putLong(this.sizeOfHeader);
            sendBuffer.put(this.traceFileHeader);
            sendBuffer.put(bufferBytes);
            if (HealthCenter.isDebug) {
                String msg = MessageFormat.format("Sending {0} bytes including {1} bytes for trace metadata", dataLength, this.sizeOfHeader);
                System.err.println(msg);
            }
            return returnBytes;
        }
        if (HealthCenter.isDebug) {
            String msg = MessageFormat.format("Sending {0} bytes", bufferLength);
            System.err.println(msg);
        }
        return bufferBytes;
    }

    @Override
    protected void enableGCTracePoints(int[] gcTPs) {
        block3: {
            try {
                for (int tp : gcTPs) {
                    this.disableNormalTracePoint("j9mm." + tp);
                    this.enableExceptionTracePoint("j9mm." + tp);
                }
            }
            catch (ProviderModificationException e) {
                if (!HealthCenter.isDebug) break block3;
                System.out.println("Garbage Collection tracepoints unavailable");
            }
        }
    }

    @Override
    public Map<String, String> getLiveSourceDetails() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", TAG);
        map.put("version", TRACESOURCE_JVMTI_VERSION);
        map.put("suggested_update_frequency", "5");
        map.put("state", this.getEnabledTracePointsString());
        map.put("max_bytes_to_send", Integer.toString(this.maxSendBytes - this.maxSendBytes % this.traceBufferSize));
        map.put("size_of_header", Integer.toString(this.sizeOfHeader + METADATA_EYE_CATCHER.length + 8));
        map.put("complete_chunks_data", Boolean.TRUE.toString());
        return map;
    }

    @Override
    protected boolean setNoDynamicProperties(HealthCenterOptionHandler handler) {
        boolean nodynamic = false;
        if (!handler.isDynamicOverride()) {
            int rc = Trace.set((String)"buffers=nodynamic");
            if (rc != 0) {
                if (HealthCenter.isDebug) {
                    System.out.println(MessageFormat.format("failed to set buffers=nodynamic (rc={0})", rc));
                }
            } else {
                nodynamic = true;
            }
        }
        return nodynamic;
    }
}

