/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.agent.dataproviders;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Util {
    private static String vmVersion = System.getProperty("java.runtime.version");
    private static String specVersion = System.getProperty("java.specification.version");

    public static void overrideJavaVersion(String spec, String vm) {
        specVersion = spec;
        vmVersion = vm;
    }

    public static int getJavaLevel() {
        int level = -1;
        String[] versions = specVersion.split("\\.");
        if (versions.length >= 2) {
            try {
                level = Integer.parseInt(versions[1]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return level;
    }

    public static int getServiceRefreshNumber() {
        int sr = -1;
        Pattern pat = Pattern.compile("(.*\\([SE][RA])(\\d+)(.*)");
        Matcher mat = pat.matcher(vmVersion);
        if (mat.matches() && mat.groupCount() > 2) {
            try {
                sr = Integer.parseInt(mat.group(2));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return sr;
    }
}

