/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.agent.dataproviders.environment;

import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.DataProvider;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.DataProviderConstants;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.environment.UlimitChecker;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.AgentLogFactory;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.HealthCenterOptionHandler;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.Messages;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvironmentDataProvider
implements DataProvider,
DataProviderConstants {
    public static final String ARGUMENT_SEPARATOR = "@@@";
    private final Logger logger;
    private static String VERSION = "1.0";
    public static String TAG = "EnvironmentSource";
    private static String PARSERTIME = "1200";
    private Map<String, String> agentVersionMap = null;
    private final int processId;

    public EnvironmentDataProvider(int pid, HealthCenterOptionHandler handler) {
        this.processId = pid;
        this.logger = AgentLogFactory.setUpLogging(this.getClass());
    }

    @Override
    public boolean isDataSupported() {
        return true;
    }

    @Override
    public byte[] getJMXData() {
        Properties properties = this.populateProperties();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream pSW = null;
        try {
            pSW = new PrintStream((OutputStream)out, true, "UTF8");
        }
        catch (UnsupportedEncodingException e1) {
            System.err.println(e1.toString());
            return new byte[0];
        }
        try {
            pSW.println("#" + TAG);
            for (String string : properties.keySet()) {
                String values = properties.getProperty(string);
                pSW.println(string + "=" + values);
            }
            out.flush();
            return out.toByteArray();
        }
        catch (IOException e) {
            System.err.println(e.toString());
            return new byte[0];
        }
    }

    private Properties populateProperties() {
        Properties properties = new Properties();
        properties.put("pid", String.valueOf(this.processId));
        properties.put("number.of.processors", String.valueOf(Runtime.getRuntime().availableProcessors()));
        properties.put("maximum.memory", String.valueOf(Runtime.getRuntime().maxMemory()));
        this.reportCommandLine(properties);
        this.reportSystemProperties(properties);
        this.reportEnvironmentVariables(properties);
        this.reportAgentVersion(properties);
        new UlimitChecker().writeProperties(properties);
        return properties;
    }

    private void reportSystemProperties(Properties properties) {
        Object key;
        Object keys;
        Properties systemProperties;
        int restarts = 0;
        boolean succeeded = false;
        while (!succeeded && restarts < 10) {
            systemProperties = System.getProperties();
            keys = systemProperties.keySet().iterator();
            try {
                while (keys.hasNext()) {
                    key = keys.next();
                    properties.put("system." + key, systemProperties.get(key));
                }
                succeeded = true;
            }
            catch (ConcurrentModificationException e) {
                this.logger.fine(e.toString());
                ++restarts;
            }
        }
        if (!succeeded) {
            systemProperties = System.getProperties();
            keys = systemProperties.keys();
            while (keys.hasMoreElements()) {
                try {
                    key = keys.nextElement();
                    properties.put("system." + key, systemProperties.get(key));
                }
                catch (NoSuchElementException e) {
                    this.logger.fine(e.toString());
                }
            }
            succeeded = true;
        }
    }

    private void reportEnvironmentVariables(Properties properties) {
        Map<String, String> variables = System.getenv();
        for (Map.Entry<String, String> entry : variables.entrySet()) {
            properties.put("environment." + entry.getKey(), entry.getValue());
        }
    }

    private void reportCommandLine(Properties properties) {
        List<String> arguments = ManagementFactory.getRuntimeMXBean().getInputArguments();
        StringBuffer flattenedList = new StringBuffer();
        Iterator<String> it = arguments.iterator();
        while (it.hasNext()) {
            flattenedList.append(it.next());
            if (!it.hasNext()) continue;
            flattenedList.append(ARGUMENT_SEPARATOR);
        }
        properties.put("command.line.arguments", flattenedList.toString());
    }

    private void reportAgentVersion(Properties properties) {
        Map<String, String> variables = this.getAgentInformation();
        for (Map.Entry<String, String> entry : variables.entrySet()) {
            properties.put("jar.version", entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getAgentInformation() {
        EnvironmentDataProvider environmentDataProvider = this;
        synchronized (environmentDataProvider) {
            if (this.agentVersionMap == null) {
                this.agentVersionMap = new HashMap<String, String>();
                boolean found = false;
                try {
                    Properties versionProps = new Properties();
                    InputStream propsFile = this.getClass().getClassLoader().getResourceAsStream("version.properties");
                    if (propsFile != null) {
                        found = true;
                        versionProps.load(propsFile);
                        for (Map.Entry<Object, Object> entry : versionProps.entrySet()) {
                            this.agentVersionMap.put((String)entry.getKey(), (String)entry.getValue());
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!found) {
                    this.agentVersionMap.put("Version", Messages.getString("HealthCenter.unknown.version"));
                }
            }
        }
        return this.agentVersionMap;
    }

    @Override
    public Map<String, String> getLiveSourceDetails() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", TAG);
        map.put("version", VERSION);
        map.put("suggested_update_frequency", PARSERTIME);
        map.put("max_bytes_to_send", Integer.toString(-1));
        return map;
    }

    @Override
    public void resetData() {
    }

    @Override
    public void startSession() {
    }

    @Override
    public void modify(String command, String ... params) {
    }
}

