/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.agent.dataproviders.methoddictionary;

import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.DataProvider;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.DataProviderConstants;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.ProviderModificationException;
import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.methoddictionary.Messages;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.AgentLogFactory;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.HealthCenterOptionHandler;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodDictionaryDataProvider
implements DataProvider,
DataProviderConstants {
    private static final String VERSION = "1.0";
    private static final String TAG = "MethodDictionarySource";
    private static final String PARSERTIME = "5";
    private static final String COMPLETE_BUFFERS = "true";
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final byte[] NEW_LINE_UTF8_BYTES = MethodDictionaryDataProvider.getUTF8(NEW_LINE);
    static final String EYE_CATCHER = "#MethodDictionarySource" + NEW_LINE;
    static final byte[] EYE_CATCHER_UTF8_BYTES = MethodDictionaryDataProvider.getUTF8(EYE_CATCHER);
    private static final int MAX_BYTES_PER_LONG = Math.max(MethodDictionaryDataProvider.getUTF8(Long.MAX_VALUE).length, MethodDictionaryDataProvider.getUTF8(Long.MIN_VALUE).length);
    private static final byte[] EQUALS_UTF8_BYTES = MethodDictionaryDataProvider.getUTF8("=");
    private static final byte[] NAME_SEPARATOR_UTF8_BYTES = MethodDictionaryDataProvider.getUTF8(".");
    private static final int NAME_BUFFER_SIZE = 8192;
    private static final int MAX_SEND_BYTES = 5461;
    static final int JVMTI_ERROR_NONE = 0;
    static final int JVMTI_ERROR_INVALID_METHODID = 23;
    static final int JVMTI_ERROR_OUT_OF_MEMORY = 110;
    private final Logger logger = AgentLogFactory.setUpLogging(this.getClass());
    private final Object methodQueryLock = new Object();
    private final Set<Long> idsToLookup = new LinkedHashSet<Long>();
    private boolean sendEyeCatcher = true;

    private static native boolean isSupported();

    private static native void getMethodAndClassNames(long[] var0, int[] var1, int[] var2, int[] var3, int var4, byte[] var5);

    public MethodDictionaryDataProvider(HealthCenterOptionHandler handler) {
    }

    @Override
    public boolean isDataSupported() {
        boolean isSupported = false;
        try {
            isSupported = MethodDictionaryDataProvider.isSupported();
        }
        catch (UnsatisfiedLinkError e) {
            this.logger.warning(e.toString());
        }
        return isSupported;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getJMXData() {
        long[] methodIds;
        int numberOfMethods;
        boolean prependEyeCatcher;
        Object object = this.methodQueryLock;
        synchronized (object) {
            prependEyeCatcher = this.sendEyeCatcher;
            if (prependEyeCatcher) {
                this.sendEyeCatcher = false;
            }
            numberOfMethods = this.idsToLookup.size();
            methodIds = new long[numberOfMethods];
            int i = 0;
            Iterator<Long> i$ = this.idsToLookup.iterator();
            while (i$.hasNext()) {
                long id;
                methodIds[i] = id = i$.next().longValue();
                ++i;
            }
        }
        if (numberOfMethods == 0) {
            if (prependEyeCatcher) {
                return EYE_CATCHER_UTF8_BYTES;
            }
            return new byte[0];
        }
        int[] results = new int[numberOfMethods];
        int[] classNameOffsets = new int[numberOfMethods];
        int[] methodNameOffsets = new int[numberOfMethods];
        byte[] stringData = new byte[8192];
        MethodDictionaryDataProvider.getMethodAndClassNames(methodIds, results, classNameOffsets, methodNameOffsets, numberOfMethods, stringData);
        Object object2 = this.methodQueryLock;
        synchronized (object2) {
            for (int i = 0; i < results.length; ++i) {
                int result = results[i];
                if (!MethodDictionaryDataProvider.isMethodReturnedOrInvalid(result)) continue;
                long methodId = methodIds[i];
                this.idsToLookup.remove(methodId);
            }
        }
        return this.formatMethodDictionaryData(methodIds, results, classNameOffsets, methodNameOffsets, numberOfMethods, stringData, prependEyeCatcher);
    }

    byte[] formatMethodDictionaryData(long[] methodIds, int[] results, int[] classNameOffsets, int[] methodNameOffsets, int numberOfMethods, byte[] stringData, boolean prependEyeCatcher) {
        int lineOverhead = MAX_BYTES_PER_LONG + 1 + 1 + NEW_LINE_UTF8_BYTES.length;
        int maxByteSize = (prependEyeCatcher ? EYE_CATCHER_UTF8_BYTES.length : 0) + lineOverhead * numberOfMethods + stringData.length;
        ByteBuffer buffer = ByteBuffer.allocate(maxByteSize);
        if (prependEyeCatcher) {
            buffer.put(EYE_CATCHER_UTF8_BYTES);
        }
        for (int i = 0; i < numberOfMethods; ++i) {
            int result = results[i];
            if (!MethodDictionaryDataProvider.isMethodReturnedOrInvalid(result)) continue;
            byte[] methodIdUTF8Bytes = MethodDictionaryDataProvider.getUTF8(methodIds[i]);
            buffer.put(methodIdUTF8Bytes);
            buffer.put(EQUALS_UTF8_BYTES);
            if (MethodDictionaryDataProvider.isMethodReturned(result)) {
                int offset = classNameOffsets[i];
                this.writeUTF8Bytes(stringData, offset, buffer);
                buffer.put(NAME_SEPARATOR_UTF8_BYTES);
                offset = methodNameOffsets[i];
                this.writeUTF8Bytes(stringData, offset, buffer);
            }
            buffer.put(NEW_LINE_UTF8_BYTES);
        }
        buffer.flip();
        byte[] returnBytes = new byte[buffer.limit()];
        buffer.get(returnBytes);
        return returnBytes;
    }

    private static final boolean isMethodReturned(int result) {
        return result == 0;
    }

    private static final boolean isMethodReturnedOrInvalid(int result) {
        return MethodDictionaryDataProvider.isMethodReturned(result) || result == 23;
    }

    private void writeUTF8Bytes(byte[] stringData, int offset, ByteBuffer destination) {
        byte b;
        if (offset < 0 || stringData == null || destination == null) {
            return;
        }
        while (offset < stringData.length && (b = stringData[offset]) != 0) {
            destination.put(b);
            ++offset;
        }
    }

    private static byte[] getUTF8(String s) {
        try {
            return s.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            return s.getBytes();
        }
    }

    private static byte[] getUTF8(long l) {
        return MethodDictionaryDataProvider.getUTF8(Long.toHexString(l));
    }

    @Override
    public Map<String, String> getLiveSourceDetails() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", TAG);
        map.put("version", VERSION);
        map.put("suggested_update_frequency", PARSERTIME);
        map.put("max_bytes_to_send", String.valueOf(5461));
        map.put("size_of_header", String.valueOf(EYE_CATCHER_UTF8_BYTES.length));
        map.put("complete_chunks_data", COMPLETE_BUFFERS);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modify(String command, String ... params) throws ProviderModificationException {
        if (command != null && command.equals("request")) {
            Object object = this.methodQueryLock;
            synchronized (object) {
                for (String methodId : params) {
                    if (methodId == null) continue;
                    try {
                        Long methodAsLong = Long.valueOf(methodId, 16);
                        this.idsToLookup.add(methodAsLong);
                    }
                    catch (NumberFormatException e) {
                        this.logger.warning(e.toString());
                        throw new ProviderModificationException(e);
                    }
                }
            }
        } else {
            String description = MessageFormat.format(Messages.getString("MethodDictionaryDataProvider.unexpected.command"), this.getClass(), command);
            this.logger.warning(description);
            throw new ProviderModificationException(description);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetData() {
        Object object = this.methodQueryLock;
        synchronized (object) {
            this.idsToLookup.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startSession() {
        Object object = this.methodQueryLock;
        synchronized (object) {
            this.resetData();
            this.sendEyeCatcher = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getRequestQueueSize() {
        Object object = this.methodQueryLock;
        synchronized (object) {
            return this.idsToLookup.size();
        }
    }
}

