/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.agent.mbean;

import com.ibm.java.diagnostics.healthcenter.agent.dataproviders.DataCollectionLevel;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.AgentLogFactory;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.Messages;
import com.ibm.oti.vm.VM;
import java.io.File;
import java.io.FileInputStream;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HealthCenterOptionHandler {
    private static final String KEEP_ALIVE = "keepAlive";
    private static final String DYNAMIC_TRACE = "dynamicTrace";
    private static final String NODYNAMIC_TRACE_OVERRIDE_PROPERTY = "com.ibm.java.diagnostics.healthcenter.leave.dynamic.trace";
    private static final String DATA_COLLECTION_LEVEL_PROPERTY = "com.ibm.java.diagnostics.healthcenter.data.collection.level";
    private final Logger logger;
    private static final String HEALTHCENTER_PROPERTIES_FILE_NAME = "healthcenter.properties";
    private static final String MAX_CIRCULAR_BUFFER_SIZE_PROPERTY = "com.ibm.java.diagnostics.healthcenter.agent.bufferSize";
    private static final String LIB = "lib";
    private static final String TRUE = Boolean.TRUE.toString();
    private static final String JAVA_HOME = "java.home";
    private static final Pattern LEVEL_MATCHER = Pattern.compile("level[:|=](.*)");
    private static final Pattern PORT_MATCHER = Pattern.compile("port[:|=]([0-9]*)");
    public static final String CONFIG_LOCATION_PROPERTY = "com.ibm.java.diagnostics.healthcenter.agent.properties.file";
    public static final String AUTHENTICATION_LOCATION_PROPERTY = "com.ibm.java.diagnostics.healthcenter.agent.authentication.file";
    private String autheFile = null;
    public static final String AUTHORIZATION_LOCATION_PROPERTY = "com.ibm.java.diagnostics.healthcenter.agent.authorization.file";
    private String authoFile = null;
    public static final String START_DELAY_PROPERTY = "com.ibm.java.diagnostics.healthcenter.agent.start.delay.seconds";
    private int startDelaySeconds = 0;
    public static final String RMI_HOSTNAME_PROPERTY = "java.rmi.server.hostname";
    public static final String JMX_BUILDER_PROPERTY = "javax.management.builder.initial";
    public static final String CLEAR_BUILDER_PROPERTY = "com.ibm.java.diagnostics.healthcenter.clear.jmx.initial.builder";
    private boolean tryOverrideBuilder = false;
    public static final String USE_PLATFORM_MBEANSERVER_PROPERTY = "com.ibm.java.diagnostics.healthcenter.use.platformmbeanserver";
    private boolean usePlatformMBeanServer = false;
    public static final String AGENT_PORT_PROPERTY = "com.ibm.java.diagnostics.healthcenter.agent.port";
    private int startPort = 1972;
    private int pid = 0;
    private Set<String> agentArguments = new HashSet<String>();
    private Properties props = null;

    public HealthCenterOptionHandler(String[] args) {
        String errorMsg = null;
        String pidString = args != null && args.length > 0 ? args[0] : System.getProperty("sun.java.launcher.pid");
        try {
            this.pid = Integer.parseInt(pidString);
            AgentLogFactory.setPid(this.pid);
        }
        catch (Throwable e) {
            errorMsg = MessageFormat.format(Messages.getString("HCLaunchMBean.invalid.process.id"), pidString);
        }
        this.logger = AgentLogFactory.setUpLogging(this.getClass());
        if (errorMsg != null) {
            this.logger.warning(errorMsg);
        }
        if (args.length > 1) {
            String[] agentArgumentsArray;
            for (String argument : agentArgumentsArray = args[1].split(",")) {
                this.agentArguments.add(argument);
            }
        }
        this.populateProperties();
    }

    public int getPid() {
        return this.pid;
    }

    public boolean isDynamicOverride() {
        for (String argument : this.agentArguments) {
            if (!argument.trim().equals(DYNAMIC_TRACE)) continue;
            return true;
        }
        String property = this.findProperty(NODYNAMIC_TRACE_OVERRIDE_PROPERTY);
        return property != null;
    }

    public DataCollectionLevel getDataCollectionLevel() {
        for (String argument : this.agentArguments) {
            Matcher matcher = LEVEL_MATCHER.matcher(argument);
            if (!matcher.find()) continue;
            String levelString = matcher.group(1);
            DataCollectionLevel level = this.getLevelFromString(levelString);
            return level;
        }
        String property = this.findProperty(DATA_COLLECTION_LEVEL_PROPERTY);
        if (property != null) {
            DataCollectionLevel level = this.getLevelFromString(property);
            return level;
        }
        return DataCollectionLevel.FULL;
    }

    private DataCollectionLevel getLevelFromString(String levelString) {
        String uppercaseLevelString = levelString.toUpperCase();
        DataCollectionLevel level = DataCollectionLevel.valueOf(uppercaseLevelString);
        return level;
    }

    private void populateProperties() {
        String usePlatMBeanProp;
        String clearBuilderProp;
        String message;
        String timeout = this.findProperty(START_DELAY_PROPERTY);
        String warningTemplate = Messages.getString("HCLaunchMBean.bad.integer");
        if (timeout != null) {
            try {
                this.startDelaySeconds = new Integer(timeout);
                String template = Messages.getString("HCLaunchMBean.start.delay.overridden");
                String message2 = MessageFormat.format(template, START_DELAY_PROPERTY, this.startDelaySeconds);
                this.logger.config(message2);
            }
            catch (Throwable e) {
                String template = warningTemplate;
                message = MessageFormat.format(template, START_DELAY_PROPERTY, timeout);
                this.logger.warning(message);
            }
        }
        if ((clearBuilderProp = this.findProperty(CLEAR_BUILDER_PROPERTY)) != null && clearBuilderProp.equals(TRUE)) {
            this.tryOverrideBuilder = true;
            this.logger.config(MessageFormat.format(Messages.getString("HCLaunchMBean.override"), CLEAR_BUILDER_PROPERTY, JMX_BUILDER_PROPERTY));
        }
        if ((usePlatMBeanProp = this.findProperty(USE_PLATFORM_MBEANSERVER_PROPERTY)) != null && usePlatMBeanProp.equals(TRUE)) {
            this.usePlatformMBeanServer = true;
            message = MessageFormat.format(Messages.getString("HCLaunchMBean.using.platform.mbean.server"), USE_PLATFORM_MBEANSERVER_PROPERTY);
            this.logger.config(message);
        }
        this.workOutStartPort();
        this.autheFile = this.findProperty(AUTHENTICATION_LOCATION_PROPERTY);
        this.authoFile = this.findProperty(AUTHORIZATION_LOCATION_PROPERTY);
    }

    private void workOutStartPort() {
        String tempPortOverride;
        Iterator<String> it = this.agentArguments.iterator();
        boolean foundPort = false;
        while (it.hasNext()) {
            String argument = it.next();
            Matcher matcher = PORT_MATCHER.matcher(argument);
            if (!matcher.find()) continue;
            String portString = matcher.group(1);
            this.startPort = Integer.parseInt(portString);
            foundPort = true;
        }
        if (!foundPort && (tempPortOverride = this.findProperty(AGENT_PORT_PROPERTY)) != null) {
            try {
                this.startPort = new Integer(tempPortOverride);
                this.logger.config(MessageFormat.format(Messages.getString("HCLaunchMBean.overriding.start.port"), AGENT_PORT_PROPERTY, this.startPort));
            }
            catch (Throwable e) {
                String warningTemplate = Messages.getString("HCLaunchMBean.bad.integer");
                this.logger.warning(MessageFormat.format(warningTemplate, AGENT_PORT_PROPERTY, this.startPort));
            }
        }
    }

    private Properties getHealthCenterProperties() {
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.log(Level.FINER, "Requested health center properties.");
        }
        if (this.props == null) {
            File propsFile = null;
            String fileName = System.getProperty(CONFIG_LOCATION_PROPERTY);
            if (fileName != null) {
                propsFile = new File(fileName);
            }
            if (propsFile == null || !propsFile.exists()) {
                propsFile = new File(HEALTHCENTER_PROPERTIES_FILE_NAME);
            }
            if (propsFile == null || !propsFile.exists()) {
                String javaHome = System.getProperty(JAVA_HOME);
                File libDirectory = new File(javaHome, LIB);
                propsFile = new File(libDirectory, HEALTHCENTER_PROPERTIES_FILE_NAME);
            }
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.log(Level.FINEST, MessageFormat.format("Loading health center properties from {0}.", propsFile.getAbsolutePath()));
            }
            if (propsFile.exists() && propsFile.canRead()) {
                try {
                    FileInputStream stream = new FileInputStream(propsFile);
                    this.props = new Properties();
                    this.props.load(stream);
                }
                catch (Exception e) {
                    if (this.logger.isLoggable(Level.WARNING)) {
                        String template = Messages.getString("HCLaunchMBean.could.not.load.properties");
                        String warning = MessageFormat.format(template, propsFile.getAbsolutePath());
                        this.logger.log(Level.WARNING, warning, e);
                    }
                }
            } else if (this.logger.isLoggable(Level.WARNING)) {
                String template = Messages.getString("HCLaunchMBean.bad.properties.file");
                String warning = MessageFormat.format(template, propsFile.getAbsolutePath());
                this.logger.warning(warning);
            }
        }
        if (this.logger.isLoggable(Level.FINER)) {
            String message = MessageFormat.format("Returning health center properties {0}", this.props);
            this.logger.log(Level.FINER, message);
        }
        return this.props;
    }

    private String findProperty(String key) {
        if (this.logger.isLoggable(Level.FINER)) {
            String message = MessageFormat.format("Requested {0} property.", key);
            this.logger.log(Level.FINER, message);
        }
        String value = System.getProperty(key);
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.log(Level.FINEST, MessageFormat.format("{0} property is {1} in system properties.", key, value));
        }
        if (value == null) {
            Properties props;
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.log(Level.FINEST, MessageFormat.format("Requesting {0} from health center properties.", key));
            }
            if ((props = this.getHealthCenterProperties()) != null) {
                value = props.getProperty(key);
                if (this.logger.isLoggable(Level.FINEST)) {
                    String template = "Health center properties existed and {0} was {1}.";
                    String message = MessageFormat.format("Health center properties existed and {0} was {1}.", key, value);
                    this.logger.log(Level.FINEST, message);
                }
            }
        }
        if (this.logger.isLoggable(Level.FINER)) {
            String template = "Returning {0} for {1} property.";
            String message = MessageFormat.format("Returning {0} for {1} property.", value, key);
            this.logger.log(Level.FINER, message);
        }
        return value;
    }

    public String getAutheFile() {
        return this.autheFile;
    }

    public String getAuthoFile() {
        return this.authoFile;
    }

    public int getStartDelaySeconds() {
        return this.startDelaySeconds;
    }

    public boolean isTryOverrideBuilder() {
        return this.tryOverrideBuilder;
    }

    public boolean isUsePlatformMBeanServer() {
        return this.usePlatformMBeanServer;
    }

    public int getStartPort() {
        return this.startPort;
    }

    public String getMaxCircularBufferSize() {
        return this.findProperty(MAX_CIRCULAR_BUFFER_SIZE_PROPERTY);
    }

    public boolean isKeepAlive() {
        for (String argument : this.agentArguments) {
            if (!KEEP_ALIVE.equals(argument)) continue;
            return true;
        }
        return false;
    }

    public String[] getVMArgs() {
        return VM.getVMArgs();
    }
}

