/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.launchpad;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class BrowserLauncher {
    private static int jvm;
    private static Object browser;
    private static boolean loadedWithoutErrors;
    private static Class mrjFileUtilsClass;
    private static Class mrjOSTypeClass;
    private static Class aeDescClass;
    private static Constructor aeTargetConstructor;
    private static Constructor appleEventConstructor;
    private static Constructor aeDescConstructor;
    private static Method findFolder;
    private static Method getFileCreator;
    private static Method getFileType;
    private static Method openURL;
    private static Method makeOSType;
    private static Method putParameter;
    private static Method sendNoReply;
    private static Object kSystemFolderType;
    private static Integer keyDirectObject;
    private static Integer kAutoGenerateReturnID;
    private static Integer kAnyTransactionID;
    private static Object linkage;
    private static final String JDirect_MacOSX = "/System/Library/Frameworks/Carbon.framework/Frameworks/HIToolbox.framework/HIToolbox";
    private static final int MRJ_2_0 = 0;
    private static final int MRJ_2_1 = 1;
    private static final int MRJ_3_0 = 3;
    private static final int MRJ_3_1 = 4;
    private static final int WINDOWS_NT = 5;
    private static final int WINDOWS_9x = 6;
    private static final int OTHER = -1;
    private static final String FINDER_TYPE = "FNDR";
    private static final String FINDER_CREATOR = "MACS";
    private static final String GURL_EVENT = "GURL";
    private static final String FIRST_WINDOWS_PARAMETER = "/c";
    private static final String SECOND_WINDOWS_PARAMETER = "start";
    private static final String THIRD_WINDOWS_PARAMETER = "\"\"";
    private static final String NETSCAPE_REMOTE_PARAMETER = "-remote";
    private static final String NETSCAPE_OPEN_PARAMETER_START = "'openURL(";
    private static final String NETSCAPE_OPEN_PARAMETER_END = ")'";
    private static String errorMessage;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    static {
        block9: {
            loadedWithoutErrors = true;
            String s = System.getProperty("os.name");
            if (s.startsWith("Mac OS")) {
                String s1 = System.getProperty("mrj.version");
                String s2 = s1.substring(0, 3);
                try {
                    double d = Double.valueOf(s2);
                    if (d == 2.0) {
                        jvm = 0;
                        break block9;
                    }
                    if (d >= 2.1 && d < 3.0) {
                        jvm = 1;
                        break block9;
                    }
                    if (d == 3.0) {
                        jvm = 3;
                        break block9;
                    }
                    if (d >= 3.1) {
                        jvm = 4;
                        break block9;
                    }
                    loadedWithoutErrors = false;
                    errorMessage = "Unsupported MRJ version: " + d;
                }
                catch (NumberFormatException numberformatexception) {
                    loadedWithoutErrors = false;
                    errorMessage = "Invalid MRJ version: " + s1;
                }
            } else {
                jvm = s.startsWith("Windows") ? (s.indexOf("9") != -1 ? 6 : 5) : -1;
            }
        }
        if (loadedWithoutErrors) {
            loadedWithoutErrors = BrowserLauncher.loadClasses();
        }
    }

    private BrowserLauncher() {
    }

    private static boolean loadClasses() {
        switch (jvm) {
            default: {
                break;
            }
            case 0: {
                try {
                    Class<?> class1 = Class.forName("com.apple.MacOS.AETarget");
                    Class<?> class3 = Class.forName("com.apple.MacOS.OSUtils");
                    Class<?> class4 = Class.forName("com.apple.MacOS.AppleEvent");
                    Class<?> class5 = Class.forName("com.apple.MacOS.ae");
                    aeDescClass = Class.forName("com.apple.MacOS.AEDesc");
                    aeTargetConstructor = class1.getDeclaredConstructor(Integer.TYPE);
                    appleEventConstructor = class4.getDeclaredConstructor(Integer.TYPE, Integer.TYPE, class1, Integer.TYPE, Integer.TYPE);
                    Class[] classArray = new Class[1];
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("java.lang.String");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    classArray[0] = clazz;
                    aeDescConstructor = aeDescClass.getDeclaredConstructor(classArray);
                    Class[] classArray2 = new Class[1];
                    Class<?> clazz2 = class$0;
                    if (clazz2 == null) {
                        try {
                            clazz2 = class$0 = Class.forName("java.lang.String");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    classArray2[0] = clazz2;
                    makeOSType = class3.getDeclaredMethod("makeOSType", classArray2);
                    putParameter = class4.getDeclaredMethod("putParameter", Integer.TYPE, aeDescClass);
                    sendNoReply = class4.getDeclaredMethod("sendNoReply", new Class[0]);
                    Field field1 = class5.getDeclaredField("keyDirectObject");
                    keyDirectObject = (Integer)field1.get(null);
                    Field field2 = class4.getDeclaredField("kAutoGenerateReturnID");
                    kAutoGenerateReturnID = (Integer)field2.get(null);
                    Field field3 = class4.getDeclaredField("kAnyTransactionID");
                    kAnyTransactionID = (Integer)field3.get(null);
                    break;
                }
                catch (ClassNotFoundException classnotfoundexception) {
                    errorMessage = classnotfoundexception.getMessage();
                    return false;
                }
                catch (NoSuchMethodException nosuchmethodexception) {
                    errorMessage = nosuchmethodexception.getMessage();
                    return false;
                }
                catch (NoSuchFieldException nosuchfieldexception1) {
                    errorMessage = nosuchfieldexception1.getMessage();
                    return false;
                }
                catch (IllegalAccessException illegalaccessexception) {
                    errorMessage = illegalaccessexception.getMessage();
                    return false;
                }
            }
            case 1: {
                try {
                    mrjFileUtilsClass = Class.forName("com.apple.mrj.MRJFileUtils");
                    mrjOSTypeClass = Class.forName("com.apple.mrj.MRJOSType");
                    Field field = mrjFileUtilsClass.getDeclaredField("kSystemFolderType");
                    kSystemFolderType = field.get(null);
                    findFolder = mrjFileUtilsClass.getDeclaredMethod("findFolder", mrjOSTypeClass);
                    Class[] classArray = new Class[1];
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("java.io.File");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    classArray[0] = clazz;
                    getFileCreator = mrjFileUtilsClass.getDeclaredMethod("getFileCreator", classArray);
                    Class[] classArray3 = new Class[1];
                    Class<?> clazz3 = class$1;
                    if (clazz3 == null) {
                        try {
                            clazz3 = class$1 = Class.forName("java.io.File");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    classArray3[0] = clazz3;
                    getFileType = mrjFileUtilsClass.getDeclaredMethod("getFileType", classArray3);
                    break;
                }
                catch (ClassNotFoundException classnotfoundexception1) {
                    errorMessage = classnotfoundexception1.getMessage();
                    return false;
                }
                catch (NoSuchFieldException nosuchfieldexception) {
                    errorMessage = nosuchfieldexception.getMessage();
                    return false;
                }
                catch (NoSuchMethodException nosuchmethodexception3) {
                    errorMessage = nosuchmethodexception3.getMessage();
                    return false;
                }
                catch (SecurityException securityexception) {
                    errorMessage = securityexception.getMessage();
                    return false;
                }
                catch (IllegalAccessException illegalaccessexception1) {
                    errorMessage = illegalaccessexception1.getMessage();
                    return false;
                }
            }
            case 3: {
                try {
                    Class<?> class2 = Class.forName("com.apple.mrj.jdirect.Linker");
                    Class[] classArray = new Class[1];
                    Class<?> clazz = class$2;
                    if (clazz == null) {
                        try {
                            clazz = class$2 = Class.forName("java.lang.Class");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    classArray[0] = clazz;
                    Constructor<?> constructor = class2.getConstructor(classArray);
                    Object[] objectArray = new Object[1];
                    Class<?> clazz4 = class$3;
                    if (clazz4 == null) {
                        try {
                            clazz4 = class$3 = Class.forName("com.ibm.ws.install.launchpad.BrowserLauncher");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    objectArray[0] = clazz4;
                    linkage = constructor.newInstance(objectArray);
                    break;
                }
                catch (ClassNotFoundException classnotfoundexception2) {
                    errorMessage = classnotfoundexception2.getMessage();
                    return false;
                }
                catch (NoSuchMethodException nosuchmethodexception1) {
                    errorMessage = nosuchmethodexception1.getMessage();
                    return false;
                }
                catch (InvocationTargetException invocationtargetexception) {
                    errorMessage = invocationtargetexception.getMessage();
                    return false;
                }
                catch (InstantiationException instantiationexception) {
                    errorMessage = instantiationexception.getMessage();
                    return false;
                }
                catch (IllegalAccessException illegalaccessexception2) {
                    errorMessage = illegalaccessexception2.getMessage();
                    return false;
                }
            }
            case 4: {
                try {
                    mrjFileUtilsClass = Class.forName("com.apple.mrj.MRJFileUtils");
                    Class[] classArray = new Class[1];
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("java.lang.String");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    classArray[0] = clazz;
                    openURL = mrjFileUtilsClass.getDeclaredMethod("openURL", classArray);
                    break;
                }
                catch (ClassNotFoundException classnotfoundexception3) {
                    errorMessage = classnotfoundexception3.getMessage();
                    return false;
                }
                catch (NoSuchMethodException nosuchmethodexception2) {
                    errorMessage = nosuchmethodexception2.getMessage();
                    return false;
                }
            }
        }
        return true;
    }

    private static Object locateBrowser() {
        if (browser != null) {
            return browser;
        }
        switch (jvm) {
            case 0: {
                try {
                    Integer integer = (Integer)makeOSType.invoke(null, FINDER_CREATOR);
                    Object obj = aeTargetConstructor.newInstance(integer);
                    Integer integer1 = (Integer)makeOSType.invoke(null, GURL_EVENT);
                    Object obj1 = appleEventConstructor.newInstance(integer1, integer1, obj, kAutoGenerateReturnID, kAnyTransactionID);
                    return obj1;
                }
                catch (IllegalAccessException illegalaccessexception) {
                    browser = null;
                    errorMessage = illegalaccessexception.getMessage();
                    return browser;
                }
                catch (InstantiationException instantiationexception) {
                    browser = null;
                    errorMessage = instantiationexception.getMessage();
                    return browser;
                }
                catch (InvocationTargetException invocationtargetexception) {
                    browser = null;
                    errorMessage = invocationtargetexception.getMessage();
                    return browser;
                }
            }
            case 1: {
                File file;
                try {
                    file = (File)findFolder.invoke(null, kSystemFolderType);
                }
                catch (IllegalArgumentException illegalargumentexception) {
                    browser = null;
                    errorMessage = illegalargumentexception.getMessage();
                    return browser;
                }
                catch (IllegalAccessException illegalaccessexception1) {
                    browser = null;
                    errorMessage = illegalaccessexception1.getMessage();
                    return browser;
                }
                catch (InvocationTargetException invocationtargetexception1) {
                    browser = null;
                    errorMessage = invocationtargetexception1.getTargetException().getClass() + ": " + invocationtargetexception1.getTargetException().getMessage();
                    return browser;
                }
                String[] as = file.list();
                int i = 0;
                while (i < as.length) {
                    try {
                        Object obj3;
                        Object obj2;
                        File file1 = new File(file, as[i]);
                        if (file1.isFile() && FINDER_TYPE.equals((obj2 = getFileType.invoke(null, file1)).toString()) && FINDER_CREATOR.equals((obj3 = getFileCreator.invoke(null, file1)).toString())) {
                            browser = file1.toString();
                            return browser;
                        }
                    }
                    catch (IllegalArgumentException illegalargumentexception1) {
                        errorMessage = illegalargumentexception1.getMessage();
                        return null;
                    }
                    catch (IllegalAccessException illegalaccessexception2) {
                        browser = null;
                        errorMessage = illegalaccessexception2.getMessage();
                        return browser;
                    }
                    catch (InvocationTargetException invocationtargetexception2) {
                        browser = null;
                        errorMessage = invocationtargetexception2.getTargetException().getClass() + ": " + invocationtargetexception2.getTargetException().getMessage();
                        return browser;
                    }
                    ++i;
                }
                browser = null;
                break;
            }
            case 3: 
            case 4: {
                browser = "";
                break;
            }
            case 5: {
                browser = "cmd.exe";
                break;
            }
            case 6: {
                browser = "command.com";
                break;
            }
            default: {
                browser = "netscape";
            }
        }
        return browser;
    }

    public static void openURL(String s) throws IOException {
        if (!loadedWithoutErrors) {
            throw new IOException("Exception in finding browser: " + errorMessage);
        }
        Object obj = BrowserLauncher.locateBrowser();
        if (obj == null) {
            throw new IOException("Unable to locate browser: " + errorMessage);
        }
        switch (jvm) {
            case 0: {
                Object obj1 = null;
                try {
                    try {
                        Object obj2 = aeDescConstructor.newInstance(s);
                        putParameter.invoke(obj, keyDirectObject, obj2);
                        sendNoReply.invoke(obj, new Object[0]);
                    }
                    catch (InvocationTargetException invocationtargetexception) {
                        throw new IOException("InvocationTargetException while creating AEDesc: " + invocationtargetexception.getMessage());
                    }
                    catch (IllegalAccessException illegalaccessexception) {
                        throw new IOException("IllegalAccessException while building AppleEvent: " + illegalaccessexception.getMessage());
                    }
                    catch (InstantiationException instantiationexception) {
                        throw new IOException("InstantiationException while creating AEDesc: " + instantiationexception.getMessage());
                    }
                    Object var4_8 = null;
                    Object obj3 = null;
                    obj = null;
                    break;
                }
                catch (Throwable throwable) {
                    Object var4_9 = null;
                    Object obj3 = null;
                    obj = null;
                    throw throwable;
                }
            }
            case 1: {
                Runtime.getRuntime().exec(new String[]{(String)obj, s});
                break;
            }
            case 3: {
                int[] ai = new int[1];
                int i = BrowserLauncher.ICStart(ai, 0);
                if (i == 0) {
                    int[] ai1 = new int[1];
                    byte[] abyte0 = s.getBytes();
                    int[] ai2 = new int[]{abyte0.length};
                    i = BrowserLauncher.ICLaunchURL(ai[0], new byte[1], abyte0, abyte0.length, ai1, ai2);
                    if (i == 0) {
                        BrowserLauncher.ICStop(ai);
                        break;
                    }
                    throw new IOException("Unable to launch URL: " + i);
                }
                throw new IOException("Unable to create an Internet Config instance: " + i);
            }
            case 4: {
                try {
                    openURL.invoke(null, s);
                    break;
                }
                catch (InvocationTargetException invocationtargetexception1) {
                    throw new IOException("InvocationTargetException while calling openURL: " + invocationtargetexception1.getMessage());
                }
                catch (IllegalAccessException illegalaccessexception1) {
                    throw new IOException("IllegalAccessException while calling openURL: " + illegalaccessexception1.getMessage());
                }
            }
            case 5: 
            case 6: {
                Process process = Runtime.getRuntime().exec(new String[]{(String)obj, FIRST_WINDOWS_PARAMETER, SECOND_WINDOWS_PARAMETER, THIRD_WINDOWS_PARAMETER, String.valueOf('\"') + s + '\"'});
                try {
                    process.waitFor();
                    process.exitValue();
                    break;
                }
                catch (InterruptedException interruptedexception) {
                    throw new IOException("InterruptedException while launching browser: " + interruptedexception.getMessage());
                }
            }
            case -1: {
                Process process1 = Runtime.getRuntime().exec(new String[]{(String)obj, NETSCAPE_REMOTE_PARAMETER, NETSCAPE_OPEN_PARAMETER_START + s + NETSCAPE_OPEN_PARAMETER_END});
                try {
                    int j = process1.waitFor();
                    if (j == 0) break;
                    Runtime.getRuntime().exec(new String[]{(String)obj, s});
                    break;
                }
                catch (InterruptedException interruptedexception1) {
                    throw new IOException("InterruptedException while launching browser: " + interruptedexception1.getMessage());
                }
            }
            default: {
                Runtime.getRuntime().exec(new String[]{(String)obj, s});
            }
        }
    }

    private static native int ICStart(int[] var0, int var1);

    private static native int ICStop(int[] var0);

    private static native int ICLaunchURL(int var0, byte[] var1, byte[] var2, int var3, int[] var4, int[] var5);
}

