/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.launchpad;

import com.ibm.ws.install.launchpad.BrowserLauncher;
import com.ibm.ws.install.launchpad.LaunchPadBrowserPane;
import com.ibm.ws.install.launchpad.LookInToVPD;
import com.ibm.ws.install.launchpad.ProcUtl;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;

public class CmdRunner
implements Runnable {
    private String cmd = null;
    private Locale loc = null;
    private ResourceBundle myResources = null;
    private static final String WIN_ID = "Windows";
    private static final String WIN_PATH = "rundll32";
    private static final String WIN_FLAG = "url.dll,FileProtocolHandler";

    public CmdRunner(String c, Locale l) {
        this.cmd = c;
        this.loc = l;
        Locale.setDefault(l);
        this.myResources = ResourceBundle.getBundle("com.ibm.ws.install.launchpad.LaunchPadResources", l);
    }

    public void run() {
        try {
            StringTokenizer tok = new StringTokenizer(this.cmd, ",");
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken();
                if (token.startsWith("exec://")) {
                    String command;
                    String[] tmpCmd;
                    String[] cmdExecArray;
                    String cmd_exec = token.substring(7);
                    int typ = 0;
                    if (cmd_exec.startsWith("INST ")) {
                        typ = 1;
                        cmd_exec = cmd_exec.substring("INST ".length()).trim();
                    } else if (cmd_exec.startsWith("CFGS ")) {
                        typ = 2;
                        cmd_exec = cmd_exec.substring("CFGS ".length()).trim();
                    } else if (cmd_exec.startsWith("CFGP ")) {
                        typ = 3;
                        cmd_exec = cmd_exec.substring("CFGP ".length()).trim();
                    }
                    ProcUtl proc = new ProcUtl();
                    StringBuffer outSb = new StringBuffer();
                    StringBuffer errSb = new StringBuffer();
                    Object configFile = null;
                    Object confPath = null;
                    String title = null;
                    File cmdfile = null;
                    if (System.getProperty("os.name").toUpperCase().startsWith("WINDOWS")) {
                        int i2;
                        int i1 = cmd_exec.indexOf(".");
                        if (i1 < 0) {
                            i1 = 32000;
                        }
                        if ((i2 = cmd_exec.indexOf(" ")) < 0) {
                            i2 = 32000;
                        }
                        if (i2 < i1) {
                            i1 = i2;
                        }
                        title = i1 < 32000 ? cmd_exec.substring(0, i1) : cmd_exec;
                        String[] comd = new String[20];
                        int iii = 0;
                        comd[iii++] = "cmd.exe";
                        comd[iii++] = "/c";
                        comd[iii++] = "start";
                        comd[iii++] = CmdRunner.quote(title);
                        String entry = LookInToVPD.getEntry("IBMICA");
                        if (entry == null && (typ == 2 || typ == 3)) {
                            JOptionPane.showMessageDialog(null, this.myResources.getString("msg2"));
                            return;
                        }
                        String installDir = LookInToVPD.getInstallDir(entry);
                        if (typ == 1) {
                            comd[iii++] = "execexit";
                        } else if (typ == 2) {
                            comd[iii++] = "execexit";
                        } else if (typ == 3) {
                            comd[iii++] = "execpause";
                        }
                        String[] cmdExecArray2 = this.splitCommand(cmd_exec);
                        if (typ == 2 || typ == 3) {
                            cmdExecArray2[0] = CmdRunner.quote(String.valueOf(installDir) + cmdExecArray2[0]);
                        }
                        System.arraycopy(cmdExecArray2, 0, comd, iii, cmdExecArray2.length);
                        String[] tmpCmd2 = comd;
                        comd = new String[iii += cmdExecArray2.length];
                        System.arraycopy(tmpCmd2, 0, comd, 0, iii);
                        tmpCmd2 = null;
                        String command2 = comd[0];
                        int i = 1;
                        while (i < iii) {
                            command2 = String.valueOf(command2) + "    " + comd[i];
                            ++i;
                        }
                        if (cmd_exec.indexOf(".") > -1) {
                            String tmp = cmd_exec.substring(0, cmd_exec.indexOf("."));
                            cmd_exec = String.valueOf(tmp) + ".bat";
                        }
                        if (typ != 0) {
                            cmdfile = typ != 1 ? new File(String.valueOf(installDir) + cmd_exec) : new File(cmd_exec);
                            if (cmdfile.exists()) {
                                int exitProc = proc.system(comd, false, null, (Object)outSb, (Object)errSb);
                                continue;
                            }
                            if (typ != 1) {
                                JOptionPane.showMessageDialog(null, this.myResources.getString("msg3"));
                                continue;
                            }
                            JOptionPane.showMessageDialog(null, this.myResources.getString("msg1"));
                            continue;
                        }
                        int n = proc.execcmd(cmd_exec, false, null, (Object)outSb, (Object)errSb);
                        continue;
                    }
                    if (System.getProperty("os.name").toUpperCase().startsWith("AIX")) {
                        String[] comd = new String[20];
                        int iii = 0;
                        comd[iii++] = "/usr/dt/bin/dtterm";
                        comd[iii++] = "-e";
                        String entry = LookInToVPD.getEntry("IBMICA");
                        if (entry == null && (typ == 2 || typ == 3)) {
                            JOptionPane.showMessageDialog(null, this.myResources.getString("msg2"));
                            return;
                        }
                        String installDir = LookInToVPD.getInstallDir(entry);
                        if (typ == 3) {
                            comd[iii++] = "./execpause";
                        }
                        cmdExecArray = this.splitCommand(cmd_exec);
                        if (typ == 2 || typ == 3) {
                            cmdExecArray[0] = CmdRunner.quote(String.valueOf(installDir) + cmdExecArray[0]);
                        }
                        System.arraycopy(cmdExecArray, 0, comd, iii, cmdExecArray.length);
                        tmpCmd = comd;
                        comd = new String[iii += cmdExecArray.length];
                        System.arraycopy(tmpCmd, 0, comd, 0, iii);
                        tmpCmd = null;
                        command = comd[0];
                        int i = 1;
                        while (i < iii) {
                            command = String.valueOf(command) + "    " + comd[i];
                            ++i;
                        }
                        if (cmd_exec.indexOf(" ") > -1) {
                            String tmp;
                            cmd_exec = tmp = cmd_exec.substring(0, cmd_exec.indexOf(" "));
                        }
                        if (typ != 0) {
                            cmdfile = typ != 1 ? new File(String.valueOf(installDir) + cmd_exec) : new File(cmd_exec);
                            if (cmdfile.exists()) {
                                int exitProc = proc.system(command, false, null, (Object)outSb, (Object)errSb);
                                continue;
                            }
                            if (typ != 1) {
                                JOptionPane.showMessageDialog(null, this.myResources.getString("msg3"));
                                continue;
                            }
                            JOptionPane.showMessageDialog(null, this.myResources.getString("msg1"));
                            continue;
                        }
                        int exitProc = proc.system(command, false, null, (Object)outSb, (Object)errSb);
                        continue;
                    }
                    if (!System.getProperty("os.name").toUpperCase().startsWith("LINUX")) continue;
                    String[] comd = new String[20];
                    int iii = 0;
                    comd[iii++] = "[ -x /usr/bin/X11/kterm ] && TERM=/usr/bin/X11/kterm ||TERM=/usr/bin/X11/xterm\n";
                    comd[iii++] = "$TERM ";
                    comd[iii++] = "-e";
                    String entry = LookInToVPD.getEntry("IBMICA");
                    if (entry == null && (typ == 2 || typ == 3)) {
                        JOptionPane.showMessageDialog(null, this.myResources.getString("msg2"));
                        return;
                    }
                    String installDir = LookInToVPD.getInstallDir(entry);
                    if (typ == 3) {
                        comd[iii++] = "./execpause";
                    }
                    cmdExecArray = this.splitCommand(cmd_exec);
                    if (typ == 2 || typ == 3) {
                        cmdExecArray[0] = CmdRunner.quote(String.valueOf(installDir) + cmdExecArray[0]);
                    }
                    System.arraycopy(cmdExecArray, 0, comd, iii, cmdExecArray.length);
                    tmpCmd = comd;
                    comd = new String[iii += cmdExecArray.length];
                    System.arraycopy(tmpCmd, 0, comd, 0, iii);
                    tmpCmd = null;
                    command = comd[0];
                    int i = 1;
                    while (i < iii) {
                        command = String.valueOf(command) + "    " + comd[i];
                        ++i;
                    }
                    if (cmd_exec.indexOf(" ") > -1) {
                        String tmp;
                        cmd_exec = tmp = cmd_exec.substring(0, cmd_exec.indexOf(" "));
                    }
                    if (typ != 0) {
                        cmdfile = typ != 1 ? new File(String.valueOf(installDir) + cmd_exec) : new File(cmd_exec);
                        if (cmdfile.exists()) {
                            int exitProc = proc.system(command, false, null, (Object)outSb, (Object)errSb);
                            continue;
                        }
                        if (typ != 1) {
                            JOptionPane.showMessageDialog(null, this.myResources.getString("msg3"));
                            continue;
                        }
                        JOptionPane.showMessageDialog(null, this.myResources.getString("msg1"));
                        continue;
                    }
                    int n = proc.system(command, false, null, (Object)outSb, (Object)errSb);
                    continue;
                }
                if (token.startsWith("http://")) {
                    if (System.getProperty("os.name").toUpperCase().startsWith("AIX") || System.getProperty("os.name").toUpperCase().startsWith("LINUX")) {
                        try {
                            Process process = Runtime.getRuntime().exec(new String[]{"which", "netscape"});
                            int exitCode = process.waitFor();
                            if (exitCode != 0 && (exitCode = (process = Runtime.getRuntime().exec(new String[]{"which", "mozilla"})).waitFor()) != 0) {
                                JOptionPane.showMessageDialog(null, this.myResources.getString("msg15"));
                                return;
                            }
                        }
                        catch (InterruptedException ie) {
                            throw new IOException("InterruptedException while launching browser: " + ie.getMessage());
                        }
                    }
                    CmdRunner.displayURL(token);
                    continue;
                }
                if (token.startsWith("file://")) {
                    StringBuffer outSb;
                    String command;
                    File tmpFile;
                    Process process;
                    String ext;
                    String[] comd;
                    String fis1 = new String(token.substring(7));
                    File itemfile = new File(fis1);
                    if (!itemfile.exists()) {
                        JOptionPane.showMessageDialog(null, this.myResources.getString("msg4"));
                        return;
                    }
                    if (System.getProperty("os.name").toUpperCase().startsWith("WINDOWS")) {
                        String[] comd2 = new String[]{"cmd.exe", "/c", "start", "\"\"", token.substring(7)};
                        ProcUtl proc = new ProcUtl();
                        StringBuffer outSb2 = new StringBuffer();
                        StringBuffer errSb = new StringBuffer();
                        File cmdfile = new File(comd2[4]);
                        if (!cmdfile.exists()) continue;
                        int title = proc.execcmd(comd2, false, null, (Object)outSb2, (Object)errSb);
                        continue;
                    }
                    if (System.getProperty("os.name").toUpperCase().startsWith("AIX")) {
                        int dim = 0;
                        comd = null;
                        int extpdf = token.substring(7).lastIndexOf(".");
                        ext = token.substring(7).substring(extpdf + 1);
                        if (ext.equals("pdf")) {
                            dim = 2;
                            comd = new String[dim];
                            comd[0] = "export PATH=$PATH:/usr/sbin:/usr/lpp/Acrobat4/bin:/usr/lpp/Acrobat5/bin;acroread";
                            comd[1] = CmdRunner.quote(token.substring(7));
                            boolean pdfFileExists = false;
                            String cmdString = comd[0].trim();
                            int pos0 = cmdString.indexOf("=");
                            int pos1 = cmdString.indexOf(";");
                            String strPath = cmdString.substring(pos0, pos1);
                            StringTokenizer st = new StringTokenizer(strPath, ":");
                            while (st.hasMoreTokens()) {
                                String ct = st.nextToken();
                                File pdffile = new File(String.valueOf(ct) + "/acroread");
                                if (!pdffile.exists()) continue;
                                pdfFileExists = true;
                            }
                            if (!pdfFileExists) {
                                JOptionPane.showMessageDialog(null, this.myResources.getString("msg5"));
                                return;
                            }
                        } else {
                            if (ext.equals("htm") || ext.equals("html")) {
                                try {
                                    String urlName;
                                    process = Runtime.getRuntime().exec(new String[]{"which", "netscape"});
                                    int exitCode = process.waitFor();
                                    if (exitCode != 0 && (exitCode = (process = Runtime.getRuntime().exec(new String[]{"which", "mozilla"})).waitFor()) != 0) {
                                        JOptionPane.showMessageDialog(null, this.myResources.getString("msg15"));
                                        return;
                                    }
                                    tmpFile = new File(token.substring(7));
                                    try {
                                        urlName = "file://" + tmpFile.getCanonicalPath();
                                    }
                                    catch (IOException ioEx) {
                                        urlName = token;
                                    }
                                    CmdRunner.displayURL(urlName);
                                    return;
                                }
                                catch (InterruptedException ie) {
                                    throw new IOException("InterruptedException while launching browser: " + ie.getMessage());
                                }
                            }
                            dim = 4;
                            comd = new String[dim];
                            comd[0] = "/usr/dt/bin/dtterm";
                            comd[1] = "-e";
                            comd[2] = "more";
                            comd[3] = token.substring(7);
                        }
                        command = comd[0];
                        int i = 1;
                        while (i < dim) {
                            command = String.valueOf(command) + " " + comd[i];
                            ++i;
                        }
                        ProcUtl proc = new ProcUtl();
                        outSb = new StringBuffer();
                        StringBuffer errSb = new StringBuffer();
                        File cmdfile = new File(token.substring(7));
                        if (!cmdfile.exists()) continue;
                        int n = proc.system(command, false, null, (Object)outSb, (Object)errSb);
                        continue;
                    }
                    if (!System.getProperty("os.name").toUpperCase().startsWith("LINUX")) continue;
                    int dim = 0;
                    comd = null;
                    int extpdf = token.substring(7).lastIndexOf(".");
                    ext = token.substring(7).substring(extpdf + 1);
                    if (ext.equals("pdf")) {
                        dim = 2;
                        comd = new String[dim];
                        comd[0] = "/usr/X11R6/bin/acroread";
                        comd[1] = token.substring(7);
                        File pdffile = new File(comd[0]);
                        if (!pdffile.exists()) {
                            JOptionPane.showMessageDialog(null, this.myResources.getString("msg5"));
                            return;
                        }
                    } else {
                        if (ext.equals("htm") || ext.equals("html")) {
                            try {
                                String urlName;
                                process = Runtime.getRuntime().exec(new String[]{"which", "netscape"});
                                int exitCode = process.waitFor();
                                if (exitCode != 0 && (exitCode = (process = Runtime.getRuntime().exec(new String[]{"which", "mozilla"})).waitFor()) != 0) {
                                    JOptionPane.showMessageDialog(null, this.myResources.getString("msg15"));
                                    return;
                                }
                                tmpFile = new File(token.substring(7));
                                try {
                                    urlName = "file://" + tmpFile.getCanonicalPath();
                                }
                                catch (IOException ioEx) {
                                    urlName = token;
                                }
                                CmdRunner.displayURL(urlName);
                                return;
                            }
                            catch (InterruptedException ie) {
                                throw new IOException("InterruptedException while launching browser: " + ie.getMessage());
                            }
                        }
                        dim = 4;
                        comd = new String[dim];
                        comd[0] = "[ -x /usr/bin/X11/kterm ] && TERM=/usr/bin/X11/kterm ||TERM=/usr/bin/X11/xterm\n$TERM ";
                        comd[1] = "-e";
                        comd[2] = "/usr/bin/less";
                        comd[3] = token.substring(7);
                    }
                    command = comd[0];
                    int i = 1;
                    while (i < dim) {
                        command = String.valueOf(command) + "    " + comd[i];
                        ++i;
                    }
                    ProcUtl proc = new ProcUtl();
                    outSb = new StringBuffer();
                    StringBuffer errSb = new StringBuffer();
                    File cmdfile = new File(token.substring(7));
                    if (!cmdfile.exists()) continue;
                    int n = proc.system(command, false, null, (Object)outSb, (Object)errSb);
                    continue;
                }
                if (token.startsWith("builtin://")) {
                    String tmp = token.substring(10);
                    if (tmp.equalsIgnoreCase("exit")) {
                        System.exit(0);
                        continue;
                    }
                    JOptionPane.showMessageDialog(null, String.valueOf(this.myResources.getString("msg7")) + tmp);
                    continue;
                }
                JOptionPane.showMessageDialog(null, String.valueOf(this.myResources.getString("msg8")) + token);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void displayURL(String url) {
        LaunchPadBrowserPane editorPane = new LaunchPadBrowserPane();
        try {
            BrowserLauncher.openURL(url);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public static boolean isWindowsPlatform() {
        String os = System.getProperty("os.name");
        return os != null && os.startsWith(WIN_ID);
    }

    public static String quote(String source) {
        if (source == null) {
            return null;
        }
        if (source.length() < 2 || !source.startsWith("\"") || !source.endsWith("\"")) {
            source = "\"" + source + "\"";
        }
        return source;
    }

    public String[] splitCommand(String cmdString) {
        int n = 0;
        String[] splitCommand = new String[20];
        char apostroph = '\u0000';
        if (cmdString == null || cmdString.trim().length() == 0) {
            return new String[0];
        }
        cmdString = cmdString.trim();
        StringTokenizer st = new StringTokenizer(cmdString, " \t");
        while (st.hasMoreTokens()) {
            String ct = st.nextToken();
            int ctln = ct.length();
            if (apostroph == '\u0000') {
                if (ct.startsWith("\"") || ct.startsWith("'")) {
                    apostroph = ct.charAt(0);
                    ct = ct.substring(1);
                    if (--ctln > 0 && ct.charAt(ctln - 1) == apostroph) {
                        apostroph = '\u0000';
                        ct = ct.substring(0, --ctln);
                    }
                }
                splitCommand[n] = ct;
                if (apostroph != '\u0000') continue;
                ++n;
                continue;
            }
            if (ctln > 0 && ct.charAt(ctln - 1) == apostroph) {
                apostroph = '\u0000';
                ct = ct.substring(0, --ctln);
            }
            int n2 = n++;
            splitCommand[n2] = String.valueOf(splitCommand[n2]) + " " + ct;
            if (apostroph != '\u0000') continue;
        }
        String[] cmdWords = new String[n];
        System.arraycopy(splitCommand, 0, cmdWords, 0, n);
        return cmdWords;
    }

    private class EchoThread
    extends Thread {
        InputStream inputStream = null;
        Process process = null;
        PrintStream outputStream = null;

        public EchoThread(Process p, InputStream in, PrintStream out) {
            super("Echo Thread");
            this.inputStream = in;
            this.process = p;
            this.outputStream = out;
        }

        public void run() {
            boolean done = false;
            while (!done) {
                try {
                    char c = (char)this.inputStream.read();
                    while (c != '\uffffffff' && this.inputStream.available() > 0) {
                        this.outputStream.print(c);
                        c = (char)this.inputStream.read();
                    }
                    try {
                        this.process.exitValue();
                        done = true;
                    }
                    catch (Exception exception) {}
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    done = true;
                }
            }
        }
    }
}

