/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.launchpad;

import com.ibm.ws.install.launchpad.ImageWindow;
import com.ibm.ws.install.launchpad.JAntiAliasLabel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.BreakIterator;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class HyperLabel
extends JLabel {
    public static Color NORMALTEXT = Color.white;
    public static Color HIGHLIGHT = Color.yellow;
    public static Color CLICKTEXT = Color.red;
    public static int WIDTH = 200;
    public static int HEIGHT = 30;
    public static Font LABELFONT = Font.decode("Helvetica-BOLD-14");
    public static int HINTNUDGE = 0;
    private String text = null;
    private FontMetrics fm = null;
    private boolean paintClick = false;
    private Runnable runnable = null;
    private JLabel arrowPanel = new JLabel();
    private JPanel hintArea = new JPanel();
    private String rollOverText = "";
    private MouseListener ml = null;

    public HyperLabel(String text, Runnable r) {
        super(text, 4);
        this.runnable = r;
        this.text = text;
        this.setSize(WIDTH, HEIGHT);
        this.setFont(LABELFONT);
        this.setForeground(NORMALTEXT);
        this.arrowPanel.setIcon(new ImageIcon(ImageWindow.ARROW));
        this.hintArea.setForeground(ImageWindow.HINTCOLOR);
        this.hintArea.setFont(ImageWindow.HINTFONT);
        this.ml = new MouseAdapter(){

            public void mouseEntered(MouseEvent e) {
                if (e != null) {
                    Container jc = HyperLabel.this.getParent();
                    while (!(jc instanceof ImageWindow)) {
                        jc = jc.getParent();
                    }
                    ((ImageWindow)jc).stopKeyboardInput();
                }
                HyperLabel.this.setCursor(new Cursor(12));
                HyperLabel.this.setForeground(HIGHLIGHT);
                HyperLabel.this.arrowPanel.setVisible(true);
                HyperLabel.this.hintArea.setVisible(true);
                HyperLabel.this.repaint();
            }

            public void mouseExited(MouseEvent e) {
                HyperLabel.this.setCursor(new Cursor(0));
                HyperLabel.this.setForeground(NORMALTEXT);
                HyperLabel.this.arrowPanel.setVisible(false);
                HyperLabel.this.hintArea.setVisible(false);
                HyperLabel.this.repaint();
            }

            public void mouseClicked(MouseEvent e) {
                HyperLabel.this.runnable.run();
                HyperLabel.this.getParent().repaint();
                HyperLabel.this.repaint();
            }

            public void mousePressed(MouseEvent e) {
                HyperLabel.this.setForeground(CLICKTEXT);
                HyperLabel.this.repaint();
            }

            public void mouseReleased(MouseEvent e) {
                HyperLabel.this.setForeground(NORMALTEXT);
                HyperLabel.this.repaint();
            }
        };
        this.addMouseListener(this.ml);
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void paint(Graphics g) {
        if (g instanceof Graphics2D) {
            RenderingHints hint = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            ((Graphics2D)g).addRenderingHints(hint);
        }
        super.paint(g);
    }

    public void refresh() {
        this.ml.mouseExited(null);
    }

    public void turnOnMouseListener() {
        this.ml.mouseExited(null);
    }

    public void turnOffMouseListener() {
        this.ml.mouseEntered(null);
    }

    public void doMouseClicked() {
        this.ml.mouseClicked(null);
    }

    public JLabel getArrowPanel() {
        Point p = this.getArrowPoint();
        this.arrowPanel.setLocation(p);
        return this.arrowPanel;
    }

    public JPanel getHintArea() {
        Point p = new Point(this.getLocation().x + this.getSize().width + 20, this.getLocation().y);
        this.hintArea.setLocation(p.x + ImageWindow.HINTOFFSET, p.y + HINTNUDGE);
        this.hintArea.setSize(ImageWindow.lengthBoundary, 100);
        this.hintArea.setBackground(new Color(0, 0, 0, 0));
        return this.hintArea;
    }

    public Point getArrowPoint() {
        Point p = new Point(this.getLocation().x + this.getSize().width + 5, this.getLocation().y - 35);
        return p;
    }

    public void setRollOverText(String roText) {
        this.rollOverText = roText;
        JLabel[] labels = this.breakupText(roText, ImageWindow.lengthBoundary);
        this.hintArea.removeAll();
        JPanel tmp = new JPanel();
        tmp.setForeground(ImageWindow.HINTCOLOR);
        tmp.setFont(ImageWindow.HINTFONT);
        tmp.setLayout(new GridLayout(labels.length, 1, 0, ImageWindow.LINESPACE));
        tmp.setBackground(new Color(0, 0, 0, 0));
        int i = 0;
        while (i < labels.length) {
            tmp.add(labels[i]);
            ++i;
        }
        this.hintArea.setLayout(new BorderLayout());
        this.hintArea.add((Component)tmp, "North");
    }

    public void addNotify() {
        super.addNotify();
        JLabel[] labels = this.breakupText(this.rollOverText, ImageWindow.lengthBoundary);
        this.hintArea.removeAll();
        JPanel tmp = new JPanel();
        tmp.setForeground(ImageWindow.HINTCOLOR);
        tmp.setFont(ImageWindow.HINTFONT);
        tmp.setLayout(new GridLayout(labels.length, 1, 0, ImageWindow.LINESPACE));
        tmp.setBackground(new Color(0, 0, 0, 0));
        int i = 0;
        while (i < labels.length) {
            tmp.add(labels[i]);
            ++i;
        }
        this.hintArea.setLayout(new BorderLayout());
        this.hintArea.add((Component)tmp, "North");
    }

    /*
     * Unable to fully structure code
     */
    private JLabel[] breakupText(String str, int lengthBoundary) {
        block5: {
            ret = "";
            labels = new Vector<String>();
            lineIterator = BreakIterator.getLineInstance();
            lineIterator.setText(str);
            boundary = lineIterator.next();
            if (this.getGraphics() == null) {
                return new JLabel[0];
            }
            fm = this.getGraphics().getFontMetrics();
            break block5;
            while ((boundary = lineIterator.next()) != -1) lbl-1000:
            // 2 sources

            {
                ** while ((int)fm.getStringBounds((String)str.substring((int)0, (int)boundary), (Graphics)this.getGraphics()).getWidth() >= lengthBoundary / 2)
lbl12:
                // 1 sources

            }
lbl13:
            // 2 sources

            t = str.substring(0, lineIterator.current());
            labels.addElement(t);
            ret = String.valueOf(ret) + t + "\n";
            if (boundary != -1) {
                str = str.substring(lineIterator.current());
                lineIterator.setText(str);
                boundary = lineIterator.next();
            }
        }
        if (boundary != -1) ** GOTO lbl-1000
        l = new JAntiAliasLabel[labels.size()];
        i = 0;
        while (i < labels.size()) {
            l[i] = new JAntiAliasLabel((String)labels.elementAt(i));
            l[i].setForeground(ImageWindow.HINTCOLOR);
            l[i].setFont(ImageWindow.HINTFONT);
            ++i;
        }
        return l;
    }
}

