/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.launchpad;

import com.ibm.ws.install.launchpad.HyperLabel;
import com.ibm.ws.install.launchpad.ShadowLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ImageWindow
extends JFrame {
    public static int width = 700;
    public static int height = 500;
    public static Color HINTCOLOR = new Color(134, 134, 234);
    public static Font HINTFONT = Font.decode("Helvetica-BOLDITALIC-12");
    public static int LINESPACE = 20;
    public static Image ICON = null;
    public static Image ARROW = null;
    public static Image BACKGROUND = null;
    public static String TITLE = "";
    public static int LABELSPACING = 30;
    public static int LABELSPACINGCONST = 40;
    public static int HINTOFFSET = 50;
    public static int labelstartx = 50;
    public static int labelstarty = 150;
    public static int lengthBoundary = 250;
    public static int SHADOWNUDGE_RIGHT = 2;
    public static int SHADOWNUDGE_DOWN = 2;
    private Hashtable labels = new Hashtable();
    private Vector labelOrder = new Vector();
    private Vector hLabels = new Vector();
    private Vector shadows = new Vector();
    private int relWidth = 0;
    private int relHeight = 0;
    private JLabel contentPanel = null;
    private int selectedLabelIndex = -1;
    private FocusAdapter focusAdapter = null;
    private HyperLabel tabSelectedLabel = null;

    public ImageWindow() {
        super(TITLE);
        this.setSize(width, height);
        this.getContentPane().setLayout(new GridLayout(1, 1, 0, 0));
        this.contentPanel = new JLabel();
        this.getContentPane().add(this.contentPanel);
        this.setDefaultCloseOperation(3);
        KeyAdapter ka = new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\u001b') {
                    System.exit(0);
                }
            }
        };
        this.addKeyListener(ka);
        KeyAdapter kc = new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 225 || e.getKeyCode() == 40) {
                    if (ImageWindow.this.tabSelectedLabel != null) {
                        ImageWindow.this.tabSelectedLabel.turnOnMouseListener();
                        ImageWindow.this.tabSelectedLabel = null;
                    }
                    ImageWindow.this.selectNextLabelDown();
                } else if (e.getKeyCode() == 224 || e.getKeyCode() == 38) {
                    if (ImageWindow.this.tabSelectedLabel != null) {
                        ImageWindow.this.tabSelectedLabel.turnOnMouseListener();
                        ImageWindow.this.tabSelectedLabel = null;
                    }
                    ImageWindow.this.selectNextLabelUp();
                } else if (e.getKeyCode() == 10) {
                    ImageWindow.this.doLabelClicked();
                }
            }
        };
        this.addKeyListener(kc);
        this.focusAdapter = new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                if (!e.isTemporary()) {
                    ImageWindow.this.stopKeyboardInput();
                    ImageWindow.this.selectedLabelIndex = -1;
                    HyperLabel hl = (HyperLabel)e.getComponent();
                    hl.turnOffMouseListener();
                    ImageWindow.this.tabSelectedLabel = hl;
                }
            }

            public void focusLost(FocusEvent e) {
                if (!e.isTemporary()) {
                    ImageWindow.this.stopKeyboardInput();
                    ImageWindow.this.selectedLabelIndex = -1;
                    ImageWindow.this.tabSelectedLabel = null;
                    HyperLabel hl = (HyperLabel)e.getComponent();
                    hl.turnOnMouseListener();
                }
            }
        };
        this.setResizable(false);
    }

    public void paint(Graphics g) {
        if (g instanceof Graphics2D) {
            RenderingHints hint = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            ((Graphics2D)g).addRenderingHints(hint);
        }
        super.paint(g);
    }

    public void stopKeyboardInput() {
        if (this.selectedLabelIndex >= 0) {
            HyperLabel h = (HyperLabel)this.hLabels.elementAt(this.selectedLabelIndex);
            if (h != null) {
                h.turnOnMouseListener();
            }
        } else if (this.tabSelectedLabel != null) {
            this.tabSelectedLabel.turnOnMouseListener();
        }
        this.selectedLabelIndex = -1;
        this.tabSelectedLabel = null;
        this.refreshLabels();
    }

    private void selectNextLabelUp() {
        HyperLabel h;
        this.refreshLabels();
        if (this.selectedLabelIndex >= 0 && (h = (HyperLabel)this.hLabels.elementAt(this.selectedLabelIndex)) != null) {
            h.turnOnMouseListener();
        }
        this.selectedLabelIndex = this.selectedLabelIndex == -1 || this.selectedLabelIndex == 0 ? this.hLabels.size() - 1 : --this.selectedLabelIndex;
        h = (HyperLabel)this.hLabels.elementAt(this.selectedLabelIndex);
        if (h != null) {
            h.turnOffMouseListener();
        }
    }

    private void refreshLabels() {
        int i = 0;
        while (i < this.hLabels.size()) {
            HyperLabel h = (HyperLabel)this.hLabels.elementAt(i);
            h.refresh();
            ++i;
        }
    }

    private void selectNextLabelDown() {
        HyperLabel h;
        this.refreshLabels();
        if (this.selectedLabelIndex >= 0 && (h = (HyperLabel)this.hLabels.elementAt(this.selectedLabelIndex)) != null) {
            h.turnOnMouseListener();
        }
        this.selectedLabelIndex = this.selectedLabelIndex == -1 || this.selectedLabelIndex == this.hLabels.size() - 1 ? 0 : ++this.selectedLabelIndex;
        h = (HyperLabel)this.hLabels.elementAt(this.selectedLabelIndex);
        if (h != null) {
            h.turnOffMouseListener();
        }
    }

    private void doLabelClicked() {
        if (this.selectedLabelIndex >= 0) {
            HyperLabel h = (HyperLabel)this.hLabels.elementAt(this.selectedLabelIndex);
            if (h != null) {
                h.doMouseClicked();
                h.turnOnMouseListener();
            }
        } else if (this.tabSelectedLabel != null) {
            this.tabSelectedLabel.doMouseClicked();
            this.tabSelectedLabel.turnOnMouseListener();
        }
        this.selectedLabelIndex = -1;
        this.tabSelectedLabel = null;
    }

    public void show() {
        this.setSize(width, height);
        this.setTitle(TITLE);
        this.setIconImage(ICON);
        this.contentPanel.setIcon(new ImageIcon(BACKGROUND));
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(d.width / 2 - width / 2, d.height / 2 - height / 2);
        super.show();
        this.requestFocus();
    }

    public void addLabel(HyperLabel l) {
        this.hLabels.addElement(l);
        l.addFocusListener(this.focusAdapter);
        ShadowLabel shadow = new ShadowLabel(l.getText());
        this.shadows.addElement(shadow);
        int i = 0;
        while (i < this.hLabels.size()) {
            Component p = (Component)this.hLabels.elementAt(i);
            Component s = (Component)this.shadows.elementAt(i);
            if (i < 6) {
                p.setLocation(new Point(labelstartx, labelstarty + i * LABELSPACING));
                s.setLocation(new Point(labelstartx + SHADOWNUDGE_RIGHT, labelstarty + i * LABELSPACING + SHADOWNUDGE_DOWN));
            } else {
                p.setLocation(new Point(labelstartx, labelstarty + LABELSPACINGCONST + i * LABELSPACING));
                s.setLocation(new Point(labelstartx + SHADOWNUDGE_RIGHT, labelstarty + LABELSPACINGCONST + i * LABELSPACING + SHADOWNUDGE_DOWN));
            }
            s.setSize(p.getSize());
            if (l == p) {
                this.contentPanel.add(p);
                this.contentPanel.add(s);
                JLabel ip = l.getArrowPanel();
                ip.setSize(100, 100);
                this.contentPanel.add(ip);
                ip.setVisible(false);
                JPanel jt = l.getHintArea();
                this.contentPanel.add(jt);
                jt.setVisible(false);
            }
            ++i;
        }
    }
}

