/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.launchpad;

import com.ibm.ws.install.launchpad.CmdRunner;
import com.ibm.ws.install.launchpad.HyperLabel;
import com.ibm.ws.install.launchpad.ImageWindow;
import com.ibm.ws.install.launchpad.LanguageSelectionDialog;
import com.ibm.ws.install.launchpad.ShadowLabel;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;

public class LaunchPad {
    private static final String PROPERTY_FILE = "com.ibm.ws.install.launchpad.LaunchPad";
    private static final String OPTIONS_FILE = "LaunchPadOP";
    private static final String NAMES_FILE = "names.properties";
    private static String propertyFile = null;
    private static String optFile = null;
    private static Locale loc = null;
    private static ResourceBundle bundle = null;
    private static ResourceBundle platBundle = null;
    private static ResourceBundle options = null;
    private static boolean useDefaultLocale = false;
    private static ResourceBundle myResources = null;
    private static Locale defLang = Locale.getDefault();

    public static void main(String[] args) {
        File f;
        propertyFile = PROPERTY_FILE;
        optFile = OPTIONS_FILE;
        String locale = null;
        Locale l = null;
        int lan = 0;
        myResources = ResourceBundle.getBundle("com.ibm.ws.install.launchpad.LaunchPadResources", defLang);
        if (args.length > 0) {
            try {
                int i = 0;
                while (i < args.length) {
                    if (args[i].equals("-p")) {
                        propertyFile = args[i + 1];
                    } else if (args[i].equals("-d")) {
                        useDefaultLocale = true;
                    } else if (args[i].equals("-o")) {
                        optFile = args[i + 1];
                    } else if (args[i].equals("-l")) {
                        locale = args[i + 1];
                        StringTokenizer tok2 = new StringTokenizer(locale, "_");
                        String l1 = tok2.nextToken();
                        String l2 = tok2.nextToken();
                        loc = new Locale(l1, l2);
                        lan = 1;
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, myResources.getString("msg11"));
                System.exit(-1);
            }
        }
        if ((f = new File(String.valueOf(optFile) + ".properties")).exists()) {
            Properties p = new Properties();
            try {
                p.load(new FileInputStream(f));
                String tmp = null;
                tmp = p.getProperty("resourceBundle");
                if (tmp != null && !tmp.trim().equals("")) {
                    propertyFile = tmp;
                }
                if ((tmp = p.getProperty("useDefaultLocale")) != null && !tmp.trim().equals("")) {
                    useDefaultLocale = tmp.equalsIgnoreCase("true");
                }
                if ((tmp = p.getProperty("locale")) != null && !tmp.trim().equals("") && (locale = tmp) != null) {
                    StringTokenizer tok1 = new StringTokenizer(locale, "_");
                    String l1 = tok1.nextToken();
                    String l2 = tok1.nextToken();
                    loc = new Locale(l1, l2);
                    lan = 2;
                }
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(null, String.valueOf(myResources.getString("msg12")) + ioe);
            }
        }
        bundle = ResourceBundle.getBundle(propertyFile);
        options = ResourceBundle.getBundle(optFile);
        try {
            platBundle = ResourceBundle.getBundle(String.valueOf(propertyFile) + "_platform");
        }
        catch (Exception exc) {
            exc.printStackTrace();
            platBundle = null;
        }
        ImageWindow imageWindow = new ImageWindow();
        Class<?> theClass = imageWindow.getClass();
        Toolkit tk = Toolkit.getDefaultToolkit();
        ImageWindow.ICON = tk.getImage(theClass.getResource(LaunchPad.getProperty("ICON")));
        ((Frame)imageWindow).setIconImage(ImageWindow.ICON);
        Locale[] languages = new Locale[]{new Locale("en", "US"), new Locale("fr", "FR"), new Locale("de", "DE"), new Locale("es", "ES"), new Locale("it", "IT"), new Locale("ja", "JP"), new Locale("zh", "TW"), new Locale("ko", "KR"), new Locale("pt", "BR"), new Locale("zh", "CN")};
        if (locale != null) {
            StringTokenizer tok = new StringTokenizer(locale, "_");
            String l1 = tok.nextToken();
            String l2 = tok.nextToken();
            l = new Locale(l1, l2);
            lan = 3;
        }
        if (!useDefaultLocale) {
            if (l == null) {
                LanguageSelectionDialog dlg = new LanguageSelectionDialog(imageWindow, languages, LaunchPad.getProperty("LANG_SELECT_TITLE"), LaunchPad.getProperty("LANG_SELECT_TEXT"), LaunchPad.getProperty("LANG_SELECT_OK_BUTTON"));
                dlg.show();
                if (!dlg.okButtonClicked()) {
                    System.exit(0);
                }
                l = dlg.getLocale();
                lan = 4;
                dlg.dispose();
            }
            loc = l;
        } else {
            loc = Locale.getDefault();
            boolean inlist = false;
            int ii = 0;
            while (ii < languages.length) {
                if (loc.equals(languages[ii])) {
                    inlist = true;
                }
                ++ii;
            }
            if (!inlist) {
                if (l == null) {
                    JOptionPane.showMessageDialog(null, myResources.getString("msg9"));
                    System.exit(-1);
                }
                loc = l;
            }
        }
        if (loc == null) {
            loc = new Locale("en", "US");
        }
        Locale.setDefault(loc);
        imageWindow.setLocale(loc);
        bundle = ResourceBundle.getBundle(propertyFile);
        if (bundle == null) {
            System.out.println("Could not load resource bundle... exiting.");
            System.exit(-1);
        }
        if ((options = ResourceBundle.getBundle(optFile, loc)) == null) {
            JOptionPane.showMessageDialog(null, "Could not load resource bundle for selected locale.\nThe english version file will be used instead:" + optFile + ".properties");
            options = ResourceBundle.getBundle(optFile, new Locale("en", "US"));
        }
        theClass = imageWindow.getClass();
        ImageWindow.TITLE = LaunchPad.getTitle();
        ImageWindow.ICON = tk.getImage(theClass.getResource(LaunchPad.getProperty("ICON")));
        ImageWindow.BACKGROUND = tk.getImage(theClass.getResource(LaunchPad.getProperty("BACKGROUND")));
        ImageWindow.ARROW = tk.getImage(theClass.getResource(LaunchPad.getProperty("ARROW")));
        ImageWindow.width = Integer.parseInt(LaunchPad.getProperty("WIDTH"));
        ImageWindow.height = Integer.parseInt(LaunchPad.getProperty("HEIGHT"));
        MediaTracker mt = new MediaTracker(imageWindow);
        mt.addImage(ImageWindow.BACKGROUND, 0);
        mt.addImage(ImageWindow.ARROW, 0);
        mt.addImage(ImageWindow.ICON, 0);
        try {
            mt.waitForAll();
        }
        catch (Exception ii) {
            // empty catch block
        }
        ImageWindow.HINTCOLOR = LaunchPad.decodeColor(LaunchPad.getProperty("HINTCOLOR"));
        ImageWindow.HINTFONT = Font.decode(LaunchPad.getProperty("HINTFONT"));
        ImageWindow.LINESPACE = Integer.parseInt(LaunchPad.getProperty("LINESPACE"));
        ImageWindow.labelstartx = Integer.parseInt(LaunchPad.getProperty("LABELSTARTX"));
        ImageWindow.labelstarty = Integer.parseInt(LaunchPad.getProperty("LABELSTARTY"));
        ImageWindow.lengthBoundary = Integer.parseInt(LaunchPad.getProperty("LENGTHBOUNDARY"));
        ImageWindow.LABELSPACING = Integer.parseInt(LaunchPad.getProperty("LABELSPACING"));
        ImageWindow.HINTOFFSET = Integer.parseInt(LaunchPad.getProperty("HINTOFFSET"));
        HyperLabel.WIDTH = Integer.parseInt(LaunchPad.getProperty("LABELWIDTH"));
        HyperLabel.HEIGHT = Integer.parseInt(LaunchPad.getProperty("LABELHEIGHT"));
        HyperLabel.LABELFONT = Font.decode(LaunchPad.getProperty("LABELFONT"));
        HyperLabel.NORMALTEXT = LaunchPad.decodeColor(LaunchPad.getProperty("NORMALTEXT"));
        HyperLabel.HIGHLIGHT = LaunchPad.decodeColor(LaunchPad.getProperty("HIGHLIGHT"));
        HyperLabel.CLICKTEXT = LaunchPad.decodeColor(LaunchPad.getProperty("CLICKTEXT"));
        HyperLabel.HINTNUDGE = Integer.parseInt(LaunchPad.getProperty("HINTNUDGE"));
        ShadowLabel.SHADOWCOLOR = LaunchPad.decodeColor(LaunchPad.getProperty("SHADOWCOLOR"));
        ImageWindow.SHADOWNUDGE_RIGHT = Integer.parseInt(LaunchPad.getProperty("SHADOWNUDGE_RIGHT"));
        ImageWindow.SHADOWNUDGE_DOWN = Integer.parseInt(LaunchPad.getProperty("SHADOWNUDGE_DOWN"));
        int numItems = Integer.parseInt(LaunchPad.getProperty("NUMITEMS"));
        int i = 0;
        while (i < numItems) {
            String item = "ITEM" + i;
            String label = LaunchPad.getProperty(item);
            String hint = LaunchPad.getProperty(String.valueOf(item) + "_DESC");
            String cmd = LaunchPad.getProperty(String.valueOf(item) + "_CMD");
            HyperLabel hl = new HyperLabel(label, new CmdRunner(cmd, loc));
            hl.setRollOverText(hint);
            imageWindow.addLabel(hl);
            ++i;
        }
        imageWindow.show();
    }

    private static Color decodeColor(String clrStr) {
        StringTokenizer tok = new StringTokenizer(clrStr, ",");
        int r = Integer.parseInt(tok.nextToken());
        int g = Integer.parseInt(tok.nextToken());
        int b = Integer.parseInt(tok.nextToken());
        int a = -1;
        if (tok.hasMoreTokens()) {
            a = Integer.parseInt(tok.nextToken());
        }
        if (a >= 0) {
            return new Color(r, g, b, a);
        }
        return new Color(r, g, b);
    }

    private static String getProperty(String key) {
        String tmp = null;
        if (platBundle != null) {
            try {
                tmp = platBundle.getString(key);
                if (tmp == null || tmp.trim().equals("")) {
                    return tmp;
                }
            }
            catch (Exception e) {
                tmp = null;
            }
        }
        if (tmp == null || tmp.trim().equals("")) {
            try {
                tmp = options.getString(key);
                if (tmp == null || tmp.trim().equals("")) {
                    return tmp;
                }
            }
            catch (Exception e) {
                tmp = null;
            }
        }
        if (tmp == null || tmp.trim().equals("")) {
            try {
                tmp = bundle.getString(key);
                if (tmp == null || tmp.trim().equals("")) {
                    return tmp;
                }
            }
            catch (Exception e) {
                tmp = null;
            }
        }
        return tmp;
    }

    private static String getTitle() {
        File namesFile;
        String names = LaunchPad.getLocalizedFileName(NAMES_FILE, Locale.getDefault(), null);
        String title = null;
        if (names != null && (namesFile = new File(names)).exists()) {
            Properties properties = new Properties();
            try {
                properties.load(new FileInputStream(namesFile));
                title = properties.getProperty("companyShortName");
                title = String.valueOf(title) + " ";
                title = String.valueOf(title) + properties.getProperty("brand");
                title = String.valueOf(title) + " ";
                title = String.valueOf(title) + properties.getProperty("productLongName");
            }
            catch (IOException ioexception) {
                JOptionPane.showMessageDialog(null, String.valueOf(myResources.getString("msg12")) + ioexception);
            }
        }
        return title != null ? title : LaunchPad.getProperty("TITLE");
    }

    private static String getLocalizedFileName(String fileName, Locale locale, String fileSuffix) {
        String ext;
        String fileNameLessExt;
        int pos;
        String[] searchDir = new String[]{""};
        int nrSearchDir = 1;
        if (fileSuffix == null) {
            fileSuffix = "";
        }
        if (fileName.indexOf("/", (pos = fileName.lastIndexOf(46)) + 1) >= 0 || fileName.indexOf("\\", pos + 1) >= 0) {
            pos = -1;
        }
        if (pos >= 0) {
            fileNameLessExt = fileName.substring(0, pos);
            ext = fileName.substring(pos);
        } else {
            fileNameLessExt = fileName;
            ext = "";
        }
        fileNameLessExt = String.valueOf(fileNameLessExt) + fileSuffix;
        Locale[] loc = null;
        loc = locale != null && !locale.toString().equals(Locale.getDefault().toString()) ? new Locale[]{locale, Locale.getDefault()} : new Locale[]{Locale.getDefault()};
        String[] locFil = new String[7];
        int nr = 0;
        int i = 0;
        while (i < loc.length) {
            String l = loc[i].getLanguage();
            String c = loc[i].getCountry();
            String v = loc[i].getVariant();
            String[] locFil1 = new String[3];
            int k = 0;
            if (l != null && l.length() > 0 && c != null && c.length() > 0 && v != null && v.length() > 0) {
                locFil1[k++] = "_" + l + "_" + c + "_" + v;
            }
            if (l != null && l.length() > 0 && c != null && c.length() > 0) {
                locFil1[k++] = "_" + l + "_" + c;
            }
            if (l != null && l.length() > 0) {
                locFil1[k++] = "_" + l;
            }
            int j = 0;
            while (j < k) {
                int jj = 0;
                jj = 0;
                while (jj < nr) {
                    if (locFil1[j].equals(locFil[jj])) break;
                    ++jj;
                }
                if (jj >= nr) {
                    locFil[nr++] = locFil1[j];
                }
                ++j;
            }
            ++i;
        }
        locFil[nr++] = "";
        i = 0;
        while (i < nr) {
            int j = 0;
            while (j < nrSearchDir) {
                String fileNameTest = String.valueOf(searchDir[j]) + fileNameLessExt + locFil[i] + ext;
                if (new File(fileNameTest).exists()) {
                    return fileNameTest;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }
}

