/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.launchpad;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class LaunchPadBrowserPane
extends JFrame
implements ActionListener,
HyperlinkListener {
    private JButton backButton = new JButton("<--");
    private JButton forwardButton = new JButton("-->");
    private JLabel locationLabel = new JLabel("");
    private JToolBar toolBar = new JToolBar();
    private JEditorPane jep = new JEditorPane();
    private int currentPosition = -1;
    private Vector history = new Vector(10);

    public LaunchPadBrowserPane() {
        super("");
        this.jep.setContentType("text/html");
        this.jep.setEditable(false);
        this.jep.addHyperlinkListener(this);
        this.locationLabel.setSize(550, this.locationLabel.getHeight());
        this.toolBar.add(this.backButton);
        this.toolBar.add(this.forwardButton);
        this.toolBar.addSeparator();
        this.toolBar.add(this.locationLabel);
        this.backButton.addActionListener(this);
        this.forwardButton.addActionListener(this);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.toolBar, "North");
        this.getContentPane().add((Component)new JScrollPane(this.jep), "Center");
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkevent) {
        if (hyperlinkevent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.navigate(hyperlinkevent.getURL().toString());
        }
    }

    public void show() {
        this.history = new Vector(10);
        this.currentPosition = -1;
        this.backButton.setEnabled(false);
        this.forwardButton.setEnabled(false);
        super.show();
    }

    public void navigate(String s) {
        try {
            this.jep.setPage(s);
            this.setLocation(s);
            this.jep.repaint();
            this.history.addElement(s);
            this.forwardButton.setEnabled(false);
            ++this.currentPosition;
            if (this.currentPosition > 0) {
                this.backButton.setEnabled(true);
            }
        }
        catch (Exception exception) {
            this.showHtmlError(exception, s);
        }
    }

    private void setLocation(String s) {
        this.locationLabel.setText(s);
        this.locationLabel.repaint();
    }

    private void showHtmlError(Exception exception, String s) {
        StringWriter stringwriter = new StringWriter();
        PrintWriter printwriter = new PrintWriter((Writer)stringwriter, true);
        printwriter.println("<HTML><HEAD></HEAD><BODY>");
        printwriter.println("<p><a href=\"" + s + "\">" + s + "</a></p><br><hr>");
        printwriter.println("<PRE>");
        exception.printStackTrace(printwriter);
        printwriter.println("</PRE></BODY></HTML>");
        this.jep.setText(stringwriter.toString());
        this.jep.repaint();
    }

    public void actionPerformed(ActionEvent actionevent) {
        if (actionevent.getSource() == this.backButton) {
            try {
                this.jep.setPage((String)this.history.elementAt(this.currentPosition - 1));
                this.setLocation((String)this.history.elementAt(this.currentPosition - 1));
                this.jep.repaint();
                --this.currentPosition;
                if (this.currentPosition == 0) {
                    this.backButton.setEnabled(false);
                }
                this.forwardButton.setEnabled(true);
            }
            catch (Exception exception) {
                this.showHtmlError(exception, (String)this.history.elementAt(this.currentPosition - 1));
            }
        } else if (actionevent.getSource() == this.forwardButton) {
            try {
                this.jep.setPage((String)this.history.elementAt(this.currentPosition + 1));
                this.setLocation((String)this.history.elementAt(this.currentPosition + 1));
                this.jep.repaint();
                ++this.currentPosition;
                if (this.currentPosition == this.history.size() - 1) {
                    this.forwardButton.setEnabled(false);
                }
                this.backButton.setEnabled(true);
            }
            catch (Exception exception1) {
                this.showHtmlError(exception1, (String)this.history.elementAt(this.currentPosition + 1));
            }
        }
    }
}

