/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.corereaders;

import com.ibm.recordio.IRandomAccessRecordFile;
import com.ibm.recordio.IRecordFile;
import com.ibm.recordio.RandomAccessRecordFile;
import com.ibm.recordio.RecordFile;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageInputStreamImpl;

public class ClosingFileReader
extends ImageInputStreamImpl {
    private static final int PAGE_SIZE = 4096;
    private static final int BUFFER_PAGES = 4;
    private static final int BUFFER_SIZE = 16384;
    private IRandomAccessFile _file;
    private File _fileRef;
    private byte[] _buffer = new byte[16384];
    private long _bufferBase = -1L;
    private long _bufferEnd = -1L;
    private boolean deleteOnClose = false;
    private int _page_size = 4096;

    public ClosingFileReader(File file) throws FileNotFoundException {
        this._fileRef = file;
        try {
            this._file = new BaseRandomAccessFile(this._fileRef, "r");
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                Class.forName("com.ibm.recordio.RandomAccessRecordFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw fileNotFoundException;
            }
            try {
                ZosRandomAccessFile zosRandomAccessFile = new ZosRandomAccessFile(this._fileRef, "r");
                this._file = zosRandomAccessFile;
                this._page_size = zosRandomAccessFile._recordLength;
                this._buffer = new byte[4 * this._page_size];
            }
            catch (FileNotFoundException fileNotFoundException2) {
                FileNotFoundException fileNotFoundException3 = new FileNotFoundException("z/OS file not found");
                fileNotFoundException3.initCause(fileNotFoundException2);
                throw fileNotFoundException3;
            }
        }
    }

    public ClosingFileReader(ImageInputStream imageInputStream) throws FileNotFoundException {
        this._file = new StreamRandomAccessFile(imageInputStream);
    }

    public ClosingFileReader(File file, boolean bl) throws FileNotFoundException {
        this(file);
        if (bl) {
            this.deleteOnClose = true;
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    try {
                        ClosingFileReader.this.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
        }
    }

    public byte[] readBytes(int n) throws IOException {
        byte[] byArray = new byte[n];
        this.readFully(byArray);
        return byArray;
    }

    public int readInt() throws IOException {
        byte[] byArray = new byte[4];
        this.readFully(byArray);
        return (int)(((long)byArray[0] & 0xFFL) << 24 | ((long)byArray[1] & 0xFFL) << 16 | ((long)byArray[2] & 0xFFL) << 8 | (long)byArray[3] & 0xFFL);
    }

    public void seek(long l) throws IOException {
        this.streamPos = l;
    }

    public long readLong() throws IOException {
        byte[] byArray = new byte[8];
        this.readFully(byArray);
        return ((long)byArray[0] & 0xFFL) << 56 | ((long)byArray[1] & 0xFFL) << 48 | ((long)byArray[2] & 0xFFL) << 40 | ((long)byArray[3] & 0xFFL) << 32 | ((long)byArray[4] & 0xFFL) << 24 | ((long)byArray[5] & 0xFFL) << 16 | ((long)byArray[6] & 0xFFL) << 8 | (long)byArray[7] & 0xFFL;
    }

    public short readShort() throws IOException {
        byte[] byArray = new byte[2];
        this.readFully(byArray);
        return (short)((byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF);
    }

    public byte readByte() throws IOException {
        byte[] byArray = new byte[1];
        this.readFully(byArray);
        return byArray[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public void readFully(byte[] byArray) throws IOException {
        int n;
        for (int i = 0; i < byArray.length; i += n) {
            int n2 = Math.min(this._buffer.length, byArray.length - i);
            n = this.read(byArray, i, n2);
            if (n > 0) continue;
            throw new EOFException("Read " + i + " bytes ");
        }
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        try {
            if (-1L == this._bufferBase) {
                this._recache();
            }
            long l = this._bufferBase;
            long l2 = this._bufferEnd;
            long l3 = this.streamPos;
            long l4 = this.streamPos + (long)n2;
            long l5 = Math.max(l, l3);
            long l6 = Math.min(l2, l4);
            if (l6 <= l5 || this.streamPos < this._bufferBase) {
                this._recache();
                l = this._bufferBase;
                l2 = this._bufferEnd;
                l5 = Math.max(l, l3);
                l6 = Math.min(l2, l4);
            }
            int n4 = (int)(l5 - this._bufferBase);
            n3 = (int)(l6 - l5);
            try {
                System.arraycopy(this._buffer, n4, byArray, n, n3);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException2 = new ArrayIndexOutOfBoundsException("System.arraycopy(" + this._buffer + " length=" + this._buffer.length + "," + n4 + "," + byArray + " length=" + byArray.length + "," + n + "," + n3 + ")");
                arrayIndexOutOfBoundsException2.initCause(arrayIndexOutOfBoundsException);
                throw arrayIndexOutOfBoundsException2;
            }
            this.streamPos += (long)n3;
            if (n3 == 0 && n2 > 0) {
                n3 = -1;
            }
        }
        catch (EOFException eOFException) {
            n3 = -1;
        }
        return n3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void _recache() throws IOException {
        long l;
        long l2 = this._file.length();
        if (l2 != -1L && l2 <= this.streamPos) throw new EOFException("trying to cache beyond end of file");
        long l3 = this.streamPos % (long)this._page_size;
        this._bufferBase = l = this.streamPos - l3;
        this._bufferEnd = l;
        try {
            this._file.seek(l);
            this._file.readFully(this._buffer);
            this._bufferEnd = l + (long)this._buffer.length;
            return;
        }
        catch (EORFException eORFException) {
            this._file.seek(l);
            this._file.readFully(this._buffer, 0, eORFException.bytesRead);
            this._bufferEnd = l + (long)eORFException.bytesRead;
            return;
        }
        catch (EOFException eOFException) {
            int n;
            if (l2 != -1L) {
                this._bufferEnd = l2;
                this._file.seek(l);
                this._file.readFully(this._buffer, 0, (int)(this._bufferEnd - l));
                return;
            }
            this._file.seek(l);
            this._bufferEnd = l;
            for (int i = 0; i < this._buffer.length && (n = this._file.read()) != -1; ++i) {
                this._buffer[i] = (byte)n;
                ++this._bufferEnd;
            }
            if (this._bufferEnd != l) return;
            throw new EOFException("trying to cache beyond end of file");
        }
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read() throws IOException {
        byte[] byArray = new byte[1];
        int n = this.read(byArray);
        if (n < 0) {
            return n;
        }
        return byArray[0] & 0xFF;
    }

    public long length() {
        try {
            return this._file.length();
        }
        catch (IOException iOException) {
            return -1L;
        }
    }

    public void close() throws IOException {
        this._file.close();
        if (this.deleteOnClose) {
            this._fileRef.delete();
        }
    }

    public InputStream streamFromFile() throws FileNotFoundException {
        return new FileInputStream(this._fileRef);
    }

    public String getAbsolutePath() {
        if (this._fileRef == null) {
            return null;
        }
        return this._fileRef.getAbsolutePath();
    }

    public boolean isMVSFile() {
        return this._file instanceof ZosRandomAccessFile;
    }

    private static class ZosRandomAccessFile
    implements IRandomAccessFile {
        private IRecordFile _file;
        private IRandomAccessRecordFile _rafile;
        private byte[] _recordBuffer = null;
        private final int _recordLength;
        private int _seekOffset = 0;
        private long _recordNumber = 0L;
        private int _bufferValid = 0;

        public ZosRandomAccessFile(File file, String string) throws FileNotFoundException {
            try {
                this._file = RecordFile.getInstanceOf((String)("//" + file.getName()));
                this._rafile = RandomAccessRecordFile.getInstanceOf((IRecordFile)this._file, (String)string);
                this._recordLength = this._rafile.getRecordLength();
                this._recordBuffer = new byte[this._recordLength];
            }
            catch (IOException iOException) {
                throw new FileNotFoundException(iOException.toString());
            }
            catch (LinkageError linkageError) {
                throw new FileNotFoundException(linkageError.toString());
            }
        }

        public void close() throws IOException {
            this._rafile.close();
        }

        public long length() throws IOException {
            return -1L;
        }

        public int read() throws IOException {
            byte[] byArray = new byte[1];
            try {
                this.readFully(byArray);
                return byArray[0] & 0xFF;
            }
            catch (EOFException eOFException) {
                return -1;
            }
        }

        public void readFully(byte[] byArray) throws IOException {
            this.readFully(byArray, 0, byArray.length);
        }

        public void readFully(byte[] byArray, int n, int n2) throws IOException {
            int n3 = 0;
            while (n3 < n2) {
                int n4;
                if (this._seekOffset != 0 || n2 - n3 < this._recordLength) {
                    int n5 = n4 = this._bufferValid > 0 ? this._bufferValid : this._rafile.read(this._recordBuffer);
                    if (n4 < this._seekOffset) {
                        throw new EORFException(n3);
                    }
                    int n6 = n4 - this._seekOffset;
                    if (n6 > n2 - n3) {
                        System.arraycopy(this._recordBuffer, this._seekOffset, byArray, n + n3, n2 - n3);
                        n3 = n2;
                        this._seekOffset += n3;
                        this._bufferValid = n4;
                        continue;
                    }
                    System.arraycopy(this._recordBuffer, this._seekOffset, byArray, n + n3, n6);
                    n3 += n6;
                    ++this._recordNumber;
                    this._seekOffset = 0;
                    this._bufferValid = 0;
                    continue;
                }
                n4 = this._rafile.read(byArray, n + n3, n2 - n3);
                if (n4 < 0) {
                    throw new EORFException(n3);
                }
                ++this._recordNumber;
                n3 += n4;
            }
        }

        public void seek(long l) throws IOException {
            long l2 = l / (long)this._recordLength;
            if (l2 != this._recordNumber) {
                this._rafile.seek(l2);
                this._recordNumber = l2;
                this._bufferValid = 0;
            }
            this._seekOffset = (int)(l % (long)this._recordLength);
        }
    }

    private static class StreamRandomAccessFile
    implements IRandomAccessFile {
        private ImageInputStream _file;

        public StreamRandomAccessFile(ImageInputStream imageInputStream) {
            this._file = imageInputStream;
        }

        public void close() throws IOException {
            this._file.close();
        }

        public long length() throws IOException {
            return this._file.length();
        }

        public int read() throws IOException {
            return this._file.read();
        }

        public void readFully(byte[] byArray) throws IOException {
            this.readFully(byArray, 0, byArray.length);
        }

        public void readFully(byte[] byArray, int n, int n2) throws IOException {
            int n3;
            int n4 = 0;
            do {
                if ((n3 = this._file.read(byArray, n + n4, n2 - n4)) > 0) continue;
                throw new EOFException();
            } while ((n4 += n3) < n2);
        }

        public void seek(long l) throws IOException {
            this._file.seek(l);
        }
    }

    private static class BaseRandomAccessFile
    implements IRandomAccessFile {
        private RandomAccessFile _file;

        public BaseRandomAccessFile(File file, String string) throws FileNotFoundException {
            this._file = new RandomAccessFile(file, string);
        }

        public void close() throws IOException {
            this._file.close();
        }

        public long length() throws IOException {
            return this._file.length();
        }

        public int read() throws IOException {
            return this._file.read();
        }

        public void readFully(byte[] byArray) throws IOException {
            this._file.readFully(byArray);
        }

        public void readFully(byte[] byArray, int n, int n2) throws IOException {
            this._file.readFully(byArray, n, n2);
        }

        public void seek(long l) throws IOException {
            this._file.seek(l);
        }
    }

    private static class EORFException
    extends EOFException {
        private static final long serialVersionUID = 1L;
        public int bytesRead;

        public EORFException(int n) {
            this.bytesRead = n;
        }
    }

    private static interface IRandomAccessFile {
        public void close() throws IOException;

        public long length() throws IOException;

        public int read() throws IOException;

        public void readFully(byte[] var1) throws IOException;

        public void readFully(byte[] var1, int var2, int var3) throws IOException;

        public void seek(long var1) throws IOException;
    }
}

