/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.corereaders;

import com.ibm.dtfj.corereaders.ClosingFileReader;
import com.ibm.dtfj.corereaders.CorruptCoreException;
import com.ibm.dtfj.corereaders.ICoreFileReader;
import com.ibm.dtfj.corereaders.NewAixDump;
import com.ibm.dtfj.corereaders.NewElfDump;
import com.ibm.dtfj.corereaders.NewWinDump;
import com.ibm.dtfj.corereaders.NewZosDump;
import java.io.IOException;

public class DumpFactory {
    public static ICoreFileReader createDumpForCore(ClosingFileReader closingFileReader) throws IOException {
        return DumpFactory.createDumpForCore(closingFileReader, false);
    }

    public static ICoreFileReader createDumpForCore(ClosingFileReader closingFileReader, boolean bl) throws IOException {
        ICoreFileReader iCoreFileReader = null;
        try {
            if (NewWinDump.isSupportedDump(closingFileReader)) {
                iCoreFileReader = NewWinDump.dumpFromFile(closingFileReader);
            } else if (NewElfDump.isSupportedDump(closingFileReader)) {
                iCoreFileReader = NewElfDump.dumpFromFile(closingFileReader, bl);
            } else if (NewAixDump.isSupportedDump(closingFileReader)) {
                iCoreFileReader = NewAixDump.dumpFromFile(closingFileReader);
            } else if (NewZosDump.isSupportedDump(closingFileReader)) {
                iCoreFileReader = NewZosDump.dumpFromFile(closingFileReader);
            }
        }
        catch (CorruptCoreException corruptCoreException) {
            System.err.println("Core file was identified but found to be corrupt:  " + corruptCoreException.getMessage());
        }
        return iCoreFileReader;
    }
}

