/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.corereaders.zos.mvs;

import com.ibm.dtfj.corereaders.zos.dumpreader.AddressSpace;
import com.ibm.dtfj.corereaders.zos.dumpreader.AddressSpaceImageInputStream;
import com.ibm.dtfj.corereaders.zos.mvs.BpxzotcbTemplate;
import com.ibm.dtfj.corereaders.zos.mvs.BpxzustaTemplate;
import com.ibm.dtfj.corereaders.zos.mvs.CeexcvtTemplate;
import com.ibm.dtfj.corereaders.zos.mvs.IhaascbTemplate;
import com.ibm.dtfj.corereaders.zos.mvs.IhaasxbTemplate;
import com.ibm.dtfj.corereaders.zos.mvs.IhapsaTemplate;
import com.ibm.dtfj.corereaders.zos.mvs.IharbTemplate;
import com.ibm.dtfj.corereaders.zos.mvs.IhastcbTemplate;
import com.ibm.dtfj.corereaders.zos.mvs.IkjrbTemplate;
import com.ibm.dtfj.corereaders.zos.mvs.IkjtcbTemplate;
import com.ibm.dtfj.corereaders.zos.mvs.Lse;
import com.ibm.dtfj.corereaders.zos.mvs.LsedTemplate;
import com.ibm.dtfj.corereaders.zos.mvs.Lsestate1Template;
import com.ibm.dtfj.corereaders.zos.mvs.LsestateTemplate;
import com.ibm.dtfj.corereaders.zos.mvs.OtcbcopyonforkTemplate;
import com.ibm.dtfj.corereaders.zos.mvs.RegisterSet;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Tcb {
    private AddressSpace space;
    private AddressSpaceImageInputStream inputStream;
    private long address;
    private Lse[] linkageStack;
    private static Hashtable tcbMap = new Hashtable();
    private static final int RBFTPRB = 0;
    private static final int FastPathPCLow = 4871;
    private static final int OmvsPcLow = 4864;
    private static Logger log = Logger.getLogger(Tcb.class.getName());

    public static Tcb[] getTcbs(AddressSpace addressSpace) {
        AddressSpaceImageInputStream addressSpaceImageInputStream = addressSpace.getImageInputStream();
        AddressSpaceImageInputStream addressSpaceImageInputStream2 = addressSpace.getRootAddressSpace().getImageInputStream();
        Tcb[] tcbArray = (Tcb[])tcbMap.get(addressSpace);
        if (tcbArray != null) {
            return tcbArray;
        }
        log.fine("creating Tcb array for asid " + addressSpace);
        Vector<Tcb> vector = new Vector<Tcb>();
        try {
            long l;
            long l2 = IhapsaTemplate.getPsaaold(addressSpaceImageInputStream2, 0L);
            if (l2 == 0L) {
                log.fine("psaaold is zero so no tcbs in asid " + addressSpace);
                return null;
            }
            long l3 = IhaascbTemplate.getAscbasxb(addressSpaceImageInputStream2, l2);
            long l4 = IhaasxbTemplate.getAsxbftcb(addressSpaceImageInputStream, l3);
            if (l4 == (l = IhaasxbTemplate.getAsxbltcb(addressSpaceImageInputStream, l3))) {
                log.fine("first and last tcb pointers are equal so no tcbs in asid " + addressSpace);
                return null;
            }
            Tcb tcb = new Tcb(addressSpace, l4);
            while (true) {
                vector.add(tcb);
                if (tcb.address() != l) {
                    tcb = new Tcb(addressSpace, tcb.tcbtcb());
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            if (log.isLoggable(Level.FINER)) {
                exception.printStackTrace();
            }
            log.fine("exception: " + exception);
            return null;
        }
        tcbArray = vector.toArray(new Tcb[0]);
        tcbMap.put(addressSpace, tcbArray);
        return tcbArray;
    }

    public long address() {
        return this.address;
    }

    public AddressSpace space() {
        return this.space;
    }

    public Tcb(AddressSpace addressSpace, long l) {
        log.fine("creating Tcb at address " + Tcb.hex(l));
        this.space = addressSpace;
        this.address = l;
        this.inputStream = addressSpace.getImageInputStream();
    }

    public long tcbcelap() throws IOException {
        return IkjtcbTemplate.getTcbcelap(this.inputStream, this.address);
    }

    public long tcbrtwa() throws IOException {
        return IkjtcbTemplate.getTcbrtwa(this.inputStream, this.address);
    }

    public long tcbrbp() throws IOException {
        return IkjtcbTemplate.getTcbrbp(this.inputStream, this.address);
    }

    public long tcbstcb() throws IOException {
        return IkjtcbTemplate.getTcbstcb(this.inputStream, this.address);
    }

    public long tcbtcb() throws IOException {
        return IkjtcbTemplate.getTcbtcb(this.inputStream, this.address);
    }

    public RegisterSet getRegisters() throws IOException {
        log.fine("getRegisters");
        RegisterSet registerSet = new RegisterSet();
        try {
            long l = this.address + (long)IkjtcbTemplate.getTcbgrs$offset();
            for (int i = 0; i < 16; ++i) {
                registerSet.setRegister(i, this.space.readUnsignedInt(l + (long)(i * 4)));
            }
            registerSet.setPSW(IharbTemplate.getRbopsw(this.inputStream, this.tcbrbp()));
            if (this.space.is64bit()) {
                long l2 = this.tcbstcb() + (long)IhastcbTemplate.getStcbg64h$offset();
                for (int i = 0; i < 16; ++i) {
                    long l3 = this.space.readUnsignedInt(l2 + (long)(i * 4));
                    registerSet.setRegister(i, registerSet.getRegister(i) | l3 << 32);
                }
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new Error("oops: " + exception);
        }
        return registerSet;
    }

    public RegisterSet getRegistersFromBPXGMSTA() throws IOException {
        RegisterSet registerSet;
        block18: {
            registerSet = new RegisterSet();
            try {
                long l = this.tcbrbp();
                long l2 = 0L;
                long l3 = 0L;
                log.fine("for tcb " + Tcb.hex(this.address) + ", rbp = " + Tcb.hex(l));
                int n = 0;
                do {
                    log.fine("currently looking at rbp 0x" + Tcb.hex(l));
                    l3 = l2;
                    l2 = l;
                    l = IharbTemplate.getRblinkXrblnkRblinkb(this.inputStream, l);
                    ++n;
                } while (l != this.address);
                log.fine("found " + n + " rbs");
                if (n == 1) {
                    this.getLinkageStack();
                    if (this.linkageStack.length == 0) {
                        log.fine("empty linkage stack, get registers from TCB");
                        registerSet = this.getRegisters();
                        registerSet.setWhereFound("BPXGMSTA/TCB");
                        break block18;
                    }
                    long l4 = IhastcbTemplate.getStcbotcb(this.inputStream, this.tcbstcb());
                    boolean bl = false;
                    if (l4 != 0L) {
                        boolean bl2 = bl = BpxzotcbTemplate.getOtcbptregsinusta(this.inputStream, l4) != 0L;
                    }
                    if (bl && l4 != 0L) {
                        long l5 = BpxzotcbTemplate.getOtcbcofptr(this.inputStream, l4);
                        throw new Error("tbc");
                    }
                    log.fine("try first linkage stack entry");
                    Lse lse = this.linkageStack[this.linkageStack.length - 1];
                    assert (l4 != 0L);
                    long l6 = BpxzotcbTemplate.getOtcbcofptr(this.inputStream, l4);
                    long l7 = OtcbcopyonforkTemplate.getOtcbustaptr(this.inputStream, l6);
                    log.fine("lse type " + lse.lses1typ7());
                    if ((lse.lsestyp7() == 5 || lse.lses1typ7() == 13) && lse.lsestarg() < 4871L && lse.lsestarg() >= 4864L && l7 != 0L) {
                        long l8 = l7 + (long)BpxzustaTemplate.getUstagrs$offset();
                        long l9 = IhapsaTemplate.getFlccvt(this.inputStream, 0L);
                        long l10 = CeexcvtTemplate.getCvtoslv3(this.inputStream, l9);
                        if ((l10 & 2L) != 0L) {
                            log.fine("new level of OS (0x" + Tcb.hex(l10) + ")");
                        } else {
                            log.fine("old level of OS (0x" + Tcb.hex(l10) + ") so adjust usta pointer");
                            l8 -= 8L;
                        }
                        for (int i = 0; i < 16; ++i) {
                            registerSet.setRegister(i, this.space.readUnsignedInt(l8 + (long)(i * 4)));
                        }
                        long l11 = l7 + (long)BpxzustaTemplate.getUstapswg$offset();
                        registerSet.setPSW(this.space.readLong(l11));
                        registerSet.setWhereFound("BPXGMSTA/USTA");
                        break block18;
                    }
                    log.fine("try last linkage stack entry");
                    lse = this.linkageStack[0];
                    if (lse.lses1typ7() == 13 || lse.lses1typ7() == 12) {
                        registerSet.setPSW(lse.lses1pswh());
                        for (int i = 0; i < 16; ++i) {
                            registerSet.setRegister(i, lse.lses1grs(i));
                        }
                    } else {
                        registerSet.setPSW(lse.lsespsw());
                        for (int i = 0; i < 16; ++i) {
                            registerSet.setRegister(i, lse.lsesgrs(i));
                        }
                    }
                    registerSet.setWhereFound("BPXGMSTA/Linkage");
                    break block18;
                }
                long l12 = IkjrbTemplate.getRbftp(this.inputStream, l2);
                if (l12 == 0L) {
                    registerSet.setPSW(IharbTemplate.getRbopsw(this.inputStream, l2));
                    long l13 = IharbTemplate.getRbgrsave$offset();
                    for (int i = 0; i < 16; ++i) {
                        registerSet.setRegister(i, this.space.readUnsignedInt(l3 + l13 + (long)(i * 4)));
                    }
                    registerSet.setWhereFound("BPXGMSTA/RBFTPRB");
                    break block18;
                }
                throw new Error("tbc");
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new Error("oops: " + exception);
            }
        }
        return registerSet;
    }

    public Lse[] getLinkageStack() throws IOException {
        if (this.linkageStack != null) {
            return this.linkageStack;
        }
        try {
            long l = this.tcbstcb();
            long l2 = IhastcbTemplate.getStcbestk(this.inputStream, l);
            long l3 = IhastcbTemplate.getStcblsdp(this.inputStream, l);
            if (l2 == l3) {
                log.fine("linkage stack empty");
                this.linkageStack = new Lse[0];
                return this.linkageStack;
            }
            long l4 = LsedTemplate.getLsednes(this.inputStream, l2);
            assert (l4 == (long)LsestateTemplate.length() || l4 == (long)Lsestate1Template.length()) : l4;
            assert ((l3 - l2) % l4 == 0L) : (l3 - l2) % l4;
            int n = (int)((l3 - l2) / l4);
            assert (n >= 0 && n < 100) : n;
            this.linkageStack = new Lse[n];
            long l5 = l3 - l4;
            for (int i = 0; i < n; ++i) {
                this.linkageStack[i] = new Lse(this.space, l5);
                l5 -= l4;
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new Error("oops: " + exception);
        }
        return this.linkageStack;
    }

    private static String hex(long l) {
        return Long.toHexString(l);
    }
}

