/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.corereaders.zos.util;

import com.ibm.dtfj.corereaders.zos.util.AbstractHashMap;

public abstract class AbstractLruCache
extends AbstractHashMap {
    int maxSize;
    int head = -1;
    int tail = -1;
    int[] next = new int[17];
    int[] prev = new int[17];

    protected AbstractLruCache(int n) {
        this.maxSize = n;
    }

    void allocNewValuesArray(int n) {
        this.next = new int[n];
        this.prev = new int[n];
        this.tail = -1;
        this.head = -1;
    }

    protected int getIndexAndPromote(long l) {
        int n = this.getIndex(l);
        if (n != -1) {
            if (this.head != n) {
                int n2 = this.next[n];
                int n3 = this.prev[n];
                this.next[n3] = n2;
                if (n2 != -1) {
                    this.prev[n2] = this.prev[n];
                } else {
                    this.tail = n3;
                }
                this.prev[n] = -1;
                this.next[n] = this.head;
                this.prev[this.head] = n;
                this.head = n;
            }
            return n;
        }
        return -1;
    }

    protected int putIndexAndPromote(long l) {
        int n = this.getIndex(l);
        if (n == -1) {
            if (this.slotsInUse < this.maxSize) {
                n = this.putIndex(l);
                this.prev[n] = -1;
                this.next[n] = this.head;
                if (this.slotsInUse == 1) {
                    this.tail = n;
                } else {
                    this.prev[this.head] = n;
                }
                this.head = n;
                return n;
            }
            this.state[this.tail] = 2;
            ++this.deletedSlots;
            --this.slotsInUse;
            this.tail = this.prev[this.tail];
            this.next[this.tail] = -1;
            return this.putIndexAndPromote(l);
        }
        return n;
    }
}

