/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.image.j9;

import com.ibm.dtfj.addressspace.IAbstractAddressSpace;
import com.ibm.dtfj.corereaders.MemoryRange;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.ImageProcess;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.image.j9.RawImageSection;
import java.util.Iterator;
import java.util.Vector;

public class ImageAddressSpace
implements com.ibm.dtfj.image.ImageAddressSpace {
    private Vector _processes = new Vector();
    private IAbstractAddressSpace _shadow;
    private int _asid = 0;

    public ImageAddressSpace(IAbstractAddressSpace iAbstractAddressSpace, int n) {
        this._shadow = iAbstractAddressSpace;
        this._asid = n;
    }

    public ImageProcess getCurrentProcess() {
        ImageProcess imageProcess = null;
        if (this._processes.size() > 0) {
            imageProcess = (ImageProcess)this._processes.elementAt(0);
        }
        return imageProcess;
    }

    public Iterator getProcesses() {
        return this._processes.iterator();
    }

    public ImagePointer getPointer(long l) {
        return new com.ibm.dtfj.image.j9.ImagePointer(this, l);
    }

    public void addProcess(ImageProcess imageProcess) {
        this._processes.add(imageProcess);
    }

    public byte readByteAtIndex(long l) throws MemoryAccessException {
        try {
            return this._shadow.getByteAt(this._asid, l);
        }
        catch (com.ibm.dtfj.corereaders.MemoryAccessException memoryAccessException) {
            throw new MemoryAccessException(this.getPointer(l));
        }
    }

    public ImagePointer readPointerAtIndex(long l) throws MemoryAccessException {
        try {
            long l2 = this._shadow.getPointerAt(this._asid, l);
            return this.getPointer(l2);
        }
        catch (com.ibm.dtfj.corereaders.MemoryAccessException memoryAccessException) {
            throw new MemoryAccessException(this.getPointer(l));
        }
    }

    public int readIntAtIndex(long l) throws MemoryAccessException {
        try {
            return this._shadow.getIntAt(this._asid, l);
        }
        catch (com.ibm.dtfj.corereaders.MemoryAccessException memoryAccessException) {
            throw new MemoryAccessException(this.getPointer(l));
        }
    }

    public long readLongAtIndex(long l) throws MemoryAccessException {
        try {
            return this._shadow.getLongAt(this._asid, l);
        }
        catch (com.ibm.dtfj.corereaders.MemoryAccessException memoryAccessException) {
            throw new MemoryAccessException(this.getPointer(l));
        }
    }

    public short readShortAtIndex(long l) throws MemoryAccessException {
        try {
            return this._shadow.getShortAt(this._asid, l);
        }
        catch (com.ibm.dtfj.corereaders.MemoryAccessException memoryAccessException) {
            throw new MemoryAccessException(this.getPointer(l));
        }
    }

    public Iterator getImageSections() {
        Iterator iterator = this._shadow.getMemoryRanges();
        Vector<RawImageSection> vector = new Vector<RawImageSection>();
        while (iterator.hasNext()) {
            MemoryRange memoryRange = (MemoryRange)iterator.next();
            if (memoryRange.getAsid() != this._asid) continue;
            long l = memoryRange.getVirtualAddress();
            RawImageSection rawImageSection = new RawImageSection(this.getPointer(l), memoryRange.getSize());
            vector.add(rawImageSection);
        }
        return vector.iterator();
    }

    boolean isExecutableAt(long l) throws DataUnavailable {
        try {
            return this._shadow.isExecutable(this._asid, l);
        }
        catch (com.ibm.dtfj.corereaders.MemoryAccessException memoryAccessException) {
            throw new DataUnavailable();
        }
    }

    boolean isReadOnly(long l) throws DataUnavailable {
        try {
            return this._shadow.isReadOnly(this._asid, l);
        }
        catch (com.ibm.dtfj.corereaders.MemoryAccessException memoryAccessException) {
            throw new DataUnavailable();
        }
    }

    boolean isShared(long l) throws DataUnavailable {
        try {
            return this._shadow.isShared(this._asid, l);
        }
        catch (com.ibm.dtfj.corereaders.MemoryAccessException memoryAccessException) {
            throw new DataUnavailable();
        }
    }

    public int bytesPerPointer() {
        return this._shadow.bytesPerPointer(this._asid);
    }

    public String toString() {
        return this._asid != 0 ? "0x" + Integer.toHexString(this._asid) : super.toString();
    }
}

