/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.java.j9;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaClassLoader;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.j9.JavaReference;
import com.ibm.dtfj.java.j9.JavaRuntime;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public abstract class JavaAbstractClass
implements JavaClass {
    protected ImagePointer _classPointer;
    protected JavaRuntime _javaVM;
    private int _modifiers;
    private Vector _interfaceNames = new Vector();
    private long _classLoaderID;
    private ImagePointer _objectID;
    private int _flagOffset;

    protected JavaAbstractClass(JavaRuntime javaRuntime, ImagePointer imagePointer, int n, long l, ImagePointer imagePointer2, int n2) {
        if (null == imagePointer) {
            throw new IllegalArgumentException("Java class pointer must be non-null");
        }
        if (null == javaRuntime) {
            throw new IllegalArgumentException("Java VM for a class must not be null");
        }
        this._javaVM = javaRuntime;
        this._classPointer = imagePointer;
        this._modifiers = n;
        this._classLoaderID = l;
        this._objectID = imagePointer2;
        this._flagOffset = n2;
    }

    public JavaClassLoader getClassLoader() throws CorruptDataException {
        return this._javaVM.getClassLoaderForID(this._classLoaderID);
    }

    public JavaObject getObject() throws CorruptDataException {
        if (this._objectID == null) {
            return this._javaVM.getObjectAtAddress(this._classPointer);
        }
        return this._javaVM.getObjectAtAddress(this._objectID);
    }

    public int getModifiers() throws CorruptDataException {
        return this._modifiers;
    }

    public ImagePointer getID() {
        return this._classPointer;
    }

    public Iterator getInterfaces() {
        return this._interfaceNames.iterator();
    }

    public void addInterfaceName(String string) {
        this._interfaceNames.add(string);
    }

    public abstract int getInstanceSize(JavaObject var1);

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof JavaAbstractClass) {
            JavaAbstractClass javaAbstractClass = (JavaAbstractClass)object;
            bl = this.getClass().equals(javaAbstractClass.getClass()) && this._javaVM.equals(javaAbstractClass._javaVM) && this._classPointer.equals(javaAbstractClass._classPointer);
        }
        return bl;
    }

    public int hashCode() {
        return this._javaVM.hashCode() ^ this._classPointer.hashCode();
    }

    public int readFlagsFromInstance(JavaObject javaObject) throws MemoryAccessException, CorruptDataException {
        return javaObject.getID().getIntAt((long)this._flagOffset);
    }

    protected void addClassLoaderReference(Collection collection) {
        JavaReference javaReference = null;
        try {
            JavaObject javaObject;
            JavaClassLoader javaClassLoader = this.getClassLoader();
            if (null != javaClassLoader && null != (javaObject = javaClassLoader.getObject())) {
                javaReference = new JavaReference(this._javaVM, (Object)this, javaObject, "Classloader", 4, 0, 1);
                collection.add(javaReference);
            }
        }
        catch (CorruptDataException corruptDataException) {
            collection.add(corruptDataException.getCorruptData());
        }
    }

    protected void addSuperclassReference(Collection collection) {
        JavaReference javaReference = null;
        try {
            JavaClass javaClass = this.getSuperclass();
            if (null != javaClass) {
                javaReference = new JavaReference(this._javaVM, (Object)this, javaClass, "Superclass", 10, 0, 1);
                collection.add(javaReference);
            }
        }
        catch (CorruptDataException corruptDataException) {
            collection.add(corruptDataException.getCorruptData());
        }
    }

    protected void addClassObjectReference(Collection collection) {
        JavaReference javaReference = null;
        try {
            JavaObject javaObject = this.getObject();
            if (null != javaObject) {
                javaReference = new JavaReference(this._javaVM, (Object)this, javaObject, "Class object", 12, 0, 1);
                collection.add(javaReference);
            }
        }
        catch (CorruptDataException corruptDataException) {
            collection.add(corruptDataException.getCorruptData());
        }
    }
}

