/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.java.j9;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.image.j9.CorruptData;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.j9.JavaRuntime;
import java.util.Iterator;

public abstract class JavaField
implements com.ibm.dtfj.java.JavaField {
    protected static final String BOOLEAN_SIGNATURE = "Z";
    protected static final String BYTE_SIGNATURE = "B";
    protected static final String CHAR_SIGNATURE = "C";
    protected static final String SHORT_SIGNATURE = "S";
    protected static final String INTEGER_SIGNATURE = "I";
    protected static final String LONG_SIGNATURE = "J";
    protected static final String FLOAT_SIGNATURE = "F";
    protected static final String DOUBLE_SIGNATURE = "D";
    protected static final String OBJECT_PREFIX_SIGNATURE = "L";
    protected static final String ARRAY_PREFIX_SIGNATURE = "[";
    protected JavaRuntime _javaVM;
    private String _name;
    private String _signature;
    private int _modifiers;
    private long _declaringClassID;

    protected JavaField(JavaRuntime javaRuntime, String string, String string2, int n, long l) {
        if (null == javaRuntime) {
            throw new IllegalArgumentException("Java VM for a field must not be null");
        }
        if (null == string) {
            throw new IllegalArgumentException("A Java Field requires a non-null name");
        }
        if (null == string2) {
            throw new IllegalArgumentException("A Java Field requires a non-null signature");
        }
        this._javaVM = javaRuntime;
        this._name = string;
        this._signature = string2;
        this._modifiers = n;
        this._declaringClassID = l;
    }

    public Object get(JavaObject javaObject) throws CorruptDataException, MemoryAccessException {
        if (this.getSignature().equals(BOOLEAN_SIGNATURE)) {
            return new Boolean(this.getBoolean(javaObject));
        }
        if (this.getSignature().equals(BYTE_SIGNATURE)) {
            return new Byte(this.getByte(javaObject));
        }
        if (this.getSignature().equals(CHAR_SIGNATURE)) {
            return new Character(this.getChar(javaObject));
        }
        if (this.getSignature().equals(SHORT_SIGNATURE)) {
            return new Short(this.getShort(javaObject));
        }
        if (this.getSignature().equals(INTEGER_SIGNATURE)) {
            return new Integer(this.getInt(javaObject));
        }
        if (this.getSignature().equals(LONG_SIGNATURE)) {
            return new Long(this.getLong(javaObject));
        }
        if (this.getSignature().equals(FLOAT_SIGNATURE)) {
            return new Float(this.getFloat(javaObject));
        }
        if (this.getSignature().equals(DOUBLE_SIGNATURE)) {
            return new Double(this.getDouble(javaObject));
        }
        if (this.getSignature().startsWith(OBJECT_PREFIX_SIGNATURE) || this.getSignature().startsWith(ARRAY_PREFIX_SIGNATURE)) {
            return this.getReferenceType(javaObject);
        }
        throw new IllegalArgumentException("unidentified object signature [" + this.getSignature() + "]");
    }

    public long getLong(JavaObject javaObject) throws CorruptDataException, MemoryAccessException {
        if (this.getSignature().equals(LONG_SIGNATURE)) {
            throw new IllegalArgumentException();
        }
        if (this.getSignature().equals(BYTE_SIGNATURE)) {
            return this.getByte(javaObject);
        }
        if (this.getSignature().equals(SHORT_SIGNATURE)) {
            return this.getShort(javaObject);
        }
        if (this.getSignature().equals(CHAR_SIGNATURE)) {
            return this.getChar(javaObject);
        }
        if (this.getSignature().equals(INTEGER_SIGNATURE)) {
            return this.getInt(javaObject);
        }
        throw new IllegalArgumentException("unexpected object signature [" + this.getSignature() + "] cannot retrieve long");
    }

    public double getDouble(JavaObject javaObject) throws CorruptDataException, MemoryAccessException {
        if (this.getSignature().equals(DOUBLE_SIGNATURE)) {
            throw new IllegalArgumentException();
        }
        if (this.getSignature().equals(FLOAT_SIGNATURE)) {
            return this.getFloat(javaObject);
        }
        if (this.getSignature().equals(BYTE_SIGNATURE)) {
            return this.getByte(javaObject);
        }
        if (this.getSignature().equals(SHORT_SIGNATURE)) {
            return this.getShort(javaObject);
        }
        if (this.getSignature().equals(CHAR_SIGNATURE)) {
            return this.getChar(javaObject);
        }
        if (this.getSignature().equals(INTEGER_SIGNATURE)) {
            return this.getInt(javaObject);
        }
        if (this.getSignature().equals(LONG_SIGNATURE)) {
            return this.getLong(javaObject);
        }
        throw new IllegalArgumentException("unexpected object signature [" + this.getSignature() + "] cannot retrieve double");
    }

    public float getFloat(JavaObject javaObject) throws CorruptDataException, MemoryAccessException {
        if (this.getSignature().equals(FLOAT_SIGNATURE)) {
            throw new IllegalArgumentException();
        }
        if (this.getSignature().equals(BYTE_SIGNATURE)) {
            return this.getByte(javaObject);
        }
        if (this.getSignature().equals(SHORT_SIGNATURE)) {
            return this.getShort(javaObject);
        }
        if (this.getSignature().equals(CHAR_SIGNATURE)) {
            return this.getChar(javaObject);
        }
        if (this.getSignature().equals(INTEGER_SIGNATURE)) {
            return this.getInt(javaObject);
        }
        if (this.getSignature().equals(LONG_SIGNATURE)) {
            return this.getLong(javaObject);
        }
        throw new IllegalArgumentException("unexpected object signature [" + this.getSignature() + "] cannot retrieve float");
    }

    public int getInt(JavaObject javaObject) throws CorruptDataException, MemoryAccessException {
        if (this.getSignature().equals(INTEGER_SIGNATURE)) {
            throw new IllegalArgumentException();
        }
        if (this.getSignature().equals(BYTE_SIGNATURE)) {
            return this.getByte(javaObject);
        }
        if (this.getSignature().equals(SHORT_SIGNATURE)) {
            return this.getShort(javaObject);
        }
        if (this.getSignature().equals(CHAR_SIGNATURE)) {
            return this.getChar(javaObject);
        }
        throw new IllegalArgumentException("unexpected object signature [" + this.getSignature() + "] cannot retrieve int");
    }

    public short getShort(JavaObject javaObject) throws CorruptDataException, MemoryAccessException {
        if (this.getSignature().equals(SHORT_SIGNATURE)) {
            throw new IllegalArgumentException();
        }
        if (this.getSignature().equals(BYTE_SIGNATURE)) {
            return this.getByte(javaObject);
        }
        throw new IllegalArgumentException("unexpected object signature [" + this.getSignature() + "] cannot retrieve short");
    }

    protected abstract Object getReferenceType(JavaObject var1) throws CorruptDataException, MemoryAccessException;

    public int getModifiers() throws CorruptDataException {
        return this._modifiers;
    }

    public JavaClass getDeclaringClass() throws CorruptDataException {
        JavaClass javaClass = this._javaVM.getClassForID(this._declaringClassID);
        if (javaClass == null) {
            throw new CorruptDataException((com.ibm.dtfj.image.CorruptData)new CorruptData("Unknown declaring class ID " + this._declaringClassID, null));
        }
        return javaClass;
    }

    public String getName() throws CorruptDataException {
        return this._name;
    }

    public String getSignature() throws CorruptDataException {
        return this._signature;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getString(JavaObject javaObject) throws CorruptDataException, MemoryAccessException {
        JavaField javaField;
        Object object = this.get(javaObject);
        if (null == object) {
            return null;
        }
        if (!(object instanceof JavaObject)) throw new IllegalArgumentException();
        JavaObject javaObject2 = (JavaObject)object;
        String string = null;
        if (0L == javaObject2.getID().getAddress()) return null;
        JavaClass javaClass = javaObject2.getJavaClass();
        if (!javaClass.getName().equals("java/lang/String")) throw new IllegalArgumentException();
        Iterator iterator = javaClass.getDeclaredFields();
        JavaField javaField2 = null;
        JavaField javaField3 = null;
        JavaField javaField4 = null;
        while (iterator.hasNext()) {
            javaField = (JavaField)iterator.next();
            if (javaField.getSignature().equals("[C") && javaField.getName().equals("value")) {
                javaField2 = javaField;
                continue;
            }
            if (javaField.getSignature().equals(INTEGER_SIGNATURE) && javaField.getName().equals("offset")) {
                javaField3 = javaField;
                continue;
            }
            if (!javaField.getSignature().equals(INTEGER_SIGNATURE) || !javaField.getName().equals("count")) continue;
            javaField4 = javaField;
        }
        javaField = (JavaObject)javaField2.get(javaObject2);
        int n = javaField4.getInt(javaObject2);
        char[] cArray = new char[n];
        int n2 = javaField3.getInt(javaObject2);
        javaField.arraycopy(n2, cArray, 0, n);
        return new String(cArray);
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof JavaField) {
            boolean bl2;
            JavaField javaField = (JavaField)object;
            try {
                bl2 = this._name.equals(javaField.getName());
            }
            catch (CorruptDataException corruptDataException) {
                bl2 = false;
            }
            bl = bl2 && this.getClass().equals(javaField.getClass()) && this._javaVM.equals(javaField._javaVM) && this._declaringClassID == javaField._declaringClassID;
        }
        return bl;
    }

    public int hashCode() {
        return this._name.hashCode() ^ this._signature.hashCode() ^ this._javaVM.hashCode() ^ ((int)this._declaringClassID ^ (int)(this._declaringClassID >> 32));
    }

    public String toString() {
        try {
            return this.getDeclaringClass().getName() + "." + this.getName() + " : " + this.getSignature();
        }
        catch (CorruptDataException corruptDataException) {
            return super.toString();
        }
    }
}

