/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.java.j9;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.java.j9.JavaClass;
import com.ibm.dtfj.java.j9.JavaField;
import com.ibm.dtfj.java.j9.JavaObject;
import com.ibm.dtfj.java.j9.JavaRuntime;

public class JavaInstanceField
extends JavaField {
    private int _offset;

    public JavaInstanceField(JavaRuntime javaRuntime, String string, String string2, int n, int n2, long l) {
        super(javaRuntime, string, string2, n, l);
        if (null == javaRuntime) {
            throw new IllegalArgumentException("Java VM for an instance field cannot be null");
        }
        this._offset = n2;
    }

    private void checkDeclaringClass(com.ibm.dtfj.java.JavaObject javaObject) throws CorruptDataException {
        JavaClass javaClass = (JavaClass)this.getDeclaringClass();
        if (!javaClass.isAncestorOf(javaObject.getJavaClass())) {
            throw new IllegalArgumentException("The class for the JavaObject specified as a parameter does not match with the declaring class of this JavaField.");
        }
    }

    public Object getReferenceType(com.ibm.dtfj.java.JavaObject javaObject) throws CorruptDataException, MemoryAccessException {
        if (this._isSafeToAccess(javaObject)) {
            this.checkDeclaringClass(javaObject);
            String string = this.getSignature();
            if (string.startsWith("L") || string.startsWith("[")) {
                ImagePointer imagePointer = ((JavaObject)javaObject).getFObjectAtOffset(this._offset);
                return this._javaVM.getObjectAtAddress(imagePointer);
            }
            throw new IllegalArgumentException();
        }
        throw new NullPointerException();
    }

    public boolean getBoolean(com.ibm.dtfj.java.JavaObject javaObject) throws CorruptDataException, MemoryAccessException {
        if (this._isSafeToAccess(javaObject)) {
            this.checkDeclaringClass(javaObject);
            if (this.getSignature().equals("Z")) {
                return 0 != javaObject.getID().getIntAt((long)this._offset);
            }
            throw new IllegalArgumentException();
        }
        throw new NullPointerException();
    }

    public byte getByte(com.ibm.dtfj.java.JavaObject javaObject) throws CorruptDataException, MemoryAccessException {
        if (this._isSafeToAccess(javaObject)) {
            this.checkDeclaringClass(javaObject);
            if (this.getSignature().equals("B")) {
                return (byte)javaObject.getID().getIntAt((long)this._offset);
            }
            throw new IllegalArgumentException();
        }
        throw new NullPointerException();
    }

    public char getChar(com.ibm.dtfj.java.JavaObject javaObject) throws CorruptDataException, MemoryAccessException {
        if (this._isSafeToAccess(javaObject)) {
            this.checkDeclaringClass(javaObject);
            if (this.getSignature().equals("C")) {
                return (char)javaObject.getID().getIntAt((long)this._offset);
            }
            throw new IllegalArgumentException();
        }
        throw new NullPointerException();
    }

    public double getDouble(com.ibm.dtfj.java.JavaObject javaObject) throws CorruptDataException, MemoryAccessException {
        if (this._isSafeToAccess(javaObject)) {
            this.checkDeclaringClass(javaObject);
            if (this.getSignature().equals("D")) {
                return javaObject.getID().getDoubleAt((long)this._offset);
            }
            return super.getDouble(javaObject);
        }
        throw new NullPointerException();
    }

    public float getFloat(com.ibm.dtfj.java.JavaObject javaObject) throws CorruptDataException, MemoryAccessException {
        if (this._isSafeToAccess(javaObject)) {
            this.checkDeclaringClass(javaObject);
            if (this.getSignature().equals("F")) {
                return javaObject.getID().getFloatAt((long)this._offset);
            }
            return super.getFloat(javaObject);
        }
        throw new NullPointerException();
    }

    public int getInt(com.ibm.dtfj.java.JavaObject javaObject) throws CorruptDataException, MemoryAccessException {
        if (this._isSafeToAccess(javaObject)) {
            this.checkDeclaringClass(javaObject);
            if (this.getSignature().equals("I")) {
                return javaObject.getID().getIntAt((long)this._offset);
            }
            return super.getInt(javaObject);
        }
        throw new NullPointerException();
    }

    public long getLong(com.ibm.dtfj.java.JavaObject javaObject) throws CorruptDataException, MemoryAccessException {
        if (this._isSafeToAccess(javaObject)) {
            this.checkDeclaringClass(javaObject);
            if (this.getSignature().equals("J")) {
                return javaObject.getID().getLongAt((long)this._offset);
            }
            return super.getLong(javaObject);
        }
        throw new NullPointerException();
    }

    public short getShort(com.ibm.dtfj.java.JavaObject javaObject) throws CorruptDataException, MemoryAccessException {
        if (this._isSafeToAccess(javaObject)) {
            this.checkDeclaringClass(javaObject);
            if (this.getSignature().equals("S")) {
                return (short)javaObject.getID().getIntAt((long)this._offset);
            }
            return super.getShort(javaObject);
        }
        throw new NullPointerException();
    }

    private boolean _isSafeToAccess(com.ibm.dtfj.java.JavaObject javaObject) {
        return null != javaObject && 0L != javaObject.getID().getAddress();
    }
}

