/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.java.j9;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DTFJException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.ImageSection;
import com.ibm.dtfj.java.JavaMethod;
import com.ibm.dtfj.java.j9.JavaClass;
import java.util.Iterator;

public class JavaLocation
implements com.ibm.dtfj.java.JavaLocation {
    private JavaMethod _method;
    private ImagePointer _pc;
    private int _lineNumber;

    public JavaLocation(JavaMethod javaMethod, ImagePointer imagePointer, int n) {
        if (null == javaMethod) {
            throw new IllegalArgumentException("A Java Location cannot have a null method");
        }
        if (null == imagePointer) {
            throw new IllegalArgumentException("A Java Location cannot have a null program counter");
        }
        this._method = javaMethod;
        this._pc = imagePointer;
        this._lineNumber = n;
    }

    public ImagePointer getAddress() throws CorruptDataException {
        return this._pc;
    }

    public int getLineNumber() throws DataUnavailable, CorruptDataException {
        if (this._lineNumber > 0) {
            return this._lineNumber;
        }
        throw new DataUnavailable();
    }

    public String getFilename() throws DataUnavailable, CorruptDataException {
        JavaClass javaClass = (JavaClass)this.getMethod().getDeclaringClass();
        return javaClass.getFilename();
    }

    public int getCompilationLevel() throws CorruptDataException {
        ImageSection imageSection;
        long l = this.getAddress().getAddress();
        Iterator iterator = this.getMethod().getBytecodeSections();
        while (iterator.hasNext()) {
            imageSection = (ImageSection)iterator.next();
            if (l < imageSection.getBaseAddress().getAddress() || l >= imageSection.getBaseAddress().getAddress() + imageSection.getSize()) continue;
            return 0;
        }
        iterator = this.getMethod().getCompiledSections();
        while (iterator.hasNext()) {
            imageSection = (ImageSection)iterator.next();
            if (l < imageSection.getBaseAddress().getAddress() || l >= imageSection.getBaseAddress().getAddress() + imageSection.getSize()) continue;
            return 1;
        }
        return 0;
    }

    public JavaMethod getMethod() throws CorruptDataException {
        return this._method;
    }

    public String toString() {
        String string = null;
        try {
            String string2 = this.getMethod().getDeclaringClass().getName();
            string2 = string2.replace('/', '.');
            String string3 = this.getMethod().getName();
            String string4 = null;
            try {
                String string5 = this.getFilename();
                int n = this.getLineNumber();
                string4 = "(" + string5 + ":" + n + ")";
            }
            catch (DTFJException dTFJException) {
                string4 = "()";
            }
            string = string2 + "." + string3 + string4;
        }
        catch (CorruptDataException corruptDataException) {
            string = "(corrupt)";
        }
        catch (DataUnavailable dataUnavailable) {
            string = "(data unavailable)";
        }
        return string;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof JavaLocation) {
            JavaLocation javaLocation = (JavaLocation)object;
            bl = this._method.equals(javaLocation._method) && this._pc.equals(javaLocation._pc);
        }
        return bl;
    }

    public int hashCode() {
        return this._method.hashCode() ^ this._pc.hashCode();
    }
}

