/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.java.j9;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.j9.BytecodeImageSection;
import com.ibm.dtfj.image.j9.JitImageSection;
import com.ibm.dtfj.java.JavaClass;
import java.util.Iterator;
import java.util.Vector;

public class JavaMethod
implements com.ibm.dtfj.java.JavaMethod {
    private ImagePointer _methodID;
    private String _methodName;
    private String _signature;
    private int _modifiers;
    private JavaClass _declaringClass;
    private Vector _compiledSections = new Vector();
    private Vector _bytecodeSections = new Vector();

    public JavaMethod(ImagePointer imagePointer, String string, String string2, int n, JavaClass javaClass) {
        if (null == imagePointer) {
            throw new IllegalArgumentException("A Java Method cannot have a null method ID");
        }
        if (null == javaClass) {
            throw new IllegalArgumentException("A Java Method cannot have a null declaring class");
        }
        this._methodID = imagePointer;
        this._methodName = string;
        this._signature = string2;
        this._modifiers = n;
        this._declaringClass = javaClass;
    }

    public Iterator getBytecodeSections() {
        return this._bytecodeSections.iterator();
    }

    public Iterator getCompiledSections() {
        return this._compiledSections.iterator();
    }

    public int getModifiers() throws CorruptDataException {
        return this._modifiers;
    }

    public JavaClass getDeclaringClass() throws CorruptDataException, DataUnavailable {
        return this._declaringClass;
    }

    public String getName() throws CorruptDataException {
        return this._methodName;
    }

    public String getSignature() throws CorruptDataException {
        return this._signature;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof JavaMethod) {
            JavaMethod javaMethod = (JavaMethod)object;
            bl = this._declaringClass.equals(javaMethod._declaringClass) && this._methodID.equals(javaMethod._methodID);
        }
        return bl;
    }

    public int hashCode() {
        return this._declaringClass.hashCode() ^ this._methodID.hashCode();
    }

    public void createNewBytecodeSection(long l, long l2) {
        BytecodeImageSection bytecodeImageSection = new BytecodeImageSection(this._methodID.getAddressSpace().getPointer(l), l2);
        this._bytecodeSections.add(bytecodeImageSection);
    }

    public void createNewJITSection(long l, long l2, long l3) {
        JitImageSection jitImageSection = new JitImageSection(this._methodID.getAddressSpace().getPointer(l), this._methodID.getAddressSpace().getPointer(l2), l3);
        this._compiledSections.add(jitImageSection);
    }

    public String toString() {
        try {
            return this.getDeclaringClass().getName() + "." + this.getName() + this.getSignature();
        }
        catch (CorruptDataException corruptDataException) {
        }
        catch (DataUnavailable dataUnavailable) {
            // empty catch block
        }
        return super.toString();
    }
}

