/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.java.j9;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.j9.CorruptData;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.JavaThread;
import com.ibm.dtfj.java.j9.JavaRuntime;
import java.util.Iterator;
import java.util.Vector;

public class JavaMonitor
implements com.ibm.dtfj.java.JavaMonitor {
    private JavaRuntime _javaVM;
    private ImagePointer _monitorID;
    private String _monitorName;
    private ImagePointer _encompassingObjectAddress = null;
    private JavaObject _encompassingObject = null;
    private long _owningThreadID;
    private Vector _blockList = new Vector();
    private Vector _waitList = new Vector();

    public JavaMonitor(JavaRuntime javaRuntime, ImagePointer imagePointer, String string, ImagePointer imagePointer2, long l) {
        if (null == javaRuntime) {
            throw new IllegalArgumentException("A Java Monitor cannot exist in a null Java VM");
        }
        if (null == imagePointer) {
            throw new IllegalArgumentException("A Java Monitor requires a non-null ID");
        }
        this._javaVM = javaRuntime;
        this._monitorID = imagePointer;
        this._encompassingObjectAddress = imagePointer2;
        this._owningThreadID = l;
        this._monitorName = null == string ? (null != this._encompassingObjectAddress ? "(un-named monitor @0x" + Long.toHexString(imagePointer.getAddress()) + " for object @0x" + Long.toHexString(this._encompassingObjectAddress.getAddress()) + ")" : "(un-named monitor @0x" + Long.toHexString(imagePointer.getAddress()) + ")") : string;
    }

    public JavaObject getObject() {
        if (null == this._encompassingObjectAddress) {
            return null;
        }
        if (null == this._encompassingObject) {
            try {
                this._encompassingObject = this._javaVM.getObjectAtAddress(this._encompassingObjectAddress);
            }
            catch (CorruptDataException corruptDataException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return this._encompassingObject;
    }

    public String getName() throws CorruptDataException {
        return this._monitorName;
    }

    public JavaThread getOwner() throws CorruptDataException {
        JavaThread javaThread = null;
        Iterator iterator = this._javaVM.getThreads();
        while (iterator.hasNext()) {
            JavaThread javaThread2 = (JavaThread)iterator.next();
            if (javaThread2.getJNIEnv().getAddress() != this._owningThreadID) continue;
            javaThread = javaThread2;
            break;
        }
        if (null == javaThread && 0L != this._owningThreadID) {
            throw new CorruptDataException((com.ibm.dtfj.image.CorruptData)new CorruptData("Monitor owner not found", this._javaVM.pointerInAddressSpace(this._owningThreadID)));
        }
        return javaThread;
    }

    public Iterator getEnterWaiters() {
        if (null == this._blockList) {
            this._blockList = new Vector();
        }
        return this._blockList.iterator();
    }

    public Iterator getNotifyWaiters() {
        if (null == this._waitList) {
            this._waitList = new Vector();
        }
        return this._waitList.iterator();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof JavaMonitor) {
            JavaMonitor javaMonitor = (JavaMonitor)object;
            bl = this._javaVM.equals(javaMonitor._javaVM) && this._monitorID.equals(javaMonitor._monitorID);
        }
        return bl;
    }

    public int hashCode() {
        return this._javaVM.hashCode() ^ this._monitorID.hashCode();
    }

    public ImagePointer getID() {
        return this._monitorID;
    }

    public void addBlockedThread(JavaThread javaThread) {
        this._blockList.add(javaThread);
    }

    public void addWaitingThread(JavaThread javaThread) {
        this._waitList.add(javaThread);
    }
}

