/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.java.j9;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.java.JavaLocation;
import com.ibm.dtfj.java.j9.JavaMethod;
import com.ibm.dtfj.java.j9.JavaReference;
import com.ibm.dtfj.java.j9.JavaRuntime;
import java.util.Iterator;
import java.util.Vector;

public class JavaStackFrame
implements com.ibm.dtfj.java.JavaStackFrame {
    private JavaRuntime _javaVM;
    private ImagePointer _basePointer;
    private JavaMethod _method;
    private ImagePointer _pc;
    private int _lineNumber;
    private Vector _stackRoots = new Vector();

    public JavaStackFrame(JavaRuntime javaRuntime, ImagePointer imagePointer, JavaMethod javaMethod, ImagePointer imagePointer2, int n) {
        if (null == imagePointer) {
            throw new IllegalArgumentException("A Java stack frame must have a non-null base pointer");
        }
        if (null == javaMethod) {
            throw new IllegalArgumentException("A Java stack frame must refer to a non-null method");
        }
        if (null == imagePointer2) {
            throw new IllegalArgumentException("A Java stack frame must have a non-null program counter");
        }
        this._javaVM = javaRuntime;
        this._basePointer = imagePointer;
        this._method = javaMethod;
        this._pc = imagePointer2;
        this._lineNumber = n;
    }

    public ImagePointer getBasePointer() throws CorruptDataException {
        return this._basePointer;
    }

    public JavaLocation getLocation() throws CorruptDataException {
        return new com.ibm.dtfj.java.j9.JavaLocation(this._method, this._pc, this._lineNumber);
    }

    public void createObjectRef(long l) {
        JavaReference javaReference = new JavaReference(this._javaVM, (Object)this, l, "StackFrame Root", 0, 4, 1);
        this._stackRoots.add(javaReference);
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof JavaStackFrame) {
            JavaStackFrame javaStackFrame = (JavaStackFrame)object;
            bl = this._method.equals(javaStackFrame._method) && this._pc.equals(javaStackFrame._pc);
        }
        return bl;
    }

    public int hashCode() {
        return this._method.hashCode() ^ this._pc.hashCode();
    }

    public Iterator getHeapRoots() {
        return this._stackRoots.iterator();
    }
}

