/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.java.j9;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.ImageSection;
import com.ibm.dtfj.image.ImageThread;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.image.j9.CorruptData;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.j9.JavaField;
import com.ibm.dtfj.java.j9.JavaMethod;
import com.ibm.dtfj.java.j9.JavaRuntime;
import com.ibm.dtfj.java.j9.JavaStackFrame;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class JavaThread
implements com.ibm.dtfj.java.JavaThread {
    private JavaRuntime _javaVM;
    private ImagePointer _objectID;
    private String _threadState;
    private ImagePointer _jniEnv;
    private Vector _stackFrames = new Vector();
    private ImageThread _imageThread;
    private JavaStackSection _stackSection;
    private JavaObject _javaObject = null;
    private static final HashMap _threadStateMap = new HashMap();

    public JavaThread(JavaRuntime javaRuntime, ImagePointer imagePointer, ImagePointer imagePointer2, String string, ImageThread imageThread) {
        if (null == javaRuntime) {
            throw new IllegalArgumentException("A Java thread cannot exist in a null Java VM");
        }
        this._javaVM = javaRuntime;
        this._imageThread = imageThread;
        this._objectID = imagePointer2;
        this._threadState = string;
        this._jniEnv = imagePointer;
    }

    public ImagePointer getJNIEnv() throws CorruptDataException {
        return this._jniEnv;
    }

    public int getPriority() throws CorruptDataException {
        JavaObject javaObject = this.getObject();
        if (null != javaObject) {
            JavaClass javaClass = this._javaLangThreadSuperclass();
            Iterator iterator = javaClass.getDeclaredFields();
            while (iterator.hasNext()) {
                JavaField javaField = (JavaField)iterator.next();
                if (!javaField.getName().equals("priority")) continue;
                try {
                    return javaField.getInt(javaObject);
                }
                catch (MemoryAccessException memoryAccessException) {
                    throw new CorruptDataException((com.ibm.dtfj.image.CorruptData)new CorruptData("unable to read memory for 'priority' field", null));
                }
            }
            throw new CorruptDataException((com.ibm.dtfj.image.CorruptData)new CorruptData("unable to find 'priority' field", null));
        }
        return -1;
    }

    public JavaObject getObject() throws CorruptDataException {
        if (null == this._javaObject && 0L != this._objectID.getAddress()) {
            this._javaObject = this._javaVM.getObjectAtAddress(this._objectID);
        }
        return this._javaObject;
    }

    public int getState() throws CorruptDataException {
        if (_threadStateMap.containsKey(this._threadState)) {
            return (Integer)_threadStateMap.get(this._threadState);
        }
        throw new CorruptDataException((com.ibm.dtfj.image.CorruptData)new CorruptData("Invalid thread state", this._jniEnv));
    }

    public ImageThread getImageThread() throws CorruptDataException, DataUnavailable {
        if (null == this._imageThread) {
            throw new DataUnavailable("Native thread not found");
        }
        return this._imageThread;
    }

    public Iterator getStackSections() {
        List<Object> list = null;
        list = null == this._stackSection ? Collections.singletonList(new CorruptData("stack section missing", this._jniEnv)) : Collections.singletonList(this._stackSection);
        return list.iterator();
    }

    public Iterator getStackFrames() {
        return this._stackFrames.iterator();
    }

    public String getName() throws CorruptDataException {
        JavaObject javaObject = this.getObject();
        if (null != javaObject) {
            JavaClass javaClass = this._javaLangThreadSuperclass();
            Iterator iterator = javaClass.getDeclaredFields();
            while (iterator.hasNext()) {
                JavaField javaField = (JavaField)iterator.next();
                if (!javaField.getName().equals("name")) continue;
                try {
                    return javaField.getString(javaObject);
                }
                catch (MemoryAccessException memoryAccessException) {
                    throw new CorruptDataException((com.ibm.dtfj.image.CorruptData)new CorruptData("unable to read memory for 'name' field", null));
                }
            }
            throw new CorruptDataException((com.ibm.dtfj.image.CorruptData)new CorruptData("unable to find 'name' field", null));
        }
        return "vmthread @" + this._jniEnv.getAddress();
    }

    private JavaClass _javaLangThreadSuperclass() throws CorruptDataException {
        JavaClass javaClass;
        for (javaClass = this.getObject().getJavaClass(); null != javaClass && !javaClass.getName().equals("java/lang/Thread"); javaClass = javaClass.getSuperclass()) {
        }
        if (null == javaClass) {
            throw new CorruptDataException((com.ibm.dtfj.image.CorruptData)new CorruptData("JavaThread is not a subclass of java/lang/Thread", this.getObject().getID()));
        }
        return javaClass;
    }

    public void addFrame(Object object) {
        this._stackFrames.add(object);
    }

    public void setStackSection(long l, long l2) {
        this._stackSection = new JavaStackSection(this._jniEnv.getAddressSpace().getPointer(l), l2, this);
    }

    public boolean equals(Object object) {
        boolean bl;
        boolean bl2 = null == this._imageThread ? this == object : (bl = false);
        if (null != this._imageThread && object instanceof JavaThread) {
            JavaThread javaThread = (JavaThread)object;
            bl = this._javaVM.equals(javaThread._javaVM) && this._imageThread.equals(javaThread._imageThread);
        }
        return bl;
    }

    public int hashCode() {
        int n = null == this._imageThread ? this._jniEnv.hashCode() : this._imageThread.hashCode();
        return this._javaVM.hashCode() ^ n;
    }

    public JavaStackFrame addNewStackFrame(long l, long l2, long l3, int n) {
        JavaMethod javaMethod = this._javaVM.methodForID(l2);
        ImagePointer imagePointer = this._javaVM.pointerInAddressSpace(l);
        ImagePointer imagePointer2 = this._javaVM.pointerInAddressSpace(l3);
        JavaStackFrame javaStackFrame = new JavaStackFrame(this._javaVM, imagePointer, javaMethod, imagePointer2, n);
        this.addFrame(javaStackFrame);
        return javaStackFrame;
    }

    public void setStackCorrupt() {
        this.addFrame(new CorruptData("vmthread encountered error tag where stack expected", this._jniEnv));
    }

    static {
        _threadStateMap.put("Dead", new Integer(2));
        _threadStateMap.put("Suspended", new Integer(0x100001));
        _threadStateMap.put("Running", new Integer(5));
        _threadStateMap.put("Blocked", new Integer(1025));
        _threadStateMap.put("Waiting", new Integer(401));
        _threadStateMap.put("Waiting timed", new Integer(417));
        _threadStateMap.put("Sleeping", new Integer(193));
        _threadStateMap.put("Parked", new Integer(657));
        _threadStateMap.put("Parked timed", new Integer(673));
    }

    class JavaStackSection
    implements ImageSection {
        private ImagePointer _start;
        private long _size;
        private JavaThread _parent;

        public JavaStackSection(ImagePointer imagePointer, long l, JavaThread javaThread2) {
            this._start = imagePointer;
            this._size = l;
            this._parent = javaThread2;
        }

        public ImagePointer getBaseAddress() {
            return this._start;
        }

        public long getSize() {
            return this._size;
        }

        public String getName() {
            String string = null;
            try {
                string = this._parent.getName();
            }
            catch (CorruptDataException corruptDataException) {
                string = "(corrupt data)";
            }
            return "JavaStackSection for JavaThread: " + string;
        }

        public boolean isExecutable() throws DataUnavailable {
            return this._start.isExecutable();
        }

        public boolean isReadOnly() throws DataUnavailable {
            return this._start.isReadOnly();
        }

        public boolean isShared() throws DataUnavailable {
            return this._start.isShared();
        }
    }
}

