/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.indexsupport;

import com.ibm.dtfj.corereaders.ClosingFileReader;
import com.ibm.dtfj.corereaders.ICoreFileReader;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.image.j9.Builder;
import com.ibm.dtfj.image.j9.IFileLocationResolver;
import com.ibm.dtfj.image.j9.Image;
import com.ibm.dtfj.image.j9.ImageAddressSpace;
import com.ibm.dtfj.image.j9.ImageProcess;
import com.ibm.jvm.j9.dump.indexsupport.IParserNode;
import com.ibm.jvm.j9.dump.indexsupport.NodeJ9Dump;
import com.ibm.jvm.j9.dump.indexsupport.NodeUnexpectedTag;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLIndexReader
extends DefaultHandler
implements IParserNode {
    private ICoreFileReader _coreFile;
    private Image _coreImage;
    private Stack _elements;
    private StringBuffer _scrapingBuffer = new StringBuffer();
    private IFileLocationResolver _fileResolvingAgent;
    private ClosingFileReader _reader;

    public Image parseIndexWithDump(InputStream inputStream, ICoreFileReader iCoreFileReader, ClosingFileReader closingFileReader, IFileLocationResolver iFileLocationResolver) {
        this._fileResolvingAgent = iFileLocationResolver;
        this._elements = new Stack();
        this._coreFile = iCoreFileReader;
        this._reader = closingFileReader;
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            this._elements.push(this);
            sAXParser.parse(inputStream, (DefaultHandler)this);
            this._elements.pop();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            this._createCoreImageAfterParseError(parserConfigurationException);
        }
        catch (SAXException sAXException) {
            this._createCoreImageAfterParseError(sAXException);
        }
        catch (IOException iOException) {
            this._createCoreImageAfterParseError(iOException);
        }
        return this._coreImage;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this._checkScrapeBuffer();
        IParserNode iParserNode = ((IParserNode)this._elements.peek()).nodeToPushAfterStarting(string, string2, string3, attributes);
        assert (null != iParserNode) : "Node should not be null when starting new tag: " + string3;
        this._elements.push(iParserNode);
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        this._checkScrapeBuffer();
        IParserNode iParserNode = (IParserNode)this._elements.pop();
        iParserNode.didFinishParsing();
    }

    private void _checkScrapeBuffer() {
        String string = this._scrapingBuffer.toString();
        this._scrapingBuffer = new StringBuffer();
        ((IParserNode)this._elements.peek()).stringWasParsed(string);
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this._scrapingBuffer.append(cArray, n, n2);
    }

    public IParserNode nodeToPushAfterStarting(String string, String string2, String string3, Attributes attributes) {
        IParserNode iParserNode = null;
        iParserNode = string3.equals("j9dump") ? new NodeJ9Dump(this, attributes) : NodeUnexpectedTag.unexpectedTag(string3, attributes);
        return iParserNode;
    }

    public void stringWasParsed(String string) {
    }

    public void didFinishParsing() {
    }

    public void setJ9DumpData(long l, String string, String string2, String string3, int n, long l2, int n2, Image[] imageArray, ImageAddressSpace[] imageAddressSpaceArray, ImageProcess[] imageProcessArray) {
        Builder builder = new Builder(this._coreFile, this._reader, l, this._fileResolvingAgent);
        this._coreFile.extract(builder);
        String string4 = builder.getCPUSubType();
        long l3 = builder.getCreationTime();
        this._coreImage = new Image(string, string2, string3, string4, n, l2, l3);
        ImageAddressSpace imageAddressSpace = (ImageAddressSpace)builder.getAddressSpaces().next();
        ImageProcess imageProcess = (ImageProcess)imageAddressSpace.getCurrentProcess();
        Iterator iterator = builder.getAddressSpaces();
        while (iterator.hasNext()) {
            ImageAddressSpace imageAddressSpace2 = (ImageAddressSpace)iterator.next();
            this._coreImage.addAddressSpace(imageAddressSpace2);
            Iterator iterator2 = imageAddressSpace2.getProcesses();
            while (iterator2.hasNext()) {
                ImageProcess imageProcess2 = (ImageProcess)iterator2.next();
                if (imageProcess != null && !this.isProcessForEnvironment(l, imageAddressSpace2, imageProcess2)) continue;
                imageAddressSpace = imageAddressSpace2;
                imageProcess = imageProcess2;
            }
        }
        if (null != imageProcess && imageProcess.getPointerSize() != n2) {
            throw new IllegalStateException("XML and core file pointer sizes differ");
        }
        imageArray[0] = this._coreImage;
        imageAddressSpaceArray[0] = imageAddressSpace;
        imageProcessArray[0] = imageProcess;
    }

    private boolean isProcessForEnvironment(long l, ImageAddressSpace imageAddressSpace, ImageProcess imageProcess) {
        boolean bl = false;
        try {
            long l2 = Long.decode(imageProcess.getID());
            for (int i = 0; i < 64; ++i) {
                long l3 = imageAddressSpace.readPointerAtIndex(l2).getAddress();
                l2 += (long)imageAddressSpace.bytesPerPointer();
                if (l3 != l) continue;
                bl = true;
                break;
            }
        }
        catch (MemoryAccessException memoryAccessException) {
        }
        catch (CorruptDataException corruptDataException) {
        }
        catch (DataUnavailable dataUnavailable) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return bl;
    }

    private void _createCoreImageAfterParseError(Exception exception) {
        Builder builder = new Builder(this._coreFile, this._reader, 0L, this._fileResolvingAgent);
        this._coreFile.extract(builder);
        String string = builder.getOSType();
        String string2 = builder.getCPUType();
        String string3 = builder.getCPUSubType();
        long l = builder.getCreationTime();
        this._coreImage = new Image(string, null, string2, string3, 0, 0L, l);
        Iterator iterator = builder.getAddressSpaces();
        while (iterator.hasNext()) {
            ImageAddressSpace imageAddressSpace = (ImageAddressSpace)iterator.next();
            Iterator iterator2 = imageAddressSpace.getProcesses();
            while (iterator2.hasNext()) {
                ImageProcess imageProcess = (ImageProcess)iterator2.next();
                imageProcess.runtimeExtractionFailed(exception);
            }
            this._coreImage.addAddressSpace(imageAddressSpace);
        }
    }
}

