/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.portlet;

import com.ibm.faces.portlet.httpbridge.ActionRequestWrapper;
import com.ibm.faces.portlet.httpbridge.ActionResponseWrapper;
import com.ibm.faces.portlet.httpbridge.PortletContextWrapper;
import com.ibm.faces.portlet.httpbridge.PortletExternalContextWrapper;
import com.ibm.faces.portlet.httpbridge.PortletFacesContextWrapper;
import com.ibm.faces.portlet.httpbridge.PortletRequestWrapper;
import com.ibm.faces.portlet.httpbridge.PortletResponseWrapper;
import com.ibm.faces.portlet.httpbridge.RenderRequestWrapper;
import com.ibm.faces.portlet.httpbridge.RenderResponseWrapper;
import com.ibm.faces.portlet.util.Base64;
import com.ibm.faces.portlet.util.ViewStructure;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;

public class FacesPortlet
extends GenericPortlet {
    private static final PortletMode CONFIG_MODE = new PortletMode("config");

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws PortletException {
        String actionURL;
        ActionRequestWrapper request = new ActionRequestWrapper(actionRequest);
        request.setPortletContext(this.getPortletContext());
        ActionResponseWrapper response = new ActionResponseWrapper(actionResponse);
        Lifecycle lifecycle = this.getLifecycle(request);
        FacesContext context = this.getFacesContext(request, response, lifecycle);
        Map paramMap = context.getExternalContext().getRequestParameterMap();
        String actionName = (String)paramMap.get("com.ibm.portal.propertybroker.action");
        if (actionName != null && (actionURL = this.getPortletConfig().getInitParameter(actionName)) != null) {
            Enumeration names = request.getParameterNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                String value = request.getParameter(name);
                String param = this.getPortletConfig().getInitParameter(name);
                if (param != null) {
                    Map sessionMap = context.getExternalContext().getSessionMap();
                    String portletId = (String)sessionMap.get("com.ibm.faces.portlet.CURRENT_PORTLET_ID");
                    portletId = "view" + portletId;
                    paramMap.put(String.valueOf(portletId) + ':' + param, value);
                    continue;
                }
                paramMap.put(name, value);
            }
            this.parseAction(actionURL, context);
        }
        String currentMode = null;
        PortletMode mode = actionRequest.getPortletMode();
        currentMode = mode.equals((Object)PortletMode.EDIT) ? "edit" : (mode.equals((Object)PortletMode.VIEW) ? "view" : (mode.equals((Object)PortletMode.HELP) ? "help" : mode.toString()));
        this.restorePage(context, currentMode);
        try {
            lifecycle.execute(context);
        }
        catch (FacesException e) {
            e.printStackTrace();
            Throwable t = e.getCause();
            if (t == null) {
                throw new PortletException(e.getMessage(), (Throwable)e);
            }
            if (t instanceof PortletException) {
                throw (PortletException)t;
            }
            throw new PortletException(t.getMessage(), t);
        }
        if (context.getResponseComplete()) {
            return;
        }
        this.saveViewState(context);
        this.saveFacesMessages(context);
        this.saveRequestParameters(context);
        this.saveLocalRequestMap(context);
        this.savePage(context, currentMode);
    }

    private void parseAction(String url, FacesContext context) {
        String value;
        String name;
        int eq;
        String param;
        if (url == null) {
            return;
        }
        Map map = context.getExternalContext().getRequestParameterMap();
        int i = url.indexOf(63);
        if (i < 0) {
            map.put("javax.servlet.include.path_info", url);
            return;
        }
        String view = url.substring(0, i);
        map.put("javax.servlet.include.path_info", view);
        url = url.substring(i + 1);
        i = url.indexOf(38);
        Map sessionMap = context.getExternalContext().getSessionMap();
        String portletId = (String)sessionMap.get("com.ibm.faces.portlet.CURRENT_PORTLET_ID");
        portletId = "view" + portletId;
        while (i >= 0) {
            param = url.substring(0, i);
            eq = param.indexOf(61);
            if (eq < 0) {
                map.put(String.valueOf(portletId) + ':' + param, new String());
            } else {
                name = param.substring(0, eq);
                value = param.substring(eq + 1);
                map.put(String.valueOf(portletId) + ':' + name, value);
            }
            url = url.substring(i + 1);
            i = url.indexOf(38);
        }
        if (url.length() > 0) {
            param = url;
            eq = param.indexOf(61);
            if (eq < 0) {
                map.put(String.valueOf(portletId) + ':' + param, new String());
            } else {
                name = param.substring(0, eq);
                value = param.substring(eq + 1);
                map.put(String.valueOf(portletId) + ':' + name, value);
            }
        }
    }

    protected void doDispatch(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        if (!WindowState.MINIMIZED.equals((Object)request.getWindowState())) {
            PortletMode mode = request.getPortletMode();
            if (mode.equals((Object)PortletMode.VIEW)) {
                this.doView(request, response);
            } else if (mode.equals((Object)PortletMode.EDIT)) {
                this.doEdit(request, response);
            } else if (mode.equals((Object)PortletMode.HELP)) {
                this.doHelp(request, response);
            } else if (mode.equals((Object)CONFIG_MODE)) {
                this.doConfigure(request, response);
            } else {
                this.doRender(request, response, mode.toString());
            }
        }
    }

    protected void doRender(RenderRequest renderRequest, RenderResponse renderResponse, String mode) throws IOException, PortletException {
        RenderRequestWrapper request = new RenderRequestWrapper(renderRequest);
        request.setPortletContext(this.getPortletContext());
        RenderResponseWrapper response = new RenderResponseWrapper(renderResponse);
        this.restoreLocalRequestMap(request);
        Lifecycle lifecycle = this.getLifecycle(request);
        FacesContext context = this.getFacesContext(request, response, lifecycle);
        this.restorePage(context, mode);
        Object previousMode = context.getExternalContext().getRequestParameterMap().get("com.ibm.faces.portlet.mode");
        boolean modeChanged = previousMode != null && !previousMode.equals(mode);
        UIViewRoot viewRoot = null;
        if (!modeChanged) {
            viewRoot = this.restoreViewState(context);
        }
        if (viewRoot == null) {
            String viewId = (String)context.getExternalContext().getRequestMap().get("javax.servlet.include.path_info");
            viewRoot = context.getApplication().getViewHandler().createView(context, viewId);
        }
        context.setViewRoot(viewRoot);
        if (!modeChanged) {
            this.restoreFacesMessages(context);
        }
        try {
            lifecycle.render(context);
        }
        catch (FacesException e) {
            Throwable t = e.getCause();
            if (t == null) {
                throw new PortletException(e.getMessage(), (Throwable)e);
            }
            if (t instanceof PortletException) {
                throw (PortletException)t;
            }
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw new PortletException(t.getMessage(), t);
        }
        request.removeAttribute("javax.faces.webapp.CURRENT_VIEW_ROOT");
        Map sessionMap = context.getExternalContext().getSessionMap();
        sessionMap.put("com.ibm.faces.portlet.CURRENT_PORTLET_ID", context.getExternalContext().encodeNamespace(""));
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.doRender(request, response, "view");
    }

    public void doEdit(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.doRender(request, response, "edit");
    }

    public void doConfigure(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.doRender(request, response, "config");
    }

    public void doHelp(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.doRender(request, response, "help");
    }

    private void restorePage(FacesContext context, String mode) {
        Map sessionMap;
        Map requestMap = context.getExternalContext().getRequestMap();
        if (requestMap == null) {
            return;
        }
        Object previousMode = context.getExternalContext().getRequestParameterMap().get("com.ibm.faces.portlet.mode");
        boolean modeChanged = previousMode != null && !previousMode.equals(mode);
        String page = this.getView(context, mode);
        if (page == null && !modeChanged) {
            page = (String)context.getExternalContext().getRequestParameterMap().get("javax.servlet.include.path_info");
        }
        if (page == null && (sessionMap = context.getExternalContext().getSessionMap()) != null) {
            page = (String)sessionMap.get("com.ibm.faces.portlet.page." + mode);
        }
        if (page == null) {
            page = this.getPortletConfig().getInitParameter("com.ibm.faces.portlet.page." + mode);
        }
        requestMap.put("javax.servlet.include.path_info", page);
    }

    private void savePage(FacesContext context, String mode) {
        String page = null;
        UIViewRoot viewRoot = context.getViewRoot();
        if (viewRoot != null) {
            page = viewRoot.getViewId();
        }
        if (page == null) {
            return;
        }
        PortletResponse response = ((PortletExternalContextWrapper)context.getExternalContext()).getPortletResponse();
        if (response instanceof ActionResponse && !context.getResponseComplete()) {
            ((ActionResponse)response).setRenderParameter("javax.servlet.include.path_info", page);
            ((ActionResponse)response).setRenderParameter("com.ibm.faces.portlet.mode", mode);
        }
    }

    private Lifecycle getLifecycle(PortletRequestWrapper request) throws PortletException {
        Lifecycle lifecycle = null;
        LifecycleFactory lifecycleFactory = null;
        try {
            lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
            String lifecycleId = this.getInitParameter("com.sun.faces.lifecycle.LIFECYCLE_ID");
            if (lifecycleId == null) {
                lifecycleId = "DEFAULT";
            }
            lifecycle = lifecycleFactory.getLifecycle(lifecycleId);
        }
        catch (FacesException e) {
            Throwable rootCause = e.getCause();
            if (rootCause == null) {
                throw e;
            }
            throw new PortletException(e.getMessage(), (Throwable)e);
        }
        return lifecycle;
    }

    private FacesContext getFacesContext(PortletRequestWrapper request, PortletResponseWrapper response, Lifecycle lifecycle) throws PortletException {
        Object contextWrapper;
        FacesContext context = null;
        FacesContextFactory facesContextFactory = null;
        try {
            facesContextFactory = (FacesContextFactory)FactoryFinder.getFactory((String)"javax.faces.context.FacesContextFactory");
        }
        catch (FacesException e) {
            Throwable rootCause = e.getCause();
            if (rootCause == null) {
                throw e;
            }
            throw new PortletException(e.getMessage(), (Throwable)e);
        }
        if (facesContextFactory != null) {
            contextWrapper = new PortletContextWrapper(this.getPortletContext());
            ((PortletContextWrapper)contextWrapper).setPorletConfig(this.getPortletConfig());
            context = facesContextFactory.getFacesContext(contextWrapper, (Object)request, (Object)response, lifecycle);
        }
        contextWrapper = new PortletFacesContextWrapper(context, this.getPortletConfig());
        ((PortletFacesContextWrapper)((Object)contextWrapper)).setCurrentInstance();
        return contextWrapper;
    }

    protected void saveObjectInRenderParam(ActionResponse actionResponse, Object object, String renderParamName) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream output = new ObjectOutputStream(bos);
            output.writeObject(object);
            String strObject = Base64.encode(bos.toByteArray());
            actionResponse.setRenderParameter(renderParamName, strObject);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    protected Object restoreObjectFromRequestParam(RenderRequest renderRequest, String paramName) {
        String strObject = renderRequest.getParameter(paramName);
        Object object = null;
        if (strObject != null) {
            try {
                byte[] bytes = Base64.decode(strObject);
                ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bytes));
                object = ois.readObject();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return object;
    }

    protected void saveViewState(FacesContext context) {
        UIViewRoot viewRoot = context.getViewRoot();
        if (viewRoot.getChildCount() > 0) {
            ViewStructure structure = new ViewStructure((UIComponent)viewRoot);
            structure.buildStructure(context, (UIComponent)viewRoot, structure);
            Object state = viewRoot.processSaveState(context);
            Object[] viewState = new Object[]{structure, state};
            this.saveObjectInRenderParam((ActionResponseWrapper)context.getExternalContext().getResponse(), viewState, "com.ibm.faces.VIEW_STATE");
        }
    }

    protected UIViewRoot restoreViewState(FacesContext context) {
        UIViewRoot viewRoot = null;
        Object[] viewState = (Object[])this.restoreObjectFromRequestParam((RenderRequestWrapper)context.getExternalContext().getRequest(), "com.ibm.faces.VIEW_STATE");
        if (viewState != null) {
            try {
                ViewStructure structure = (ViewStructure)viewState[0];
                viewRoot = (UIViewRoot)structure.createComponent();
                structure.restoreStructure(structure, (UIComponent)viewRoot);
                viewRoot.processRestoreState(context, viewState[1]);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return viewRoot;
    }

    protected void saveFacesMessages(FacesContext context) {
        Vector<Object> messagesList = new Vector<Object>();
        Iterator clientIdsIterator = context.getClientIdsWithMessages();
        while (clientIdsIterator.hasNext()) {
            String clientId = (String)clientIdsIterator.next();
            Iterator messagesIterator = context.getMessages(clientId);
            while (messagesIterator.hasNext()) {
                FacesMessage message = (FacesMessage)messagesIterator.next();
                String detail = message.getDetail();
                String summary = message.getSummary();
                Integer severety = new Integer(message.getSeverity().getOrdinal());
                messagesList.add(clientId);
                messagesList.add(detail);
                messagesList.add(summary);
                messagesList.add(severety);
            }
        }
        if (messagesList.size() > 0) {
            this.saveObjectInRenderParam((ActionResponseWrapper)context.getExternalContext().getResponse(), messagesList, "com.ibm.faces.FACES_MESSAGES");
        }
    }

    protected void restoreFacesMessages(FacesContext context) {
        List messagesList = (List)this.restoreObjectFromRequestParam((RenderRequestWrapper)context.getExternalContext().getRequest(), "com.ibm.faces.FACES_MESSAGES");
        if (messagesList != null) {
            int i = 0;
            while (i < messagesList.size()) {
                String clientId = (String)messagesList.get(i);
                String detail = (String)messagesList.get(i + 1);
                String summary = (String)messagesList.get(i + 2);
                Integer severety = (Integer)messagesList.get(i + 3);
                FacesMessage message = new FacesMessage(summary, detail);
                switch (severety) {
                    case 1: {
                        message.setSeverity(FacesMessage.SEVERITY_WARN);
                        break;
                    }
                    case 2: {
                        message.setSeverity(FacesMessage.SEVERITY_ERROR);
                        break;
                    }
                    case 3: {
                        message.setSeverity(FacesMessage.SEVERITY_FATAL);
                        break;
                    }
                    default: {
                        message.setSeverity(FacesMessage.SEVERITY_INFO);
                    }
                }
                context.addMessage(clientId, message);
                i += 4;
            }
        }
    }

    protected void saveLocalRequestMap(FacesContext context) {
        PortletRequestWrapper request = (PortletRequestWrapper)context.getExternalContext().getRequest();
        Map localMap = request.getLocalMap();
        HashMap map = new HashMap();
        Set keys = localMap.keySet();
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            Object value = localMap.get(key);
            if (!this.isParamStorable(key) || !(value instanceof Serializable)) continue;
            map.put(key, value);
        }
        if (map.size() > 0) {
            this.saveObjectInRenderParam((ActionResponseWrapper)context.getExternalContext().getResponse(), map, "com.ibm.faces.REQUEST_MAP.");
        }
    }

    protected void restoreLocalRequestMap(PortletRequestWrapper request) {
        Map map = (Map)this.restoreObjectFromRequestParam((RenderRequestWrapper)request, "com.ibm.faces.REQUEST_MAP.");
        if (map != null) {
            request.addLocalMap(map);
        }
    }

    protected void saveRequestParameters(FacesContext context) {
        Map map = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap();
        Set keys = map.keySet();
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (!this.isParamStorable(key)) continue;
            String value = (String)map.get(key);
            ((ActionResponseWrapper)context.getExternalContext().getResponse()).setRenderParameter(key, value);
        }
    }

    protected boolean isParamStorable(String paramName) {
        if (paramName.startsWith("view")) {
            return false;
        }
        if (paramName.startsWith("javax.")) {
            return false;
        }
        if (paramName.startsWith("com.ibm.faces.")) {
            return false;
        }
        if (paramName.startsWith("com.sun.faces.")) {
            return false;
        }
        if (paramName.startsWith("com.ibm.ws.jsf.")) {
            return false;
        }
        return !paramName.equals("__LINK_TARGET__");
    }

    protected String getView(FacesContext context, String mode) {
        return null;
    }
}

