/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.portlet.httpbridge;

import com.ibm.faces.portlet.httpbridge.PortletConfigParameterMap;
import com.ibm.faces.portlet.httpbridge.PortletContextWrapper;
import com.ibm.faces.portlet.httpbridge.PortletPreferencesMap;
import com.ibm.faces.portlet.httpbridge.PortletRenderParameterMap;
import com.ibm.faces.portlet.httpbridge.PortletRequestParameterMap;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Principal;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.faces.context.ExternalContext;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponseWrapper;

public class PortletExternalContextWrapper
extends ExternalContext {
    private ExternalContext context = null;
    private PortletConfig portletConfig = null;
    private Map requestParameterMap = null;
    private Map renderParameterMap = null;
    private Map configParameterMap = null;
    private Map portletPreferencesMap = null;

    public PortletExternalContextWrapper(ExternalContext externalContext, PortletConfig config) {
        this.context = externalContext;
        this.portletConfig = config;
    }

    public PortletResponse getPortletResponse() {
        Object resp = this.context.getResponse();
        while (resp instanceof HttpServletResponseWrapper) {
            resp = ((HttpServletResponseWrapper)resp).getResponse();
        }
        if (resp instanceof PortletResponse) {
            return (PortletResponse)resp;
        }
        return null;
    }

    public PortletRequest getPortletRequest() {
        Object req = this.context.getRequest();
        while (req instanceof HttpServletRequestWrapper) {
            req = ((HttpServletRequestWrapper)req).getRequest();
        }
        if (req instanceof PortletRequest) {
            return (PortletRequest)req;
        }
        return null;
    }

    public void dispatch(String path) throws IOException {
        this.context.dispatch(path);
    }

    public String encodeActionURL(String url) {
        String params = null;
        int n = url.indexOf(63);
        if (n > 0) {
            params = url.substring(n + 1);
            url = url.substring(0, n);
        }
        if (url.startsWith(this.getRequestContextPath())) {
            url = url.substring(this.getRequestContextPath().length());
        }
        if (url.startsWith(this.getRequestServletPath())) {
            url = url.substring(this.getRequestServletPath().length());
        }
        PortletURL actionURL = ((RenderResponse)this.getPortletResponse()).createActionURL();
        if (url != null) {
            actionURL.setParameter("javax.servlet.include.path_info", url);
        }
        if (params != null) {
            this.addParams(params, actionURL);
        }
        return actionURL.toString();
    }

    public String encodeNamespace(String name) {
        String ns = ((RenderResponse)this.getPortletResponse()).getNamespace();
        return String.valueOf(ns) + name;
    }

    public String encodeResourceURL(String url) {
        String protocol = this.getURLProtocol(url);
        if (protocol != null && !protocol.startsWith("http")) {
            return url;
        }
        if (url.indexOf("//") == -1) {
            String params = null;
            String jspUrl = url;
            int n = url.indexOf(63);
            if (n > 0) {
                params = url.substring(n + 1);
                jspUrl = url.substring(0, n);
            }
            if (jspUrl.endsWith(".jsp")) {
                url = jspUrl;
                if (url.startsWith(this.getRequestContextPath())) {
                    url = url.substring(this.getRequestContextPath().length());
                }
                if (url.startsWith(this.getRequestServletPath())) {
                    url = url.substring(this.getRequestServletPath().length());
                }
                PortletURL actionURL = ((RenderResponse)this.getPortletResponse()).createRenderURL();
                if (url != null) {
                    actionURL.setParameter("javax.servlet.include.path_info", url);
                }
                if (params != null) {
                    this.addParams(params, actionURL);
                }
                return actionURL.toString();
            }
        }
        if (!url.startsWith("/") && url.indexOf(58) == -1) {
            String path = (String)((RenderRequest)this.getPortletRequest()).getAttribute("javax.servlet.include.request_uri");
            int n = path.lastIndexOf("/");
            url = String.valueOf(path.substring(0, n + 1)) + url;
        }
        return ((RenderResponse)this.getPortletResponse()).encodeURL(url);
    }

    private void addParams(String params, PortletURL portletUrl) {
        if (params != null && params.indexOf("=") > -1) {
            int pos1 = 0;
            int pos2 = 0;
            String name = null;
            String value = null;
            while (pos1 > -1) {
                pos2 = params.indexOf("=", pos1);
                name = params.substring(pos1, pos2);
                pos1 = params.indexOf("&", pos2);
                if (pos1 == -1) {
                    value = params.substring(pos2 + 1);
                } else {
                    value = params.substring(pos2 + 1, pos1);
                    ++pos1;
                }
                portletUrl.setParameter(name, value);
            }
        }
    }

    public Map getApplicationMap() {
        return this.context.getApplicationMap();
    }

    public String getAuthType() {
        return this.context.getAuthType();
    }

    public Object getContext() {
        String initParam = this.getInitParameter("com.ibm.faces.portlet.EXTCONTEXT_RETURN_SERVLETCONTEXT");
        if (initParam != null && initParam.toLowerCase().equals("true")) {
            return this.context.getContext();
        }
        return ((PortletContextWrapper)this.context.getContext()).getPortletContext();
    }

    public String getInitParameter(String name) {
        return this.context.getInitParameter(name);
    }

    public Map getInitParameterMap() {
        return this.context.getInitParameterMap();
    }

    public String getRemoteUser() {
        return this.context.getRemoteUser();
    }

    public Object getRequest() {
        return this.getPortletRequest();
    }

    public String getRequestContextPath() {
        return this.context.getRequestContextPath();
    }

    public Map getRequestCookieMap() {
        return this.context.getRequestCookieMap();
    }

    public Map getRequestHeaderMap() {
        return this.context.getRequestHeaderMap();
    }

    public Map getRequestHeaderValuesMap() {
        return this.context.getRequestHeaderValuesMap();
    }

    public Locale getRequestLocale() {
        return this.context.getRequestLocale();
    }

    public Iterator getRequestLocales() {
        return this.context.getRequestLocales();
    }

    public Map getRequestMap() {
        return this.context.getRequestMap();
    }

    public Map getRequestParameterMap() {
        if (this.requestParameterMap == null) {
            this.requestParameterMap = new PortletRequestParameterMap(this.context);
        }
        return this.requestParameterMap;
    }

    public Iterator getRequestParameterNames() {
        return this.context.getRequestParameterNames();
    }

    public Map getRequestParameterValuesMap() {
        return this.context.getRequestParameterValuesMap();
    }

    public String getRequestPathInfo() {
        String s = (String)this.getRequestMap().get("javax.servlet.include.path_info");
        if (s == null) {
            s = (String)this.getRequestParameterMap().get("javax.servlet.include.path_info");
        }
        if (s != null) {
            if (s.startsWith(this.getRequestContextPath())) {
                s = s.substring(this.getRequestContextPath().length());
            }
            if (s.startsWith(this.getRequestServletPath())) {
                s = s.substring(this.getRequestServletPath().length());
            }
        }
        return s;
    }

    public String getRequestServletPath() {
        return "/portlet";
    }

    public URL getResource(String path) throws MalformedURLException {
        return this.context.getResource(path);
    }

    public InputStream getResourceAsStream(String path) {
        return this.context.getResourceAsStream(path);
    }

    public Set getResourcePaths(String path) {
        return this.context.getResourcePaths(path);
    }

    public Object getResponse() {
        return this.getPortletResponse();
    }

    public Object getSession(boolean create) {
        return this.context.getSession(create);
    }

    public Map getSessionMap() {
        return this.context.getSessionMap();
    }

    public Principal getUserPrincipal() {
        return this.context.getUserPrincipal();
    }

    public boolean isUserInRole(String role) {
        return this.context.isUserInRole(role);
    }

    public void log(String message) {
        this.context.log(message);
    }

    public void log(String message, Throwable exception) {
        this.context.log(message, exception);
    }

    public void redirect(String url) throws IOException {
        this.context.redirect(url);
    }

    public String getURLProtocol(String url) {
        StringBuffer protocol = new StringBuffer();
        char[] chars = url.toCharArray();
        int length = chars.length;
        int i = 0;
        while (i < length) {
            if (chars[i] == ':') {
                return protocol.toString();
            }
            if (!Character.isLetter(chars[i])) {
                return null;
            }
            protocol.append(chars[i]);
            ++i;
        }
        return null;
    }

    public Map getRenderParameterMap() {
        if (this.renderParameterMap == null) {
            this.renderParameterMap = new PortletRenderParameterMap(this.getPortletRequest(), this.getPortletResponse());
        }
        return this.renderParameterMap;
    }

    public Map getConfigParameterMap() {
        if (this.configParameterMap == null) {
            this.configParameterMap = new PortletConfigParameterMap(this.portletConfig);
        }
        return this.configParameterMap;
    }

    public Map getPortletPreferencesMap() {
        if (this.portletPreferencesMap == null) {
            this.portletPreferencesMap = new PortletPreferencesMap(this.getPortletRequest().getPreferences());
        }
        return this.portletPreferencesMap;
    }
}

