/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.portlet.httpbridge;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletPreferences;
import javax.portlet.ReadOnlyException;
import javax.portlet.ValidatorException;

class PortletPreferencesMap
extends AbstractMap {
    private PortletPreferences preferences = null;

    PortletPreferencesMap(PortletPreferences preferences) {
        this.preferences = preferences;
    }

    public Object get(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this.preferences.getValue(key.toString(), null);
    }

    public Object put(Object key, Object value) {
        if (key == null) {
            throw new NullPointerException();
        }
        String keyString = key.toString();
        String result = this.preferences.getValue(keyString, null);
        String valueString = null;
        if (value != null) {
            valueString = value.toString();
        }
        try {
            this.preferences.setValue(keyString, valueString);
            this.preferences.store();
        }
        catch (ReadOnlyException readOnlyException) {
        }
        catch (ValidatorException validatorException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public Object remove(Object key) {
        if (key == null) {
            return null;
        }
        String keyString = key.toString();
        String result = this.preferences.getValue(keyString, null);
        try {
            this.preferences.reset(keyString);
            this.preferences.store();
        }
        catch (ReadOnlyException readOnlyException) {
        }
        catch (ValidatorException validatorException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public Set entrySet() {
        HashSet<Entry> entries = new HashSet<Entry>();
        Enumeration e = this.preferences.getNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            entries.add(new Entry(key, this.preferences.getValue(key, null)));
        }
        return entries;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof PortletPreferencesMap)) {
            return false;
        }
        return super.equals(obj);
    }

    static class Entry
    implements Map.Entry {
        private final Object key;
        private final Object value;

        Entry(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            throw new UnsupportedOperationException();
        }

        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry input = (Map.Entry)obj;
            Object inputKey = input.getKey();
            Object inputValue = input.getValue();
            return (inputKey == this.key || inputKey != null && inputKey.equals(this.key)) && (inputValue == this.value || inputValue != null && inputValue.equals(this.value));
        }
    }
}

