/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.portlet.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;

public class ViewStructure
implements Serializable {
    private static final long serialVersionUID = 1L;
    String className = null;
    ArrayList children = null;
    String id = null;
    HashMap facets = null;

    public ViewStructure(UIComponent component) {
        this.id = component.getId();
        this.className = component.getClass().getName();
    }

    public void addChild(ViewStructure treeStruct) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(treeStruct);
    }

    public Iterator getChildren() {
        if (this.children != null) {
            return this.children.iterator();
        }
        return Collections.EMPTY_LIST.iterator();
    }

    public void addFacet(String facetName, ViewStructure treeStruct) {
        if (this.facets == null) {
            this.facets = new HashMap();
        }
        this.facets.put(facetName, treeStruct);
    }

    public ViewStructure getViewStructureForFacet(String facetName) {
        if (this.facets != null) {
            return (ViewStructure)this.facets.get(facetName);
        }
        return null;
    }

    public Iterator getFacetNames() {
        if (this.facets != null) {
            return this.facets.keySet().iterator();
        }
        return Collections.EMPTY_LIST.iterator();
    }

    public UIComponent createComponent() {
        UIComponent component = null;
        try {
            Class<?> c = this.getClass().getClassLoader().loadClass(this.className);
            component = (UIComponent)c.newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        component.setId(this.id);
        return component;
    }

    public void buildStructure(FacesContext context, UIComponent component, ViewStructure treeStructure) {
        Iterator children = component.getChildren().iterator();
        while (children.hasNext()) {
            UIComponent child = (UIComponent)children.next();
            if (child.isTransient()) continue;
            ViewStructure structureChild = new ViewStructure(child);
            treeStructure.addChild(structureChild);
            this.buildStructure(context, child, structureChild);
        }
        Iterator facets = component.getFacets().keySet().iterator();
        while (facets.hasNext()) {
            String facetName = (String)facets.next();
            UIComponent facetComponent = (UIComponent)component.getFacets().get(facetName);
            if (facetComponent.isTransient()) continue;
            ViewStructure treeStructureFacet = new ViewStructure(facetComponent);
            treeStructure.addFacet(facetName, treeStructureFacet);
            this.buildStructure(context, facetComponent, treeStructureFacet);
        }
    }

    public void restoreStructure(ViewStructure structure, UIComponent component) {
        Iterator children = structure.getChildren();
        while (children.hasNext()) {
            ViewStructure child = (ViewStructure)children.next();
            UIComponent comp = child.createComponent();
            component.getChildren().add(comp);
            this.restoreStructure(child, comp);
        }
        Iterator facets = structure.getFacetNames();
        while (facets.hasNext()) {
            String facetName = (String)facets.next();
            ViewStructure facetStructure = structure.getViewStructureForFacet(facetName);
            UIComponent facetComponent = facetStructure.createComponent();
            component.getFacets().put(facetName, facetComponent);
            this.restoreStructure(facetStructure, facetComponent);
        }
    }
}

