/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.image.sov;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.Image;
import com.ibm.dtfj.sov.image.ImageProxyImpl;
import com.ibm.dtfj.sov.image.UnsupportedFormatException;
import com.ibm.dtfj.sov.sdffReader.SDFFDump;
import com.ibm.dtfj.sov.svcReader.SvcImageImpl;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class ImageFactory
implements com.ibm.dtfj.image.ImageFactory {
    static /* synthetic */ Class class$com$ibm$dtfj$sov$image$ImageProxy;
    static /* synthetic */ Class class$com$ibm$dtfj$sov$image$AddressSpaceProxy;

    public Image getImage(File source, File metaData) throws IOException {
        ImageProxyImpl imageProxy = null;
        Image image = null;
        String imageName = source.getName();
        if (imageName.endsWith(".sdff")) {
            try {
                imageProxy = new SDFFDump(source);
            }
            catch (UnsupportedFormatException e) {
                System.err.println("\n\t*************************************\n\tDTFJ can only handle SDFF files,\n\twhich MUST have a suffix of \".sdff\"\n\tor svcdumps (if the SVCDump jar is on\n\tthe classpath)\n\t*************************************\n");
                throw new IOException("Currently can only handle SDFF files, which _MUST have a suffix of \".sdff\"_\nor svcdumps");
            }
            catch (CorruptDataException e) {
                IOException ioe = new IOException("Corrupt data in " + source);
                ioe.initCause(e);
                throw ioe;
            }
        }
        try {
            imageProxy = new SvcImageImpl(source);
        }
        catch (NoClassDefFoundError err) {
        }
        catch (UnsupportedFormatException e) {
            System.err.println("\n\t*************************************\n\tDTFJ can only handle SDFF files,\n\twhich MUST have a suffix of \".sdff\"\n\tor svcdumps (if the SVCDump jar is on\n\tthe classpath)\n\t*************************************\n");
            throw new IOException("Currently can only handle SDFF files, which _MUST have a suffix of \".sdff\"_\nor svcdumps");
        }
        if (metaData == null) {
            ((ImageProxyImpl)imageProxy).initStructures(new File(source.getName() + ".xml"));
        } else {
            ((ImageProxyImpl)imageProxy).loadExternalStructures(metaData);
        }
        Class<?> imageEffigyClass = null;
        try {
            String platformName = imageProxy.getSystemType().toLowerCase();
            if (platformName.equals("z/os")) {
                platformName = "zos";
            }
            imageEffigyClass = Class.forName("com.ibm.dtfj.sov.imp." + platformName + ".ImageEffigy");
        }
        catch (ClassNotFoundException e1) {
            e1.printStackTrace();
        }
        Class[] constArgs = new Class[]{class$com$ibm$dtfj$sov$image$ImageProxy == null ? (class$com$ibm$dtfj$sov$image$ImageProxy = ImageFactory.class$("com.ibm.dtfj.sov.image.ImageProxy")) : class$com$ibm$dtfj$sov$image$ImageProxy, class$com$ibm$dtfj$sov$image$AddressSpaceProxy == null ? (class$com$ibm$dtfj$sov$image$AddressSpaceProxy = ImageFactory.class$("com.ibm.dtfj.sov.image.AddressSpaceProxy")) : class$com$ibm$dtfj$sov$image$AddressSpaceProxy};
        Constructor<?> construct = null;
        try {
            construct = imageEffigyClass.getConstructor(constArgs);
        }
        catch (SecurityException e2) {
            e2.printStackTrace();
        }
        catch (NoSuchMethodException e2) {
            e2.printStackTrace();
        }
        Object[] createArgs = new Object[]{imageProxy, null};
        try {
            image = (Image)construct.newInstance(createArgs);
        }
        catch (IllegalArgumentException e3) {
            e3.printStackTrace();
        }
        catch (InstantiationException e3) {
            e3.printStackTrace();
        }
        catch (IllegalAccessException e3) {
            e3.printStackTrace();
        }
        catch (InvocationTargetException e3) {
            e3.printStackTrace();
        }
        return image;
    }

    public Image getImage(File imageFile) throws IOException {
        return this.getImage(imageFile, null);
    }

    public int getDTFJMajorVersion() {
        return 1;
    }

    public int getDTFJMinorVersion() {
        return 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

