/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.sov;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.sov.data.DataObject;
import com.ibm.dtfj.sov.data.DescriptorMember;
import com.ibm.dtfj.sov.data.StructuredObject;
import com.ibm.dtfj.sov.image.AddressSpaceProxy;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;

public class Effigy {
    public static String packageNameDot = "com.ibm.dtfj.";
    protected StructuredObject myStructuredObject = null;
    protected AddressSpaceProxy context = null;

    public Effigy(StructuredObject structuredObject, AddressSpaceProxy context) {
        this.myStructuredObject = structuredObject;
        this.context = context;
        this.setPackageName();
    }

    public Effigy(AddressSpaceProxy context) {
        this.context = context;
        this.setPackageName();
    }

    private void setPackageName() {
        if (packageNameDot == null) {
            packageNameDot = this.getClass().getPackage().getName();
            packageNameDot = packageNameDot.substring(0, packageNameDot.indexOf("sov"));
        }
    }

    public StructuredObject getDataObject() {
        return this.myStructuredObject;
    }

    public static Effigy create(String effigyName, Object proxy, AddressSpaceProxy context, String platform) {
        if (proxy == null) {
            return null;
        }
        int lastDotPos = effigyName.lastIndexOf(46);
        if (lastDotPos != -1) {
            effigyName = effigyName.substring(lastDotPos + 1);
        }
        try {
            Class<?> effigyClass = Class.forName(Effigy.getFullEffigyName(effigyName, platform));
            Class[] parmtypes = new Class[2];
            parmtypes[0] = null;
            Class<?> proxyClass = proxy.getClass();
            if (proxyClass.getName().endsWith("Proxy")) {
                parmtypes[0] = proxyClass;
            } else {
                Class<?>[] proxyInterfaces = proxyClass.getInterfaces();
                for (int i = 0; i < proxyInterfaces.length; ++i) {
                    if (!proxyInterfaces[i].getName().endsWith("Proxy")) continue;
                    parmtypes[0] = proxyInterfaces[i];
                    break;
                }
            }
            parmtypes[1] = Class.forName(packageNameDot + "sov.image.AddressSpaceProxy");
            Constructor<?> cstr = effigyClass.getConstructor(parmtypes);
            Object[] arglist = new Object[]{proxy, context};
            return (Effigy)cstr.newInstance(arglist);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static Effigy create(String effigyName, Long address, AddressSpaceProxy context, String platform) throws CorruptDataException {
        if (address == null) {
            return null;
        }
        return Effigy.create(effigyName, (long)address, context, platform);
    }

    public static Effigy create(String effigyName, long address, AddressSpaceProxy context, String platform) throws CorruptDataException {
        if (address == 0L) {
            return null;
        }
        try {
            Class<?> eclass = Class.forName(Effigy.getFullEffigyName(effigyName, platform));
            Field field = eclass.getField("MaptoLocator");
            String mapTo = (String)field.get(null);
            DataObject returnDO = new DataObject(null, mapTo, context);
            returnDO.setAddress(address);
            Class[] parmtypes = new Class[]{Class.forName(packageNameDot + "sov.data.DataObject"), Class.forName(packageNameDot + "sov.image.AddressSpaceProxy")};
            Constructor<?> cstr = eclass.getConstructor(parmtypes);
            Object[] arglist = new Object[]{returnDO, context};
            return (Effigy)cstr.newInstance(arglist);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CorruptDataException) {
                throw (CorruptDataException)e.getCause();
            }
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public static Effigy create(String effigyName, Object owner, AddressSpaceProxy context, String mapto, String platform) throws CorruptDataException {
        try {
            Class<?> eclass = Class.forName(Effigy.getFullEffigyName(effigyName, platform));
            if (mapto == null || mapto.length() == 0) {
                try {
                    Field maptoField = eclass.getField("MaptoLocator");
                    mapto = (String)maptoField.get(null);
                }
                catch (NoSuchFieldException e) {
                    // empty catch block
                }
            }
            DataObject effigyDataObject = new DataObject(owner, mapto, context);
            Class[] parmtypes = new Class[]{Class.forName(packageNameDot + "sov.data.DataObject"), Class.forName(packageNameDot + "sov.image.AddressSpaceProxy")};
            Constructor<?> cstr = eclass.getConstructor(parmtypes);
            Object[] arglist = new Object[]{effigyDataObject, context};
            Effigy newEffigy = (Effigy)cstr.newInstance(arglist);
            return newEffigy;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    private static String getFullEffigyName(String effigyName, String platform) {
        String fullEffigyName = effigyName.indexOf(46) != -1 ? effigyName : packageNameDot + "sov.imp." + platform + "." + effigyName;
        return fullEffigyName;
    }

    private static void throwInstantiationException(String effigyName, Exception e) throws InstantiationException {
        InstantiationException x = new InstantiationException("Creating class " + effigyName + ": " + e.toString());
        x.setStackTrace(e.getStackTrace());
        throw x;
    }

    public Iterator getMemberNames() {
        return this.myStructuredObject.getDescriptor().getMemberNames();
    }

    public DescriptorMember getMember(String name) {
        return this.myStructuredObject.getDescriptor().getMember(name);
    }

    public long getEffigyAddress() {
        return this.myStructuredObject.getAddress();
    }

    public String getString(String memberName) throws CorruptDataException, MemoryAccessException {
        return this.myStructuredObject.getReader().getString(memberName);
    }

    public long getLong(String memberName) throws CorruptDataException, MemoryAccessException {
        return this.myStructuredObject.getReader().getLong(memberName);
    }

    public int getInteger(String memberName) throws MemoryAccessException, CorruptDataException {
        return this.myStructuredObject.getReader().getInteger(memberName);
    }

    public char getCharacter(String memberName) throws MemoryAccessException, CorruptDataException {
        return this.myStructuredObject.getReader().getChar(memberName).charValue();
    }

    public byte getByte(String memberName) throws MemoryAccessException, CorruptDataException {
        return this.myStructuredObject.getReader().getByte(memberName);
    }

    public short getShort(String memberName) throws MemoryAccessException, CorruptDataException {
        return this.myStructuredObject.getReader().getShort(memberName);
    }

    public float getFloat(String memberName) throws MemoryAccessException, CorruptDataException {
        return this.myStructuredObject.getReader().getFloat(memberName).floatValue();
    }

    public double getDouble(String memberName) throws MemoryAccessException, CorruptDataException {
        return this.myStructuredObject.getReader().getDouble(memberName);
    }

    public boolean getBoolean(String memberName) throws MemoryAccessException, CorruptDataException {
        return this.myStructuredObject.getReader().getBoolean(memberName);
    }
}

