/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.sov;

import com.ibm.dtfj.sov.EffigyDescriptor;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class EffigyGenerator
extends DefaultHandler {
    EffigyDescriptor currentEffigy;
    static String xmlIn = null;
    static String sourceDir = null;
    static String projectPackageName = null;
    static String projectPackagePath = null;
    StringBuffer javadoc = new StringBuffer();
    boolean javaDocElement = false;
    static HashSet platformList;
    static HashMap substitutionList;
    static final String initialContentTemplate = "// EffigyGenerator Template Code : ict\n\n\n/*\n * ===========================================================================\n * IBM Confidential.\n * OCO Source Materials \n * IBM SDK, Java(tm) 2 Technology Edition, v1.4.2 \n * (C) Copyright IBM Corp. 2005.\n * The source code for this program is not published or otherwise divested of\n * its trade secrets, irrespective of what has been deposited with the U.S.\n * Copyright office.\n * ===========================================================================\n */\n\n/**\n * This file is auto-generated. DO NOT modify.\n * Updates should be made to %xmlIn%\n */\npackage %projectPackageName%.%packageSuffix%;\nimport %projectPackageName%.image.*;\nimport %projectPackageName%.runtime.*;\nimport %projectPackageName%.java.*;\nimport %projectPackageName%.java.sov.*;\nimport %projectPackageName%.sov.*;\nimport %projectPackageName%.sov.data.*;\nimport %projectPackageName%.sov.image.*;\nimport %projectPackageName%.sov.java.*;\nimport java.util.*;\n\n//docs\n";
    static final String proxyEqualsAndHash = "\n// EffigyGenerator Template Code : peah\n    public int hashCode() { return myproxy.hashCode(); } // Delegate hashing to our proxy\n    public boolean equals(Object obj) { return myproxy.equals(obj); } // Delegate equality checking to our proxy\n\n";
    static final String dataObjectEqualsAndHash = "// EffigyGenerator Template Code : doeah\n\n    public int hashCode() { return MyDataObject.hashCode(); } // Delegate hashing to our DataObject\n    public boolean equals(Object obj) { \n        return (obj instanceof %effigyClassName%) &&  \n               MyDataObject.equals(((%effigyClassName%)obj).MyDataObject);  \n    } // Delegate equality checking to our DataObject\n";
    static final String implementationHeaderTemplate = "// EffigyGenerator Template Code : ict\n\n\n/*\n * ===========================================================================\n * IBM Confidential.\n * OCO Source Materials \n * IBM SDK, Java(tm) 2 Technology Edition, v1.4.2 \n * (C) Copyright IBM Corp. 2005.\n * The source code for this program is not published or otherwise divested of\n * its trade secrets, irrespective of what has been deposited with the U.S.\n * Copyright office.\n * ===========================================================================\n */\n\n/**\n * This file is auto-generated. DO NOT modify.\n * Updates should be made to %xmlIn%\n */\npackage %projectPackageName%.%packageSuffix%;\nimport %projectPackageName%.image.*;\nimport %projectPackageName%.runtime.*;\nimport %projectPackageName%.java.*;\nimport %projectPackageName%.java.sov.*;\nimport %projectPackageName%.sov.*;\nimport %projectPackageName%.sov.data.*;\nimport %projectPackageName%.sov.image.*;\nimport %projectPackageName%.sov.java.*;\nimport java.util.*;\n\n//docs\n// EffigyGenerator Template Code : impht\npublic %classOrAbstract% %effigyClassName%\n    extends %superClass%\n    implements %projectPackageName%.%category%.%interfaceName% {\n\n";
    static final String javaObjectImplementationHeaderTemplate = "// EffigyGenerator Template Code : ict\n\n\n/*\n * ===========================================================================\n * IBM Confidential.\n * OCO Source Materials \n * IBM SDK, Java(tm) 2 Technology Edition, v1.4.2 \n * (C) Copyright IBM Corp. 2005.\n * The source code for this program is not published or otherwise divested of\n * its trade secrets, irrespective of what has been deposited with the U.S.\n * Copyright office.\n * ===========================================================================\n */\n\n/**\n * This file is auto-generated. DO NOT modify.\n * Updates should be made to %xmlIn%\n */\npackage %projectPackageName%.%packageSuffix%;\nimport %projectPackageName%.image.*;\nimport %projectPackageName%.runtime.*;\nimport %projectPackageName%.java.*;\nimport %projectPackageName%.java.sov.*;\nimport %projectPackageName%.sov.*;\nimport %projectPackageName%.sov.data.*;\nimport %projectPackageName%.sov.image.*;\nimport %projectPackageName%.sov.java.*;\nimport java.util.*;\n\n//docs\n// EffigyGenerator Template Code : joiht\npublic %classOrAbstract% %effigyClassName%\n    extends %projectPackageName%.sov.imp.JavaObjectEffigy {\n\n";
    static final String dataObjectPlatformConstructorTemplate = "// EffigyGenerator Template Code : dopct\n    public static String MaptoLocator = \"%mapto%\";\n    public %effigyClassName%(\n        DataObject dobj,\n        %projectPackageName%.sov.image.AddressSpaceProxy context) {\n        super( dobj, context );\n    }\n";
    static final String dataObjectWithProxyImplementationConstructorTemplate = "// EffigyGenerator Template Code : dowpict\n    public final static String ProxyClassName = \"%proxyPackageName%.%proxy%\";\n    protected DataObject MyDataObject;\n    public %proxy% myproxy;\n    public %proxyPackageName%.%proxy% getProxy() { return myproxy; }\t// Allow proxy to be stripped from it's effigy\n// EffigyGenerator Template Code : doeah\n\n    public int hashCode() { return MyDataObject.hashCode(); } // Delegate hashing to our DataObject\n    public boolean equals(Object obj) { \n        return (obj instanceof %effigyClassName%) &&  \n               MyDataObject.equals(((%effigyClassName%)obj).MyDataObject);  \n    } // Delegate equality checking to our DataObject\n\n    public %effigyClassName%(\n        DataObject dobj,\n        %projectPackageName%.sov.image.AddressSpaceProxy context) {\n        super( dobj, context);\n        MyDataObject = dobj;\n        myproxy = \n        (%proxy%) ProxyFactory.getProxy(\"%proxy%\",dobj,context);\n    }\n";
    static final String dataObjectImplementationConstructorTemplate = "// EffigyGenerator Template Code : doict\n    protected DataObject MyDataObject;\n\n    public %effigyClassName%(\n        DataObject dobj,\n        %projectPackageName%.sov.image.AddressSpaceProxy context) {\n        super( dobj, context); \n        MyDataObject = dobj;    }\n// EffigyGenerator Template Code : doeah\n\n    public int hashCode() { return MyDataObject.hashCode(); } // Delegate hashing to our DataObject\n    public boolean equals(Object obj) { \n        return (obj instanceof %effigyClassName%) &&  \n               MyDataObject.equals(((%effigyClassName%)obj).MyDataObject);  \n    } // Delegate equality checking to our DataObject\n";
    static final String proxyImplementationConstructorTemplate = "// EffigyGenerator Template Code : pict\n    public final static String ProxyClassName = \"%proxyPackageName%.%proxy%\";\n    protected %proxyPackageName%.%proxy% myproxy;    // this Effigy maps directly to another class\n    public %proxyPackageName%.%proxy% getProxy() { return myproxy; }\t// Allow proxy to be stripped from it's effigy\n\n    public %effigyClassName%(\n        %proxyPackageName%.%proxy% proxy,\n        %projectPackageName%.sov.image.AddressSpaceProxy context) {\n        super(%proxyOrContext%);\n        this.myproxy = proxy;\n        if( proxy == null ) {\n            throw new java.lang.NullPointerException(\n                \"%effigyClassName% Constructor: proxy is null.\");\n        }\n    }\n\n// EffigyGenerator Template Code : peah\n    public int hashCode() { return myproxy.hashCode(); } // Delegate hashing to our proxy\n    public boolean equals(Object obj) { return myproxy.equals(obj); } // Delegate equality checking to our proxy\n\n    protected StructuredDataLocator MyDataLocator = null;\n";
    static final String proxyPlatformConstructorTemplate = "// EffigyGenerator Template Code : ppct\n    public %effigyClassName%(\n        %proxyPackageName%.%proxy% proxy,\n        %projectPackageName%.sov.image.AddressSpaceProxy context) {\n        super( proxy, context );\n    }\n";
    static final String javaObjectImplementationConstructorTemplate = "// EffigyGenerator Template Code : joict\n\n    public %effigyClassName%(\n        %proxyPackageName%.HeapObjectProxy proxy,\n        %projectPackageName%.sov.image.AddressSpaceProxy context) {\n        super(proxy,context);\n    }\n";
    static final String javaObjectPlatformConstructorTemplate = "// EffigyGenerator Template Code : jopct\n    public %effigyClassName%(\n        %proxyPackageName%.HeapObjectProxy proxy,\n        %projectPackageName%.sov.image.AddressSpaceProxy context) {\n        super( proxy, context );\n    }\n";
    static final String methodCloseTemplate = "// EffigyGenerator Template Code : mct\n        return my#%varName%;\n    }\n";
    static final String iteratorMethodCloseTemplate = "// EffigyGenerator Template Code : imct\n        return my#%varName%.getIterator();\n    }\n";
    static final String abstractMethodTemplate = "// EffigyGenerator Template Code : amt\n    public abstract %returnType% %methodName%(%parameter%) %exceptions%;\n";
    static final String abstractIteratorMethodTemplate = "// EffigyGenerator Template Code : aimt\n    public Iterator %methodName%() %exceptions%;\n";
    static final String abstractEffigyMethodTemplate = "// EffigyGenerator Template Code : aemt\n    public %returnType% %methodName%(%parameters%) %exceptions%;\n";
    static final String abstractEffigyMethodWithExceptionTemplate = "// EffigyGenerator Template Code : aemwet\n    public %returnType% %methodName%(%parameters%) %exceptions% \n";
    static final String dummyMethodTemplate = "// EffigyGenerator Template Code : dmt\n    public %returnType% %methodName%(%parameters%) %exceptions% {\n        return null;\n    }\n";
    static final String primitiveDummyMethodTemplate = "// EffigyGenerator Template Code : pdmt\n    public %returnType% %methodName%(%parameters%) %exceptions% {\n        return 0;\n    }\n";
    static final String fieldMethodTemplate = "// EffigyGenerator Template Code : fmt\n    private %returnType% my#%varName% = null;\n    public %returnType% %methodName%() %exceptions% {\n        if( my#%varName% == null ) {\n            my#%varName% =\n                (%returnType%) myproxy.getReader().get#%returnType%(\"%mapto%\");\n        }\n// EffigyGenerator Template Code : mct\n        return my#%varName%;\n    }\n";
    static final String primitiveFieldMethodTemplate = "// EffigyGenerator Template Code : pfmt\n    private %returnType% my#%varName%;\n    private %returnType% isSet#%varName% = false;\n    public %returnType% %methodName%() %exceptions% {\n        if( isSet#%varName% == false ) {\n            my#%varName% =\n                myproxy.getReader().get#%returnType%(\"%mapto%\");\n            isSet#%varName% = true;\n        }\n// EffigyGenerator Template Code : mct\n        return my#%varName%;\n    }\n";
    static final String dummyIteratorMethodTemplate = "// EffigyGenerator Template Code : dimt\n    public Iterator %methodName%(%parameters%){\n        return null;\n    }\n";
    static final String mapToEffigyMethodTemplate = "// EffigyGenerator Template Code : mtemt\n    private %returnType%#Effigy my#%varName% = null;\n    public %returnType% %methodName%() \n        %exceptions% {\n        if( my#%varName% == null ) {\n            my#%varName% =\n                (%returnType%#Effigy) Effigy.create(\n                    \"%returnType%#Effigy\",\n                     getDataObject(),\n                     context,\n                     \"%mapto%\",\n                     context.getPlatformName());\n        }\n// EffigyGenerator Template Code : mct\n        return my#%varName%;\n    }\n";
    static final String proxyEffigyMethodTemplate = "// EffigyGenerator Template Code : pemt\n    private %returnType%#Effigy my#%varName% = null;\n    public %returnType% %methodName%() %exceptions% {\n        if( my#%varName% == null ) {\n            my#%varName% =\n                (%returnType%#Effigy) Effigy.create(\n                    \"%returnType%#Effigy\",\n                     myproxy,\n                     context,\n                     \"%mapto%\",                     context.getPlatformName());\n        }\n// EffigyGenerator Template Code : mct\n        return my#%varName%;\n    }\n";
    static final String proxyMethodMethodTemplate = "// EffigyGenerator Template Code : pmmt\n    private %returnType%#Effigy my#%varName% = null;\n    public %returnType% %methodName%() %exceptions% {\n        if( my#%varName% == null ) {\n            my#%varName% =\n                (%returnType%#Effigy) Effigy.create(\n                    \"%returnType%#Effigy\",\n                     myproxy.%mapto%(),\n                     context,\n                     context.getPlatformName());\n        }\n// EffigyGenerator Template Code : mct\n        return my#%varName%;\n    }\n";
    static final String argsProxyMethodMethodTemplate = "// EffigyGenerator Template Code : apmmt\n    public %returnType% %methodName%(%parameters%) %exceptions% {\n        %returnType%   my#%varName% =\n                (%returnType%#Effigy) Effigy.create(\n                    \"%returnType%#Effigy\",\n                     myproxy.%mapto%(%proxyparameters%),\n                     context,\n                     context.getPlatformName());\n// EffigyGenerator Template Code : mct\n        return my#%varName%;\n    }\n";
    static final String tableIteratorMethodTemplate = "// EffigyGenerator Template Code : timt\n    private EffigyIterator my#%varName% = null;\n    public java.util.Iterator %methodName%() %exceptions% {\n        if( my#%varName% == null ) {\n            String fullEffigyName = \n                \"%projectPackageName%.api.imp.\"\n                + context.getPlatformName()\n                + \".%returnType%#Effigy\";\n            my#%varName% = new EffigyTableIterator(\n            this,\n            fullEffigyName,\n            context,\n            \"%mapto%\",\n            \"%countMapto%\",\n            %indirection%,\n            %ptrSize%);\n        }\n// EffigyGenerator Template Code : imct\n        return my#%varName%.getIterator();\n    }\n";
    static final String listIteratorMethodTemplate = "// EffigyGenerator Template Code : limt\n    private EffigyIterator my#%varName% = null;\n    public java.util.Iterator %methodName%() %exceptions% {\n        if( my#%varName% == null ) {\n            String fullEffigyName = \n                \"%projectPackageName%.sov.imp.\"\n                + context.getPlatformName()\n                + \".%returnType%#Effigy\";\n            my#%varName% = new EffigyListIterator(\n            this,\n            fullEffigyName,\n            context,\n            \"%mapto%\",\n             \"%nextMapto%\");\n        }\n// EffigyGenerator Template Code : imct\n        return my#%varName%.getIterator();\n    }\n";
    static final String maptoMethodTemplate = "// EffigyGenerator Template Code : mtmt\n    private %returnType% my#%varName% = null;\n    public %returnType% %methodName%() %exceptions% {\n        if( my#%varName% == null ) {\n            my#%varName% = MyDataObject.getReader().get#%returnType%(\n                \"%mapto%\");\n        }\n// EffigyGenerator Template Code : mct\n        return my#%varName%;\n    }\n";
    static final String primitiveMaptoMethodTemplate = "// EffigyGenerator Template Code : pmtmt\n    private %returnType% my#%varName%;\n    private boolean isSet#%varName% = false;\n    public %returnType% %methodName%() %exceptions% {\n        if( isSet#%varName% == false ) {\n            my#%varName% = MyDataObject.getReader().get#%returnType%(\n                \"%mapto%\");\n            isSet#%varName% = true;\n        }\n// EffigyGenerator Template Code : mct\n        return my#%varName%;\n    }\n";
    static final String dataLocatorMethodTemplate = "// EffigyGenerator Template Code : dlmt\n    private %returnType% my#%varName%  = null;\n    public %returnType% %methodName%() %exceptions% {\n        if( MyDataLocator == null ) {\n            MyDataLocator = new DataLocator( myproxy, context );\n        }\n        if( my#%varName% == null ) {\n            my#%varName% = MyDataLocator.get#%returnType%(\"%mapto%\");\n        }\n// EffigyGenerator Template Code : mct\n        return my#%varName%;\n    }\n";
    static final String primitiveDataLocatorMethodTemplate = "// EffigyGenerator Template Code : pdlmt\n    private %returnType% isSet#%varName% = false;\n    private %returnType% my#%varName%;\n    public %returnType% %methodName%() %exceptions% {\n        if( MyDataLocator == null ) {\n            MyDataLocator = new DataLocator( myproxy, context );\n        }\n        if( isSet#%varName% == false ) {\n            my#%varName% = MyDataLocator.get#%returnType%(\"%mapto%\");\n            isSet#%varName% = true;\n        }\n// EffigyGenerator Template Code : mct\n        return my#%varName%;\n    }\n";
    static final String primitiveProxyMethodTemplate = "// EffigyGenerator Template Code : ppmt\n    private %returnType% my#%varName%;\n    private boolean isSet#%varName% = false;\n    public %returnType% %methodName%() %exceptions% {\n        if( isSet#%varName% == false ) {\n            my#%varName% = myproxy.%mapto%();\n            isSet#%varName% = true;\n        }\n// EffigyGenerator Template Code : mct\n        return my#%varName%;\n    }\n";
    static final String argsPrimitiveProxyMethodTemplate = "// EffigyGenerator Template Code : appmt\n    public %returnType% %methodName%(%parameters%) %exceptions% {\n        %returnType%    my#%varName% = myproxy.%mapto%(%proxyparameters%);\n// EffigyGenerator Template Code : mct\n        return my#%varName%;\n    }\n";
    static final String proxyMethodTemplate = "// EffigyGenerator Template Code : pmt\n    private %returnType% my#%varName% = null;\n    public %returnType% %methodName%() %exceptions% {\n        if( my#%varName% == null ) {\n                my#%varName% = (%returnType%) myproxy.%mapto%();\n        }\n// EffigyGenerator Template Code : mct\n        return my#%varName%;\n    }\n";
    static final String uncachedProxyMethodTemplate = "// EffigyGenerator Template Code : upmt\n    public %returnType% %methodName%() %exceptions% {\n           %returnType% my#%varName% = (%returnType%) myproxy.%mapto%();\n// EffigyGenerator Template Code : mct\n        return my#%varName%;\n    }\n";
    static final String argsProxyMethodTemplate = "// EffigyGenerator Template Code : apmt\n    public %returnType% %methodName%(%parameters%) %exceptions% {\n        %returnType% my#%varName% = (%returnType%) myproxy.%mapto%(%proxyparameters%);\n// EffigyGenerator Template Code : mct\n        return my#%varName%;\n    }\n";
    static final String voidArgsProxyMethodTemplate = "// EffigyGenerator Template Code : vapmt\n    public void %methodName%(%parameters%) %exceptions% {\n        myproxy.%mapto%(%proxyparameters%);\n    }\n";
    static final String proxyIteratorMethodTemplate = "// EffigyGenerator Template Code : pimt\n    public java.util.Iterator %methodName%() %exceptions% {\n        String platform = %platformNameGet%;\n        return new EffigyProxyIterator( \n            \"%returnType%#Effigy\",\n            myproxy.%mapto%(),\n            context,\n            platform );\n    }\n";
    private static final String[] attrAttributes;
    static final String primitiveTypes = "byte int long short char boolean float double ";
    private static String[] effigyAttributes;

    public static void main(String[] stringArray) {
        if (stringArray.length != 2) {
            EffigyGenerator.printUsageAndExit(null);
        }
        xmlIn = stringArray[0];
        sourceDir = stringArray[1];
        EffigyGenerator effigyGenerator = new EffigyGenerator();
        projectPackageName = effigyGenerator.getClass().getPackage().getName();
        projectPackageName = projectPackageName.substring(0, projectPackageName.lastIndexOf(46));
        projectPackagePath = projectPackageName.replace('.', '/');
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        FirstPassHandler firstPassHandler = effigyGenerator.new FirstPassHandler();
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(new File(xmlIn), (DefaultHandler)firstPassHandler);
            platformList = firstPassHandler.getPlatformList();
            EffigyGenerator.checkSourceDir(sourceDir + "/" + projectPackagePath + "/sov/imp/");
            Iterator iterator = platformList.iterator();
            while (iterator.hasNext()) {
                EffigyGenerator.checkSourceDir(sourceDir + "/" + projectPackagePath + "/sov/imp/" + (String)iterator.next() + "/");
            }
            sAXParser.parse(new File(xmlIn), (DefaultHandler)effigyGenerator);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private static void checkSourceDir(String string) {
        File file = new File(string);
        if (file.exists()) {
            if (!file.isDirectory()) {
                EffigyGenerator.printUsageAndExit("<sources directory> must be a directory");
            }
        } else {
            file.mkdirs();
        }
    }

    private static void printUsageAndExit(String string) {
        if (string != null) {
            System.err.println(string);
        }
        System.err.println("Usage: java EffigyGenerator <effigynativemap.xml> <sources directory>");
        System.exit(1);
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4 = string2;
        if (string4.length() == 0) {
            string4 = string3;
        }
        if (string4.equals("Effigy")) {
            this.startEffigy(attributes);
        } else if (string4.equals("Attr")) {
            this.startAttribute(attributes);
        } else if (string4.equals("Javadoc")) {
            this.javaDocElement = true;
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        super.characters(cArray, n, n2);
        if (this.javaDocElement) {
            this.javadoc.append(new String(cArray, n, n2));
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        String string4 = string2;
        if (string4.length() == 0) {
            string4 = string3;
        }
        if (string4.equals("Effigy")) {
            if (this.currentEffigy == null) {
                throw new SAXException("</Effigy> encountered but Effigy stack is empty");
            }
            String string5 = this.currentEffigy.className;
            StringBuffer stringBuffer = this.currentEffigy.implementationContent;
            String string6 = sourceDir + "/" + projectPackagePath + "/sov/imp/" + string5 + ".java";
            this.postProcessAndWrite(stringBuffer, string6);
            Iterator iterator = this.currentEffigy.platformContentBuffers.keySet().iterator();
            while (iterator.hasNext()) {
                String string7 = (String)iterator.next();
                StringBuffer stringBuffer2 = (StringBuffer)this.currentEffigy.platformContentBuffers.get(string7);
                String string8 = sourceDir + "/" + projectPackagePath + "/sov/imp/" + string7 + "/" + string5 + ".java";
                this.postProcessAndWrite(stringBuffer2, string8);
            }
            this.javadoc = new StringBuffer();
            this.currentEffigy = null;
        } else if (!string4.equals("Attr") && string4.equals("Javadoc")) {
            this.javaDocElement = false;
        }
    }

    private void postProcessAndWrite(StringBuffer stringBuffer, String string) throws SAXException {
        stringBuffer.append("}\n");
        StringBuffer stringBuffer2 = new StringBuffer(stringBuffer.substring(0, stringBuffer.indexOf("//docs")));
        stringBuffer2.append("\n/**");
        stringBuffer2.append(this.javadoc.toString());
        stringBuffer2.append("\n*/");
        stringBuffer2.append(stringBuffer.substring(stringBuffer.indexOf("//docs") + 6));
        this.writeFile(string, stringBuffer2.toString());
    }

    private void startEffigy(Attributes attributes) throws SAXException {
        String string;
        String string2;
        Iterator iterator;
        String[] stringArray = null;
        String string3 = null;
        boolean bl = false;
        if (this.currentEffigy != null) {
            throw new SAXException("Cannot define an Effigy inside another Effigy: " + this.currentEffigy.className);
        }
        this.currentEffigy = new EffigyDescriptor();
        this.currentEffigy.implementationContent = new StringBuffer();
        if (attributes != null) {
            stringArray = this.getAttrValues(attributes, effigyAttributes);
            this.currentEffigy.name = stringArray[0];
            if (this.currentEffigy.name == null || this.currentEffigy.name.length() == 0) {
                throw new SAXException("Missing 'name' attribute in Effigy tag within " + xmlIn);
            }
            this.currentEffigy.className = this.currentEffigy.name + "Effigy";
            if (stringArray[1] != null && stringArray[1].length() != 0) {
                string3 = stringArray[1];
            }
            if (stringArray[2] != null && stringArray[2].length() != 0) {
                this.currentEffigy.proxy = stringArray[2];
            }
            if (stringArray[3] != null && stringArray[3].length() != 0) {
                this.currentEffigy.category = stringArray[3];
            }
            if (stringArray[4] != null && stringArray[4].length() != 0) {
                bl = true;
            }
            if (string3 == null && this.currentEffigy.proxy == null && !bl) {
                throw new SAXException("Missing or empty 'mapto', 'className' or 'proxy' attribute in Effigy tag " + this.currentEffigy.name);
            }
        }
        if (string3 != null && string3.length() > 0) {
            this.currentEffigy.platformMapTos = new HashMap(platformList.size());
            if (string3.indexOf(",") != -1) {
                iterator = new StringTokenizer(string3, ",:");
                while (((StringTokenizer)((Object)iterator)).hasMoreTokens()) {
                    string2 = ((StringTokenizer)((Object)iterator)).nextToken();
                    string = ((StringTokenizer)((Object)iterator)).nextToken();
                    this.currentEffigy.platformMapTos.put(string2, string);
                }
            } else {
                iterator = platformList.iterator();
                while (iterator.hasNext()) {
                    string2 = (String)iterator.next();
                    this.currentEffigy.platformMapTos.put(string2, string3);
                }
            }
        }
        this.currentEffigy.platformContentBuffers = new HashMap(platformList.size());
        iterator = platformList.iterator();
        while (iterator.hasNext()) {
            this.currentEffigy.platformContentBuffers.put(iterator.next(), new StringBuffer());
        }
        string2 = projectPackageName + "." + "sov" + "." + this.currentEffigy.category;
        substitutionList.put("%effigyName%", this.currentEffigy.name);
        substitutionList.put("%effigyClassName%", this.currentEffigy.className);
        substitutionList.put("%proxyPackageName%", string2);
        substitutionList.put("%proxy%", this.currentEffigy.proxy);
        substitutionList.put("%category%", this.currentEffigy.category);
        substitutionList.put("%projectPackageName%", projectPackageName);
        if (stringArray[5] != null) {
            substitutionList.put("%interfaceName%", stringArray[5]);
        } else {
            substitutionList.put("%interfaceName%", this.currentEffigy.name);
        }
        if (this.currentEffigy.name.equals("Image")) {
            substitutionList.put("%platformNameGet%", "myproxy.getSystemType().toLowerCase()");
        } else {
            substitutionList.put("%platformNameGet%", "context.getPlatformName()");
        }
        substitutionList.put("%xmlIn%", xmlIn);
        substitutionList.put("%packageSuffix%", "sov.imp");
        if (bl) {
            substitutionList.put("%superClass%", "JavaObjectEffigy");
        } else {
            substitutionList.put("%superClass%", "Effigy");
        }
        substitutionList.put("%classOrAbstract%", "abstract class");
        if (bl) {
            EffigyGenerator.appendTemplateToBuffer(this.currentEffigy.implementationContent, javaObjectImplementationHeaderTemplate, substitutionList);
        } else {
            EffigyGenerator.appendTemplateToBuffer(this.currentEffigy.implementationContent, implementationHeaderTemplate, substitutionList);
        }
        iterator = platformList.iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            substitutionList.put("%packageSuffix%", "sov.imp." + string);
            substitutionList.put("%superClass%", "com.ibm.dtfj.sov.imp." + this.currentEffigy.className);
            substitutionList.put("%classOrAbstract%", "class");
            EffigyGenerator.appendTemplateToBuffer((StringBuffer)this.currentEffigy.platformContentBuffers.get(string), implementationHeaderTemplate, substitutionList);
        }
        if (bl) {
            EffigyGenerator.appendTemplateToBuffer(this.currentEffigy.implementationContent, javaObjectImplementationConstructorTemplate, substitutionList);
            iterator = platformList.iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                EffigyGenerator.appendTemplateToBuffer((StringBuffer)this.currentEffigy.platformContentBuffers.get(string), javaObjectPlatformConstructorTemplate, substitutionList);
            }
        } else if (string3 == null) {
            if (this.currentEffigy.proxy.equals("AddressSpaceProxy")) {
                substitutionList.put("%proxyOrContext%", "proxy");
            } else {
                substitutionList.put("%proxyOrContext%", "context");
            }
            EffigyGenerator.appendTemplateToBuffer(this.currentEffigy.implementationContent, proxyImplementationConstructorTemplate, substitutionList);
            iterator = platformList.iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                EffigyGenerator.appendTemplateToBuffer((StringBuffer)this.currentEffigy.platformContentBuffers.get(string), proxyPlatformConstructorTemplate, substitutionList);
            }
        } else {
            EffigyGenerator.appendTemplateToBuffer(this.currentEffigy.implementationContent, this.currentEffigy.proxy == null ? dataObjectImplementationConstructorTemplate : dataObjectWithProxyImplementationConstructorTemplate, substitutionList);
            iterator = platformList.iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                substitutionList.put("%mapto%", this.currentEffigy.platformMapTos.get(string));
                EffigyGenerator.appendTemplateToBuffer((StringBuffer)this.currentEffigy.platformContentBuffers.get(string), dataObjectPlatformConstructorTemplate, substitutionList);
            }
        }
    }

    private void startAttribute(Attributes attributes) throws SAXException {
        Object object;
        Object object2;
        Object object3;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = true;
        String[] stringArray = null;
        String string6 = null;
        HashSet<String> hashSet = new HashSet<String>(platformList.size());
        String string7 = "";
        String string8 = "";
        if (this.currentEffigy == null) {
            throw new SAXException("Attr tag must be inside an Effigy tag");
        }
        StringBuffer stringBuffer = this.currentEffigy.implementationContent;
        HashMap hashMap = new HashMap(platformList.size());
        if (attributes != null) {
            stringArray = this.getAttrValues(attributes, attrAttributes);
            string3 = stringArray[0];
            string = stringArray[1];
            string4 = this.quoteQuotes(stringArray[2]);
            string5 = stringArray[3];
            if (stringArray[4] != null) {
                if (stringArray[4].equals("proxy")) {
                    n = 1;
                } else if (stringArray[4].equals("list")) {
                    n = 2;
                } else if (stringArray[4].equals("table")) {
                    n = 3;
                } else {
                    throw new SAXException("Attribute 'iterate' is not valid for " + this.currentEffigy.className + ". It must be 'proxy', 'list' or 'table'.");
                }
            }
            boolean bl5 = bl2 = stringArray[5] != null;
            if (bl2) {
                string4 = stringArray[5];
            }
            boolean bl6 = bl3 = stringArray[12] != null;
            if (bl3) {
                string4 = stringArray[12];
            }
            if (stringArray[13] != null) {
                string7 = stringArray[13];
                string8 = this.removeTypes(stringArray[13]);
            }
            string6 = stringArray[6];
            if (stringArray[11] != null && stringArray[11].length() > 0) {
                object3 = new StringTokenizer(stringArray[11], ",");
                while (((StringTokenizer)object3).hasMoreTokens()) {
                    hashSet.add(((StringTokenizer)object3).nextToken());
                }
            }
        }
        if (this.currentEffigy.proxy == null && bl2) {
            throw new SAXException("Attribute 'method' is not allowed in an Attr tag in non-class and non-proxy Effigy " + this.currentEffigy.className);
        }
        if (string3 == null || string3.length() == 0) {
            throw new SAXException("Missing 'name' attribute in Attr tag in " + this.currentEffigy.className);
        }
        if (string == null || string.length() == 0) {
            throw new SAXException("Missing 'type' attribute in Attr tag in " + this.currentEffigy.className);
        }
        if (string.equalsIgnoreCase("Effigy")) {
            if (string5 == null || string5.length() == 0) {
                throw new SAXException("Missing 'effigy' attribute in Attr tag with type=\"Effigy\" in " + this.currentEffigy.className);
            }
            bl = true;
            string2 = string5;
        } else {
            string2 = string;
        }
        bl4 = this.isPrimitive(string2);
        if (hashSet.size() != 0) {
            object3 = hashSet.iterator();
            while (object3.hasNext()) {
                object2 = object3.next();
                hashMap.put(object2, this.currentEffigy.platformContentBuffers.get(object2));
            }
            if (this.currentEffigy.currentCommonVarName != null && this.currentEffigy.currentCommonVarName.equals(string3)) {
                stringBuffer = null;
            }
        }
        this.currentEffigy.currentCommonVarName = string3;
        if (stringBuffer != null) {
            stringBuffer.append("\n");
        }
        if (hashMap.size() != 0) {
            object3 = hashSet.iterator();
            while (object3.hasNext()) {
                object2 = (StringBuffer)hashMap.get(object3.next());
                ((StringBuffer)object2).append("\n");
            }
        }
        object3 = null;
        object2 = null;
        String string9 = null;
        substitutionList.put("%returnType%", string2);
        substitutionList.put("%varName%", string3);
        substitutionList.put("%mapto%", string4);
        substitutionList.put("%parameters%", string7);
        substitutionList.put("%proxyparameters%", string8);
        if (stringArray[14] == null) {
            substitutionList.put("%methodName%", "get" + string3);
        } else {
            substitutionList.put("%methodName%", stringArray[14]);
        }
        if (stringArray[15] == null) {
            substitutionList.put("%exceptions%", "");
        } else {
            substitutionList.put("%exceptions%", "throws " + stringArray[15]);
        }
        if (string4 == null || string4.length() == 0) {
            if (n != 0) {
                substitutionList.put("%returnType%", "java.util.Iterator");
            } else if (bl) {
                substitutionList.put("%returnType%", "com.ibm.dtfj.sov.imp." + string5);
            }
            object3 = abstractMethodTemplate;
            object2 = bl4 ? primitiveDummyMethodTemplate : dummyMethodTemplate;
            string9 = bl4 ? primitiveDummyMethodTemplate : dummyMethodTemplate;
        } else if (bl3) {
            object3 = abstractMethodTemplate;
            string9 = bl4 ? primitiveDummyMethodTemplate : dummyMethodTemplate;
            object2 = bl4 ? primitiveFieldMethodTemplate : fieldMethodTemplate;
        } else if (!bl) {
            if (string4 == null || string4.length() == 0) {
                throw new SAXException("Missing 'mapto' attribute in Attr tag in " + this.currentEffigy);
            }
            if (bl2) {
                object3 = abstractMethodTemplate;
                String string10 = string9 = bl4 ? primitiveDummyMethodTemplate : dummyMethodTemplate;
                object2 = string7.equals("") ? (string2.equals("Iterator") || string2.equals("java.util.Iterator") ? uncachedProxyMethodTemplate : (bl4 ? primitiveProxyMethodTemplate : proxyMethodTemplate)) : (string2.equals("void") ? voidArgsProxyMethodTemplate : (bl4 ? argsPrimitiveProxyMethodTemplate : argsProxyMethodTemplate));
            } else {
                object3 = abstractMethodTemplate;
                String string11 = string9 = bl4 ? primitiveDummyMethodTemplate : dummyMethodTemplate;
                object2 = this.currentEffigy.platformMapTos == null ? (bl4 ? primitiveDataLocatorMethodTemplate : dataLocatorMethodTemplate) : (bl4 ? primitiveMaptoMethodTemplate : maptoMethodTemplate);
            }
        } else if (n != 0) {
            object3 = abstractIteratorMethodTemplate;
            string9 = dummyIteratorMethodTemplate;
            if (n == 1) {
                object2 = proxyIteratorMethodTemplate;
            } else if (n == 2) {
                object = stringArray[7] != null ? stringArray[7] : "null";
                substitutionList.put("%nextMapto%", object);
                object2 = listIteratorMethodTemplate;
            } else {
                object = stringArray[8];
                if (object == null || ((String)object).length() == 0) {
                    throw new SAXException("Missing or invalid 'countmapto' attribute in Attr tag in " + this.currentEffigy.className);
                }
                long l = 0L;
                long l2 = 0L;
                String string12 = stringArray[9];
                if (string12 != null && string12.length() != 0) {
                    try {
                        l2 = Long.parseLong(string12);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new SAXException("Invalid 'indirection' attribute in Attr tag in " + this.currentEffigy.className);
                    }
                }
                if (l2 > 0L) {
                    try {
                        l = Long.parseLong(stringArray[10]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new SAXException("Missing or invalid 'ptrsize' attribute in Attr tag in " + this.currentEffigy.className);
                    }
                }
                substitutionList.put("%ptrSize%", Long.toString(l));
                substitutionList.put("%indirection%", Long.toString(l2));
                substitutionList.put("%countMapto%", object);
                object2 = tableIteratorMethodTemplate;
            }
        } else {
            object3 = abstractEffigyMethodWithExceptionTemplate;
            String string13 = string9 = bl4 ? primitiveDummyMethodTemplate : dummyMethodTemplate;
            object2 = bl2 && string2 == "void" ? voidArgsProxyMethodTemplate : (bl2 && string7.equals("") ? (bl4 ? primitiveProxyMethodTemplate : proxyMethodMethodTemplate) : (bl2 && !string7.equals("") ? argsProxyMethodMethodTemplate : (this.currentEffigy.platformMapTos == null ? proxyEffigyMethodTemplate : mapToEffigyMethodTemplate)));
        }
        if (hashMap.size() == 0) {
            EffigyGenerator.appendTemplateToBuffer(stringBuffer, (String)object2, substitutionList);
        } else {
            EffigyGenerator.appendTemplateToBuffer(stringBuffer, string9, substitutionList);
            object = hashSet.iterator();
            while (object.hasNext()) {
                Object e = object.next();
                StringBuffer stringBuffer2 = (StringBuffer)this.currentEffigy.platformContentBuffers.get(e);
                EffigyGenerator.appendTemplateToBuffer(stringBuffer2, (String)object2, substitutionList);
            }
        }
    }

    private String quoteQuotes(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() + 8);
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] != '\"') {
                stringBuffer.append(cArray[i]);
                continue;
            }
            stringBuffer.append("\\");
            stringBuffer.append(cArray[i]);
        }
        return stringBuffer.toString();
    }

    private String[] getAttrValues(Attributes attributes, String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        block0: for (int i = 0; i < attributes.getLength(); ++i) {
            String string = attributes.getValue(i);
            String string2 = attributes.getLocalName(i);
            if (string2.length() == 0) {
                string2 = attributes.getQName(i);
            }
            for (int j = 0; j < stringArray.length; ++j) {
                if (!stringArray[j].equals(string2)) continue;
                stringArray2[j] = string;
                continue block0;
            }
        }
        return stringArray2;
    }

    private void writeFile(String string, String string2) throws SAXException {
        try {
            File file = new File(string);
            if (file.exists()) {
                file.delete();
            }
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(string2);
            fileWriter.flush();
            fileWriter.close();
        }
        catch (IOException iOException) {
            throw new SAXException("IOException (file:" + string + ")", iOException);
        }
    }

    private boolean isPrimitive(String string) {
        if (string == null) {
            return false;
        }
        return primitiveTypes.indexOf(string) >= 0;
    }

    private String removeTypes(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r\f,", true);
        StringBuffer stringBuffer = new StringBuffer(string.length());
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals(" ") || string2.equals("\t") || string2.equals("\n") || string2.equals("\r")) continue;
            if (string2.equals(",")) {
                if (!bl) continue;
                stringBuffer.append(", ");
                bl = false;
                continue;
            }
            if (!bl) {
                bl = true;
                continue;
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    private static void appendTemplateToBuffer(StringBuffer stringBuffer, String string, HashMap hashMap) {
        if (stringBuffer == null) {
            return;
        }
        if (string == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n,.;:\"'(){}[]#", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("#")) continue;
            String string3 = (String)hashMap.get(string2);
            if (string3 != null) {
                stringBuffer.append(string3);
                continue;
            }
            stringBuffer.append(string2);
        }
    }

    static {
        substitutionList = new HashMap();
        attrAttributes = new String[]{"name", "type", "mapto", "effigy", "iterate", "method", "methodtype", "nextmapto", "countmapto", "indirection", "ptrsize", "platform", "field", "parameters", "methodName", "exceptions"};
        effigyAttributes = new String[]{"name", "mapto", "proxy", "category", "className", "interface"};
    }

    class FirstPassHandler
    extends DefaultHandler {
        HashSet fphPlatformList = new HashSet();

        FirstPassHandler() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            String[] stringArray;
            String string4 = string2;
            if (string4.length() == 0) {
                string4 = string3;
            }
            if (string4.equals("Attr") && (stringArray = EffigyGenerator.this.getAttrValues(attributes, attrAttributes))[11] != null && stringArray[11].length() > 0) {
                StringTokenizer stringTokenizer = new StringTokenizer(stringArray[11], ",");
                while (stringTokenizer.hasMoreTokens()) {
                    this.fphPlatformList.add(stringTokenizer.nextToken());
                }
            }
        }

        HashSet getPlatformList() {
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add("linux");
            hashSet.add("zos");
            hashSet.add("aix");
            hashSet.add("windows");
            return hashSet;
        }
    }
}

