/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.sov;

import com.ibm.dtfj.sov.Effigy;
import com.ibm.dtfj.sov.EffigyIteratorConstants;
import com.ibm.dtfj.sov.image.AddressSpaceProxy;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class EffigyIterator
implements Iterator,
EffigyIteratorConstants {
    Effigy owner;
    String effigyClassName;
    int nextIndex;
    Object previousEffigy;
    boolean done;
    AddressSpaceProxy context;

    public EffigyIterator(Effigy owner, String effigyName, AddressSpaceProxy context) {
        if (owner == null) {
            throw new NullPointerException("EffigyIterator Constructor: owner is null");
        }
        if (effigyName == null) {
            throw new NullPointerException("EffigyIterator Constructor: effigy name is null");
        }
        if (context == null) {
            throw new NullPointerException("EffigyIterator Constructor: context is null");
        }
        this.owner = owner;
        this.effigyClassName = effigyName;
        this.nextIndex = 0;
        this.previousEffigy = null;
        this.done = false;
        this.context = context;
    }

    EffigyIterator(EffigyIterator parent) {
        this.owner = parent.owner;
        this.effigyClassName = parent.effigyClassName;
        this.nextIndex = 0;
        this.previousEffigy = null;
        this.done = false;
        this.context = parent.context;
    }

    public abstract EffigyIterator getIterator();

    public boolean hasNext() {
        if (this.done) {
            return false;
        }
        Object obj = null;
        try {
            obj = this.getOrCreateNext();
        }
        catch (InstantiationException e) {
            return false;
        }
        return obj != null;
    }

    public Object next() {
        if (this.done) {
            throw new NoSuchElementException("Attempt to exceed object set size.");
        }
        Object effigy = null;
        try {
            effigy = this.getOrCreateNext();
        }
        catch (InstantiationException e) {
            throw new NoSuchElementException("Attempt to instantiate object failed " + e);
        }
        if (effigy == null) {
            throw new NoSuchElementException("Attempt to exceed object set size.");
        }
        this.previousEffigy = effigy;
        ++this.nextIndex;
        return effigy;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    Object getOrCreateNext() throws InstantiationException {
        Object effigy = null;
        effigy = this.createNext();
        if (effigy == null) {
            return null;
        }
        return effigy;
    }

    abstract Object createNext() throws InstantiationException;
}

