/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.sov;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.sov.Effigy;
import com.ibm.dtfj.sov.image.AddressSpaceProxy;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.Vector;

public class EffigyProxyIterator
implements Iterator {
    private String effigyClassName;
    private Iterator proxy;
    private AddressSpaceProxy context;
    private static String packageNameDot = null;
    private Class eclass;
    private Field field;
    private String proxyClassName = null;
    private String mapTo = null;
    private String platform = null;
    private boolean isObject;

    private void setPackageName() {
        if (packageNameDot == null) {
            packageNameDot = this.getClass().getPackage().getName();
            packageNameDot = packageNameDot.substring(0, packageNameDot.lastIndexOf(46) + 1);
        }
    }

    public EffigyProxyIterator(String effigyClass, Iterator proxy, AddressSpaceProxy context, String platform) {
        if (effigyClass == null) {
            throw new NullPointerException("EffigyProxyIterator Constructor: effigyClass is null.");
        }
        if (proxy == null) {
            throw new NullPointerException("EffigyProxyIterator Constructor: proxy is null.");
        }
        this.setPackageName();
        this.proxy = proxy;
        this.context = context;
        this.platform = platform;
        this.effigyClassName = packageNameDot + "sov.imp." + platform + "." + effigyClass;
        this.isObject = effigyClass.equals("JavaObjectEffigy");
        try {
            this.eclass = Class.forName(this.effigyClassName);
            try {
                this.field = this.eclass.getField("ProxyClassName");
                this.proxyClassName = (String)this.field.get(null);
            }
            catch (SecurityException e) {
                proxy = this.badProxy(e);
            }
            catch (NoSuchFieldException e) {
                this.field = null;
            }
            catch (IllegalArgumentException e) {
                proxy = this.badProxy(e);
            }
            catch (IllegalAccessException e) {
                proxy = this.badProxy(e);
            }
            try {
                this.field = this.eclass.getField("MaptoLocator");
                this.mapTo = (String)this.field.get(null);
            }
            catch (SecurityException e) {
                proxy = this.badProxy(e);
            }
            catch (NoSuchFieldException e) {
                this.mapTo = null;
            }
            catch (IllegalArgumentException e) {
                proxy = this.badProxy(e);
            }
            catch (IllegalAccessException e) {
                proxy = this.badProxy(e);
            }
        }
        catch (ClassNotFoundException e) {
            proxy = this.badProxy(e);
        }
    }

    Iterator badProxy(Exception e) {
        Vector<String> badProxy = new Vector<String>();
        badProxy.add(e.getMessage());
        return badProxy.iterator();
    }

    public boolean hasNext() {
        return this.proxy.hasNext();
    }

    public Object next() {
        try {
            Object nextObj = this.proxy.next();
            if (nextObj instanceof CorruptData) {
                return nextObj;
            }
            if (this.mapTo == null) {
                return Effigy.create(this.effigyClassName, nextObj, this.context, this.platform);
            }
            return Effigy.create(this.effigyClassName, (Long)nextObj, this.context, this.platform);
        }
        catch (CorruptDataException e) {
            return e.getCorruptData();
        }
    }

    public void remove() {
        this.proxy.remove();
    }
}

