/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.sov.data;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.sov.data.DataObject;
import com.ibm.dtfj.sov.data.DescriptorMember;
import com.ibm.dtfj.sov.data.StructUnionDescriptor;
import com.ibm.dtfj.sov.data.StructuredDataLocator;
import com.ibm.dtfj.sov.data.StructuredObjectDescriptor;
import com.ibm.dtfj.sov.image.AddressSpaceProxy;
import com.ibm.dtfj.sov.image.CorruptDataImpl;
import java.lang.reflect.Method;
import java.util.StringTokenizer;

public class DataLocator
implements StructuredDataLocator {
    static final int STATE_BEGIN = 0;
    static final int STATE_CAST = 1;
    static final int STATE_NAME = 2;
    static final int STATE_METHOD = 3;
    static final int STATE_POINTER = 4;
    static final int STATE_END = 5;
    String type = null;
    StructuredObjectDescriptor descriptor = null;
    long Address = 0L;
    DescriptorMember member = null;
    AddressSpaceProxy context = null;
    Object owner = null;
    String mapto = null;
    boolean atPrimitive = false;
    boolean atConstant = false;
    long constantLong = 0L;
    String constantString = null;
    StringBuffer parseTrace = null;
    int entryNum = 0;

    public DataLocator(Object owner, AddressSpaceProxy context) {
        this.owner = owner;
        this.context = context;
        if (context == null) {
            throw new NullPointerException("DataLocator Constructor: AddressSpace context is null.");
        }
    }

    public void setOwner(Object newOwner) {
        this.owner = newOwner;
    }

    public void parse(String maptoList) throws CorruptDataException {
        StringTokenizer maptoSplitter = new StringTokenizer(maptoList, "|");
        while (maptoSplitter.hasMoreTokens()) {
            try {
                if (!this.parseMapto(maptoSplitter.nextToken())) continue;
                return;
            }
            catch (CorruptDataException corruptDataException) {
            }
        }
        throw new CorruptDataException(new CorruptDataImpl("can't parse \"" + maptoList + "\"" + this.parseTrace));
    }

    private boolean parseMapto(String mapto) throws CorruptDataException {
        char thisChar = '\u0000';
        int state = 0;
        int start = 0;
        String name = null;
        String cast = null;
        boolean isMethod = false;
        int indirection = 0;
        this.mapto = mapto;
        this.type = null;
        this.descriptor = null;
        this.Address = 0L;
        this.member = null;
        this.atPrimitive = false;
        this.atConstant = false;
        this.constantLong = 0L;
        this.constantString = null;
        this.parseTrace = new StringBuffer();
        if (mapto.endsWith("\"") && mapto.startsWith("\"")) {
            this.atConstant = true;
            this.constantString = mapto.substring(1, mapto.length() - 1);
            try {
                this.constantLong = Long.parseLong(this.constantString);
            }
            catch (NumberFormatException n) {
                this.constantLong = 0L;
            }
            return true;
        }
        mapto = mapto + ".";
        int maplen = mapto.length();
        this.entryNum = 1;
        block16: for (int ix = 0; ix < maplen; ++ix) {
            thisChar = mapto.charAt(ix);
            switch (state) {
                case 0: {
                    start = ix;
                    if (thisChar == '(') {
                        state = 1;
                        ++start;
                        continue block16;
                    }
                    if (thisChar == '.') {
                        return false;
                    }
                    state = 2;
                    continue block16;
                }
                case 1: {
                    if (thisChar == ')') {
                        cast = mapto.substring(start, ix);
                        state = 2;
                        start = ix + 1;
                        continue block16;
                    }
                    if (thisChar == '*') {
                        cast = mapto.substring(start, ix);
                        ++indirection;
                        state = 4;
                        continue block16;
                    }
                    if (thisChar != '.') continue block16;
                    return false;
                }
                case 2: {
                    if (thisChar == '(') {
                        if (cast == null) {
                            return false;
                        }
                        name = mapto.substring(start, ix);
                        state = 3;
                        continue block16;
                    }
                    if (thisChar != '.') continue block16;
                    name = mapto.substring(start, ix);
                    if (name.length() == 0) {
                        return false;
                    }
                    try {
                        this.processMemberEntry(name, cast, indirection);
                    }
                    catch (IllegalArgumentException e) {
                        return false;
                    }
                    state = 0;
                    cast = null;
                    name = null;
                    indirection = 0;
                    ++this.entryNum;
                    continue block16;
                }
                case 3: {
                    if (thisChar == ')') {
                        isMethod = true;
                        state = 5;
                        continue block16;
                    }
                    return false;
                }
                case 4: {
                    if (thisChar == ')') {
                        state = 2;
                        start = ix + 1;
                        continue block16;
                    }
                    if (thisChar == '*') {
                        ++indirection;
                        continue block16;
                    }
                    if (thisChar != '.') continue block16;
                    return false;
                }
                case 5: {
                    if (thisChar != '.') {
                        return false;
                    }
                    if (isMethod) {
                        try {
                            this.processMethodEntry(name, cast, indirection);
                        }
                        catch (CorruptDataException e) {
                            return false;
                        }
                    }
                    try {
                        this.processMemberEntry(name, cast, indirection);
                    }
                    catch (CorruptDataException e) {
                        return false;
                    }
                    state = 0;
                    cast = null;
                    name = null;
                    isMethod = false;
                    indirection = 0;
                    ++this.entryNum;
                }
            }
        }
        return state == 0;
    }

    private void processMethodEntry(String name, String cast, int indirection) throws CorruptDataException {
        this.parseTrace.append("(" + (cast == null ? "" : cast) + ")" + (name == null ? "" : name) + " ");
        if (this.atPrimitive) {
            throw new CorruptDataException(new CorruptDataImpl("Cannot reference a member when previous is a primitive type"));
        }
        Method mthd = null;
        try {
            mthd = this.owner.getClass().getMethod(name, new Class[0]);
        }
        catch (Exception e) {
            throw new CorruptDataException(new CorruptDataImpl("Method \"" + name + "\" is not a valid method for the recieved owner proxy:" + this.owner.getClass().getName()));
        }
        try {
            this.Address = (Long)mthd.invoke(this.owner, null);
        }
        catch (Exception e) {
            throw new CorruptDataException(new CorruptDataImpl("Method \"" + name + "\" is not a valid method for the recieved owner proxy:" + this.owner.getClass().getName()));
        }
        this.type = cast;
        this.descriptor = this.context.getDescriptor(this.type);
        if (this.descriptor == null) {
            throw new CorruptDataException(new CorruptDataImpl("Could not find descriptor matching cast"));
        }
        this.parseTrace.append("[0x" + Long.toHexString(this.Address) + "], ");
        while (indirection > 0) {
            try {
                this.Address = this.context.readPointer(this.Address);
                this.parseTrace.append("[" + Long.toHexString(this.Address) + "], ");
            }
            catch (MemoryAccessException ae) {
                throw new CorruptDataException(new CorruptDataImpl("Unable to access address, trace: " + this.parseTrace));
            }
            --indirection;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processMemberEntry(String name, String cast, int indirection) throws CorruptDataException {
        this.parseTrace.append("(" + (cast == null ? "" : cast) + ")" + (name == null ? "" : name) + " ");
        if (this.atPrimitive) {
            throw new CorruptDataException(new CorruptDataImpl("Cannot reference a member when previous is a primitive type"));
        }
        if (this.entryNum == 1) {
            this.descriptor = this.context.getDescriptor(name);
            if (this.descriptor != null) {
                this.type = name;
                if (this.owner == null || !(this.owner instanceof DataObject)) return;
                if (((DataObject)this.owner).getDescriptor().getMember(name) == null) return;
                this.descriptor = null;
            }
            if (this.owner == null) {
                throw new CorruptDataException(new CorruptDataImpl("Could not find descriptor matching entry"));
            }
        }
        if (this.member != null && this.member instanceof StructUnionDescriptor) {
            this.member = ((StructUnionDescriptor)this.member).getMember(name);
        }
        if (this.member == null && this.descriptor != null) {
            this.member = this.descriptor.getMember(name);
        }
        if (this.member == null && this.owner != null && this.owner instanceof DataObject) {
            this.descriptor = ((DataObject)this.owner).getDescriptor();
            this.Address = ((DataObject)this.owner).getAddress();
            this.member = this.descriptor.getMember(name);
        }
        if (this.member == null) {
            throw new CorruptDataException(new CorruptDataImpl("Unable to find matching member named '" + name + "'. Check spelling (this is case-sensitive)."));
        }
        this.descriptor = null;
        this.type = this.member.getType();
        int ptrLevel = this.member.getIndirection();
        if (cast != null) {
            this.type = cast;
            ptrLevel = indirection;
        }
        this.Address += (long)this.member.getByteOffset();
        this.parseTrace.append("[0x" + Long.toHexString(this.Address) + "], ");
        while (ptrLevel > 0) {
            try {
                this.Address = this.context.readPointer(this.Address);
                this.parseTrace.append("[" + Long.toHexString(this.Address) + "], ");
            }
            catch (MemoryAccessException ae) {
                throw new CorruptDataException(new CorruptDataImpl(ae.getPointer(), "Unable to access address 0x" + Long.toHexString(this.Address) + " for member '" + this.member.getName()));
            }
            --ptrLevel;
        }
        if (this.type.equals("Union") || this.type.equals("Structure")) return;
        this.descriptor = this.context.getDescriptor(this.type);
        if (this.descriptor == null) {
            this.atPrimitive = true;
            return;
        } else {
            this.member = null;
        }
    }

    public Long getPointerAt(long address) {
        try {
            return new Long(this.context.readPointer(address));
        }
        catch (MemoryAccessException e) {
            return new Long(0L);
        }
    }

    public StructuredObjectDescriptor getDescriptor() {
        return this.descriptor;
    }

    public long getAddress() {
        return this.Address;
    }

    public DescriptorMember getMember() {
        return this.member;
    }

    public String getString(String mapto) throws CorruptDataException, MemoryAccessException {
        this.parse(mapto);
        if (this.atConstant) {
            return this.constantString;
        }
        char[] c = null;
        if (!this.type.equals("HArrayOfChar")) {
            return this.getCString();
        }
        c = this.context.readCharArray(this.Address);
        return new String(c);
    }

    public Long getLong(String mapto) throws CorruptDataException {
        this.parse(mapto);
        if (this.atConstant) {
            return new Long(this.constantLong);
        }
        return this.readPrimitiveValue(this.Address, this.member.getByteSize());
    }

    public Integer getInteger(String mapto) throws CorruptDataException {
        return new Integer(this.getLong(mapto).intValue());
    }

    public Character getChar(String mapto) throws CorruptDataException {
        return new Character((char)this.getLong(mapto).byteValue());
    }

    public Byte getByte(String mapto) throws CorruptDataException {
        return new Byte(this.getLong(mapto).byteValue());
    }

    public Byte[] getBytes(String mapto, int len) throws CorruptDataException {
        this.parse(mapto);
        Byte[] b = new Byte[len];
        for (int i = 0; i < len; ++i) {
            b[i] = new Byte(this.readPrimitiveValue(this.Address + (long)i, 1).byteValue());
        }
        return b;
    }

    public Short getShort(String mapto) throws CorruptDataException {
        return new Short(this.getLong(mapto).shortValue());
    }

    public Float getFloat(String mapto) throws CorruptDataException {
        return new Float(Float.intBitsToFloat(this.getLong(mapto).intValue()));
    }

    public Double getDouble(String mapto) throws CorruptDataException {
        return new Double(Double.longBitsToDouble(this.getLong(mapto)));
    }

    public Boolean getBoolean(String mapto) throws CorruptDataException {
        return new Boolean(this.getLong(mapto) != 0L);
    }

    private String getCString() throws CorruptDataException {
        if (this.Address == 0L) {
            throw new CorruptDataException(new CorruptDataImpl("Null address encountered accessing structure member " + this.member.getName() + ", parseTrace=" + this.parseTrace));
        }
        StringBuffer txt = new StringBuffer();
        byte[] b = null;
        long addr = this.Address;
        try {
            do {
                if ((b = this.context.readBytes(addr, 1L)) != null && b.length != 0 && b[0] != 0) {
                    txt.append((char)b[0]);
                }
                ++addr;
            } while (b != null && b.length != 0 && b[0] != 0);
        }
        catch (MemoryAccessException ae) {
            throw new CorruptDataException(new CorruptDataImpl(ae.getPointer(), ae.getMessage()));
        }
        return txt.toString();
    }

    private Long readPrimitiveValue(long address, int byteSize) throws CorruptDataException {
        if (address == 0L) {
            throw new CorruptDataException(new CorruptDataImpl("Null address encountered accessing structure member " + this.member.getName() + ", parseTrace=" + this.parseTrace));
        }
        long value = 0L;
        try {
            switch (byteSize) {
                case 1: {
                    value = this.context.readByte(address);
                    break;
                }
                case 2: {
                    value = this.context.readShort(address);
                    break;
                }
                case 4: {
                    value = this.context.readInt(address);
                    break;
                }
                case 8: {
                    value = this.context.readLong(address);
                }
            }
        }
        catch (MemoryAccessException ae) {
            throw new CorruptDataException(new CorruptDataImpl(ae.getPointer(), ae.toString() + ", trace: " + this.parseTrace));
        }
        return new Long(value);
    }

    public long getlong(String mapto) throws CorruptDataException, MemoryAccessException {
        return this.getLong(mapto);
    }

    public int getint(String mapto) throws MemoryAccessException, CorruptDataException {
        return this.getInteger(mapto);
    }

    public char getchar(String mapto) throws MemoryAccessException, CorruptDataException {
        return this.getChar(mapto).charValue();
    }

    public byte getbyte(String mapto) throws MemoryAccessException, CorruptDataException {
        return this.getByte(mapto);
    }

    public byte[] getbytes(String mapto, int len) throws CorruptDataException {
        this.parse(mapto);
        byte[] b = new byte[len];
        for (int i = 0; i < len; ++i) {
            b[i] = this.readPrimitiveValue(this.Address + (long)i, 1).byteValue();
        }
        return b;
    }

    public short getshort(String mapto) throws MemoryAccessException, CorruptDataException {
        return this.getShort(mapto);
    }

    public float getfloat(String mapto) throws MemoryAccessException, CorruptDataException {
        return this.getFloat(mapto).floatValue();
    }

    public double getdouble(String mapto) throws MemoryAccessException, CorruptDataException {
        return this.getDouble(mapto);
    }

    public boolean getboolean(String mapto) throws MemoryAccessException, CorruptDataException {
        return this.getBoolean(mapto);
    }
}

