/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.sov.data;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.sov.data.DataLocator;
import com.ibm.dtfj.sov.data.StructuredDataLocator;
import com.ibm.dtfj.sov.data.StructuredObject;
import com.ibm.dtfj.sov.data.StructuredObjectDescriptor;
import com.ibm.dtfj.sov.image.AddressSpaceProxy;
import com.ibm.dtfj.sov.image.CorruptDataImpl;

public class DataObject
implements StructuredObject {
    StructuredObjectDescriptor descriptor = null;
    long address = 0L;
    AddressSpaceProxy context = null;
    DataLocator reader = null;
    protected int myHashCode;

    public DataObject(Object owner, String mapto, AddressSpaceProxy context) throws CorruptDataException {
        this.context = context;
        this.reader = new DataLocator(owner, context);
        this.reader.parse(mapto);
        this.descriptor = this.reader.getDescriptor();
        this.address = this.reader.getAddress();
        this.generateHashCode(this.address);
        if (this.descriptor == null) {
            throw new CorruptDataException(new CorruptDataImpl("Mapto locator must resolve to a DataObject reference: '" + mapto + "'"));
        }
        this.reader.setOwner(this);
    }

    public StructuredObjectDescriptor getDescriptor() {
        return this.descriptor;
    }

    public long getAddress() {
        return this.address;
    }

    public long getMemberAddress(String mapto) throws CorruptDataException {
        this.reader.parse(mapto);
        long addr = this.reader.getAddress();
        return addr;
    }

    public void setAddress(long newAddr) {
        this.address = newAddr;
        this.generateHashCode(newAddr);
    }

    public StructuredDataLocator getReader() {
        return this.reader;
    }

    public String toString() {
        return "D: `" + this.descriptor + "', A: `" + this.address + "', C:`" + this.context + "', R:`" + this.reader + "'";
    }

    public int hashCode() {
        return this.myHashCode;
    }

    private void generateHashCode(long address) {
        this.myHashCode = (int)(address >> 32) + (int)address;
    }

    public boolean equals(Object obj) {
        return obj instanceof DataObject && ((DataObject)obj).getAddress() == this.address;
    }
}

