/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.sov.data;

import com.ibm.dtfj.sov.data.ArrayDescriptor;
import com.ibm.dtfj.sov.data.DataObjectDescriptor;
import com.ibm.dtfj.sov.data.DescriptorMember;
import com.ibm.dtfj.sov.data.EnumerationDescriptor;
import com.ibm.dtfj.sov.data.FunctionPtrDescriptor;
import com.ibm.dtfj.sov.data.StructUnionDescriptor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DescriptorManager
extends DefaultHandler {
    private Hashtable doDescriptors = new Hashtable();
    public boolean trace = false;
    private Stack dodStack = null;
    private int skipElement = 0;
    static final String[] primitiveTypes = new String[]{"int", "uint", "long", "ulong", "char", "uchar", "short", "ushort", "float", "double", "void"};
    static final String[] memberTypes = new String[]{"Array", "Structure", "Union", "ReferenceTo", "Enumeration", "FunctionPointer", "int", "uint", "long", "ulong", "char", "uchar", "short", "ushort", "float", "double"};
    static final String[] memberMemberAttrs = new String[]{"name", "type", "offset", "indirectionCount", "ReferencedType", "indexFirst", "indexLast", "dimensions", "elementType", "returnType", "size"};

    public DataObjectDescriptor getDescriptor(String name) {
        DataObjectDescriptor dod = (DataObjectDescriptor)this.doDescriptors.get(name);
        return dod;
    }

    public void loadConfiguration() {
        this.loadConfiguration(new File("nativeStructure.xml"));
    }

    public void loadConfiguration(File nativemap) {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        this.dodStack = new Stack();
        try {
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(nativemap, (DefaultHandler)this);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.dodStack = null;
    }

    public void loadConfiguration(InputStream nativemapIS) throws IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        this.dodStack = new Stack();
        try {
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(nativemapIS, (DefaultHandler)this);
        }
        catch (ParserConfigurationException e) {
            throw new IOException("DescriptorManager: ParserConfigurationException " + e.getMessage());
        }
        catch (SAXException e) {
            throw new IOException("DescriptorManager: SAXException " + e.getMessage());
        }
        this.dodStack = null;
    }

    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
        String[] values = null;
        if (this.skipElement != 0) {
            ++this.skipElement;
            return;
        }
        String elementName = sName;
        if (elementName.length() == 0) {
            elementName = qName;
        }
        if (elementName.equals("Map")) {
            return;
        }
        if (elementName.equals("DataObject")) {
            values = this.getAttrValues(attrs, new String[]{"name", "type", "size"});
            if (values[0].length() > 0) {
                int dosize = 0;
                if (values[2] != null && values[2].length() != 0) {
                    try {
                        dosize = Integer.parseInt(values[2]);
                    }
                    catch (NumberFormatException nfe) {
                        throw new SAXException("DataObject '" + values[0] + "' has invalid 'size' integer attribute.");
                    }
                }
                this.dodStack.push(new DataObjectDescriptor(values[0], values[1], dosize));
            } else {
                ++this.skipElement;
            }
        } else {
            if (this.dodStack.empty()) {
                throw new SAXException("<" + elementName + "> tag must be inside a <DataObject> tag.");
            }
            DescriptorMember currentMember = null;
            currentMember = (DescriptorMember)this.dodStack.peek();
            if (elementName.equals("Member")) {
                DescriptorMember member = null;
                values = this.getAttrValues(attrs, memberMemberAttrs);
                String type = values[1];
                switch (this.indexOf(memberTypes, type)) {
                    case -1: {
                        member = new DescriptorMember();
                        if (!this.trace) break;
                        System.out.println("   -- DescriptorMember " + values[0]);
                        break;
                    }
                    case 0: {
                        member = new ArrayDescriptor();
                        ((ArrayDescriptor)member).setIndexFirst(Integer.parseInt(values[5]));
                        ((ArrayDescriptor)member).setIndexLast(Integer.parseInt(values[6]));
                        ((ArrayDescriptor)member).setDimensions(Integer.parseInt(values[7]));
                        type = values[8];
                        if (!this.trace) break;
                        System.out.println("   -- ArrayDescriptor " + values[0]);
                        break;
                    }
                    case 1: 
                    case 2: {
                        member = new StructUnionDescriptor();
                        if (!this.trace) break;
                        System.out.println("   -- StructUnionDescriptor " + values[0]);
                        break;
                    }
                    case 3: {
                        member = new DescriptorMember();
                        type = values[4];
                        member.setIndirection(Integer.parseInt(values[3]));
                        if (!this.trace) break;
                        System.out.println("   -- DescriptorMember " + values[0]);
                        break;
                    }
                    case 4: {
                        member = new EnumerationDescriptor();
                        this.dodStack.push(member);
                        if (!this.trace) break;
                        System.out.println("   -- EnumerationDescriptor " + values[0]);
                        break;
                    }
                    case 5: {
                        member = new FunctionPtrDescriptor();
                        type = values[9];
                        if (!this.trace) break;
                        System.out.println("   -- FunctionPtrDescriptor " + values[0]);
                        break;
                    }
                    default: {
                        member = new DescriptorMember();
                        if (!this.trace) break;
                        System.out.println("   -- DescriptorMember " + values[0]);
                    }
                }
                member.setName(values[0]);
                member.setType(type);
                member.setByteOffset(Integer.parseInt(values[2]));
                String size = values[10];
                if (size != null && size.length() != 0) {
                    member.setByteSize(Integer.parseInt(size));
                }
                currentMember.add(member);
                this.dodStack.push(member);
            } else if (elementName.equals("Enumeration")) {
                EnumerationDescriptor member = new EnumerationDescriptor();
                member.setName("");
                member.setType("Enumeration");
                this.dodStack.push(member);
                if (this.trace) {
                    System.out.println("   -- EnumerationDescriptor ");
                }
            } else if (elementName.equals("EnumerationValue")) {
                if (this.dodStack.empty()) {
                    throw new SAXException("<" + elementName + "> tag must be inside <Enumeration> or <Member type=\"Enumeration\"> tag.");
                }
                EnumerationDescriptor theEnum = (EnumerationDescriptor)this.dodStack.peek();
                values = this.getAttrValues(attrs, new String[]{"name", "value"});
                theEnum.add(values[0], values[1]);
                if (this.trace) {
                    System.out.println("      -- " + values[0]);
                }
            } else if (!elementName.equals("Reference") && !elementName.equals("Primitive")) {
                System.err.println("ERROR: Unrecognized element: " + elementName);
                for (int i = 0; i < attrs.getLength(); ++i) {
                    System.err.println("\t" + attrs.getQName(i) + " - " + attrs.getValue(i));
                }
            }
        }
    }

    private int indexOf(String[] list, String value) {
        for (int j = 0; j < list.length; ++j) {
            if (!list[j].equals(value)) continue;
            return j;
        }
        return -1;
    }

    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        String elementName = sName;
        if (elementName.length() == 0) {
            elementName = qName;
        }
        if (this.skipElement != 0) {
            --this.skipElement;
            return;
        }
        if (elementName.equals("DataObject")) {
            if (this.dodStack.empty()) {
                throw new SAXException("Internal Error: No DataObject for </DataObject>");
            }
            DataObjectDescriptor currentDOD = (DataObjectDescriptor)this.dodStack.pop();
            this.doDescriptors.put(currentDOD.getName(), currentDOD);
        } else if (elementName.equals("Member")) {
            this.dodStack.pop();
        } else if (elementName.equals("Enumeration")) {
            this.dodStack.pop();
        }
    }

    private String[] getAttrValues(Attributes attrs, String[] attrNames) {
        String[] values = new String[attrNames.length];
        block0: for (int i = 0; i < attrs.getLength(); ++i) {
            String aValue = attrs.getValue(i);
            String aName = attrs.getLocalName(i);
            if (aName.length() == 0) {
                aName = attrs.getQName(i);
            }
            for (int j = 0; j < attrNames.length; ++j) {
                if (!attrNames[j].equals(aName)) continue;
                values[j] = aValue;
                continue block0;
            }
        }
        return values;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("Usage: java com.ibm.dtfj.data.DescriptorManager <xmlfile> [-trace]");
            System.exit(1);
        }
        DescriptorManager docm = new DescriptorManager();
        if (args.length == 2 && args[1].equals("-trace")) {
            docm.trace = true;
        }
        File xmlfile = new File(args[0]);
        docm.loadConfiguration(xmlfile);
        System.out.println("Total Descriptor count: " + docm.doDescriptors.size());
    }
}

