/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.sov.image;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.sov.image.AddressSpaceProxy;
import com.ibm.dtfj.sov.imp.ImagePointerEffigy;

public class ImagePointerProxy {
    private long address;
    private AddressSpaceProxy context;

    public ImagePointerProxy(long address, AddressSpaceProxy context) {
        this.address = address;
        this.context = context;
    }

    public long getAddress() {
        return this.address;
    }

    public AddressSpaceProxy getAddressSpace() {
        return this.context;
    }

    public ImagePointerProxy add(long offset) {
        return new ImagePointerProxy(this.address + offset, this.context);
    }

    public boolean isExecutable() throws DataUnavailable {
        throw new DataUnavailable("ImagePointer.isExecutable() is unimplemented for Sovereign DTFJ");
    }

    public boolean isReadOnly() throws DataUnavailable {
        throw new DataUnavailable("ImagePointer.isReadOnly() is unimplemented for Sovereign DTFJ");
    }

    public boolean isShared() throws DataUnavailable {
        throw new DataUnavailable("ImagePointer.isShared() is unimplemented for Sovereign DTFJ");
    }

    public ImagePointerProxy getPointerAt(long index) throws MemoryAccessException, CorruptDataException {
        return new ImagePointerProxy(this.context.readPointer(this.address + index), this.context);
    }

    public long getLongAt(long index) throws MemoryAccessException, CorruptDataException {
        return this.context.readLong(this.address + index);
    }

    public int getIntAt(long index) throws MemoryAccessException, CorruptDataException {
        return (int)this.context.readInt(this.address + index);
    }

    public short getShortAt(long index) throws MemoryAccessException, CorruptDataException {
        return (short)this.context.readShort(this.address + index);
    }

    public byte getByteAt(long index) throws MemoryAccessException, CorruptDataException {
        return (byte)this.context.readByte(this.address + index);
    }

    public float getFloatAt(long index) throws MemoryAccessException, CorruptDataException {
        return Float.intBitsToFloat((int)this.context.readInt(this.address + index));
    }

    public double getDoubleAt(long index) throws MemoryAccessException, CorruptDataException {
        return Double.longBitsToDouble(this.context.readLong(this.address + index));
    }

    public boolean equals(Object obj) {
        boolean isEqual = false;
        if (obj instanceof ImagePointerEffigy) {
            ImagePointerEffigy local = (ImagePointerEffigy)obj;
            isEqual = this.context.equals(local.getProxy().context) && this.address == local.getProxy().address;
        }
        return isEqual;
    }

    public int hashCode() {
        return this.context.hashCode() ^ ((int)this.address ^ (int)(this.address >> 32));
    }
}

