/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.sov.image;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.sov.data.DataLocator;
import com.ibm.dtfj.sov.data.DataObject;
import com.ibm.dtfj.sov.data.DataObjectDescriptor;
import com.ibm.dtfj.sov.data.DescriptorManager;
import com.ibm.dtfj.sov.image.AddressSpaceProxy;
import com.ibm.dtfj.sov.image.CorruptDataImpl;
import com.ibm.dtfj.sov.image.ImageProxy;
import com.ibm.dtfj.sov.nativeXML.Generator;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Iterator;

public abstract class ImageProxyImpl {
    DescriptorManager myDescriptorManager = new DescriptorManager();
    File nativeStructureFile = null;
    protected AddressSpaceProxy context = null;

    public void initStructures(File dump) throws FileNotFoundException, IOException {
        this.nativeStructureFile = dump;
        FileOutputStream stream = new FileOutputStream(this.nativeStructureFile);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, "UTF-8");
        Generator.extractFromDump((ImageProxy)((Object)this), writer);
        ((Writer)writer).close();
        this.myDescriptorManager.loadConfiguration(this.nativeStructureFile);
        if (this.myDescriptorManager.getDescriptor("ClassCacheEntry") == null || this.myDescriptorManager.getDescriptor("ClData") == null) {
            InputStream clDataIS = this.getClass().getResourceAsStream("/clData.xml");
            if (clDataIS != null) {
                URL clDataURL = this.getClass().getResource("/clData.xml");
                this.myDescriptorManager.loadConfiguration(clDataIS);
            } else {
                System.err.println("WARNING: No ClassLoader structure definitions found in dump.\n         No default definitions found in jar file.\n         ClassLoader data will not be reported");
            }
        }
    }

    public void loadExternalStructures(File nativeStructures) {
        this.myDescriptorManager.loadConfiguration(this.nativeStructureFile);
    }

    public DataObjectDescriptor getDescriptor(String name) {
        return this.myDescriptorManager.getDescriptor(name);
    }

    protected AddressSpaceProxy getContext() throws CorruptDataException {
        return this.context;
    }

    protected DataLocator getHpiReader() throws CorruptDataException {
        return null;
    }

    public Iterator getIPAddresses() throws DataUnavailable {
        try {
            DataLocator reader = this.getHpiReader();
            long hpiRasVersion = reader.getLong("ras.data.(Long)version");
            if (hpiRasVersion < 65538L) {
                throw new DataUnavailable("The IP addresses are not stored in the version of the JVM which created the dumpfile.");
            }
            int numIPAddresses = reader.getint("ras.data.(HPI_SysInfo*)sysInfo.numIPAddresses");
            if (numIPAddresses == 0) {
                throw new DataUnavailable("The IP addresses are not stored in the version of the JVM which created the dumpfile.");
            }
            return new AddressIterator(reader, numIPAddresses);
        }
        catch (MemoryAccessException e) {
            return new CorruptDataIterator(e);
        }
        catch (CorruptDataException e) {
            return new CorruptDataIterator(e);
        }
    }

    public String getHostName() throws DataUnavailable, CorruptDataException {
        try {
            DataLocator reader = this.getHpiReader();
            long hpiRasVersion = reader.getLong("ras.data.(Long)version");
            if (hpiRasVersion < 65538L) {
                throw new DataUnavailable("The hostname is not stored in the version of the JVM which created the dumpfile.");
            }
            String hostName = reader.getString("ras.data.(HPI_SysInfo*)sysInfo.hostname");
            return hostName;
        }
        catch (MemoryAccessException e) {
            throw new CorruptDataException(new CorruptDataImpl(e.getPointer(), e.getMessage()));
        }
    }

    class AddressIterator
    implements Iterator {
        DataLocator reader;
        int index = 0;
        int numEntries = 0;
        long arrayPointer = 0L;

        AddressIterator(DataLocator reader, int numEntries) throws MemoryAccessException, CorruptDataException {
            this.reader = reader;
            this.numEntries = numEntries;
            boolean i = false;
            if (ImageProxyImpl.this.getContext().getWordLength().size == 4) {
                long arrayPointerPointer = reader.getint("ras.data.(HPI_SysInfo*)sysInfo.(char *)ipAddresses");
            } else {
                long arrayPointerPointer = reader.getlong("ras.data.(HPI_SysInfo*)sysInfo.(char *)ipAddresses");
            }
            this.arrayPointer = reader.getAddress();
        }

        public boolean hasNext() {
            return this.index < this.numEntries;
        }

        public Object next() {
            DataObject inet = null;
            InetAddress inetAddress = null;
            try {
                long elPointer = this.reader.getPointerAt(this.arrayPointer);
                this.arrayPointer += (long)ImageProxyImpl.this.getContext().getWordLength().size;
                inet = new DataObject(null, "hpiIPAddress", ImageProxyImpl.this.getContext());
                inet.setAddress(elPointer);
                int len = inet.getReader().getint("len");
                byte[] address = inet.getReader().getbytes("bytes", len);
                inetAddress = InetAddress.getByAddress(address);
            }
            catch (MemoryAccessException m) {
                return new CorruptDataImpl(m.getMessage());
            }
            catch (CorruptDataException c) {
                return new CorruptDataImpl(c.getMessage());
            }
            catch (UnknownHostException h) {
                return new CorruptDataImpl(h.getMessage());
            }
            ++this.index;
            return inetAddress;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class CorruptDataIterator
    implements Iterator {
        Exception exception;
        boolean hasNext = true;

        CorruptDataIterator(Exception exception) {
            this.exception = exception;
        }

        public boolean hasNext() {
            boolean ret = this.hasNext;
            this.hasNext = false;
            return ret;
        }

        public Object next() {
            return new CorruptDataImpl(this.exception.getMessage());
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

