/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.sov.image;

import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.ImageSection;
import com.ibm.dtfj.sov.Effigy;
import com.ibm.dtfj.sov.image.AddressSpaceProxy;
import com.ibm.dtfj.sov.image.ImagePointerProxy;

public class ImageSectionImpl
implements ImageSection {
    private ImagePointer myBaseAddress;
    private long mySize;
    private String myName;
    private boolean myIsExecutable;
    private boolean myIsReadOnly;
    private boolean myIsShared;
    private boolean myHasAttributes;

    public ImageSectionImpl(ImagePointer baseAddress, long size, String name, boolean executable, boolean readOnly, boolean shared, boolean hasAttributes) {
        this.myBaseAddress = baseAddress;
        this.mySize = size;
        this.myName = name;
        this.myIsExecutable = executable;
        this.myIsReadOnly = readOnly;
        this.myIsShared = shared;
        this.myHasAttributes = hasAttributes;
    }

    public ImageSectionImpl(AddressSpaceProxy context, long baseAddress, long size, String name, boolean executable, boolean readOnly, boolean shared, boolean hasAttributes) {
        ImagePointer myImagePointer = null;
        this.myBaseAddress = myImagePointer = (ImagePointer)((Object)Effigy.create("ImagePointerEffigy", new ImagePointerProxy(baseAddress, context), context, context.getPlatformName()));
        this.mySize = size;
        this.myName = name;
        this.myIsExecutable = executable;
        this.myIsReadOnly = readOnly;
        this.myIsShared = shared;
        this.myHasAttributes = hasAttributes;
    }

    public ImagePointer getBaseAddress() {
        return this.myBaseAddress;
    }

    public long getSize() {
        return this.mySize;
    }

    public String getName() {
        return this.myName;
    }

    public boolean isExecutable() throws DataUnavailable {
        if (!this.myHasAttributes) {
            throw new DataUnavailable("ImageSection at 0x" + Long.toHexString(this.myBaseAddress.getAddress()) + " does not have isExecutable status.");
        }
        return this.myIsExecutable;
    }

    public boolean isReadOnly() throws DataUnavailable {
        if (!this.myHasAttributes) {
            throw new DataUnavailable("ImageSection at 0x" + Long.toHexString(this.myBaseAddress.getAddress()) + " does not have isReadOnly status.");
        }
        return this.myIsReadOnly;
    }

    public boolean isShared() throws DataUnavailable {
        if (!this.myHasAttributes) {
            throw new DataUnavailable("ImageSection at 0x" + Long.toHexString(this.myBaseAddress.getAddress()) + " does not have isShared status.");
        }
        return this.myIsShared;
    }

    public String toString() {
        return this.myName + this.myBaseAddress.getAddress();
    }
}

