/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.sov.image;

import com.ibm.dtfj.sov.image.AddressSpaceProxy;
import com.ibm.dtfj.sov.image.ImagePointerProxy;
import com.ibm.dtfj.sov.image.StackFrame;

public class ImageStackFrameProxy
extends StackFrame {
    long mb;
    long pc;
    long bp;
    int nameLen;
    String name;
    AddressSpaceProxy context;

    public long frameid() {
        return this.bp;
    }

    public ImageStackFrameProxy(ImageStackFrameProxy nf) {
        this.mb = nf.mb;
        this.pc = nf.pc;
        this.bp = nf.bp;
        this.context = nf.context;
        this.frameType = nf.frameType;
        this.name = nf.name;
        this.nameLen = nf.getProcedureName() == null ? 0 : nf.getProcedureName().length();
    }

    public ImageStackFrameProxy(AddressSpaceProxy context) {
        this.context = context;
    }

    public void setMb(long m) {
        this.mb = m;
    }

    public void setPc(long p) {
        this.pc = p;
    }

    public void setBp(long s) {
        this.bp = s;
    }

    public void setName(String n) {
        this.name = n;
    }

    public void setFrameType(int t) {
        this.frameType = t;
    }

    public long getMb() {
        return this.mb;
    }

    public long getPc() {
        return this.pc;
    }

    public ImagePointerProxy getProcedureAddress() {
        return new ImagePointerProxy(this.pc, this.context);
    }

    public ImagePointerProxy getBasePointer() {
        return new ImagePointerProxy(this.bp, this.context);
    }

    public String getProcedureName() {
        return this.name;
    }

    public String toString() {
        if (this.name == null) {
            return "pseudo frame";
        }
        return this.name + " mb 0x" + Long.toHexString(this.mb) + " pc 0x" + Long.toHexString(this.pc) + " sp 0x" + Long.toHexString(this.bp);
    }
}

