/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.sov.image;

public class StackFrame {
    public static final int FRAME_TYPE_MMI = 0;
    public static final int FRAME_TYPE_JAVA = 1;
    public static final int FRAME_TYPE_JIT = 2;
    public static final int FRAME_TYPE_NATIVE = 3;
    static final String[] FRAME_TYPE_DESCRIPTION = new String[]{"MMI", "JAVA", "JIT", "NATIVE"};
    protected int frameType;

    public boolean isJit() {
        return this.frameType == 2;
    }

    public boolean isNative() {
        return this.frameType == 3;
    }

    public boolean isMmi() {
        return this.frameType == 0;
    }

    public boolean isJava() {
        return this.frameType == 1;
    }

    public byte[] getMetadata() {
        return null;
    }

    public void setFrameType(int t) {
        this.frameType = t;
    }

    public String getFrameType() {
        if (this.frameType >= 0 && this.frameType < FRAME_TYPE_DESCRIPTION.length) {
            return FRAME_TYPE_DESCRIPTION[this.frameType];
        }
        return "Unknown frame type " + this.frameType;
    }
}

