/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.sov.java.imp;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.sov.data.DataObject;
import com.ibm.dtfj.sov.image.AddressSpaceProxy;
import com.ibm.dtfj.sov.image.CorruptDataImpl;
import com.ibm.dtfj.sov.java.imp.JavaClassProxyImpl;
import com.ibm.dtfj.sov.java.imp.JavaObjectProxyImpl;
import com.ibm.dtfj.sov.java.imp.ObjectFieldProxyImpl;
import java.util.Iterator;

class FieldIterator
implements Iterator {
    private final JavaObjectProxyImpl impl;
    private int currentFieldNo = 0;
    private long maxFields;
    private long fieldBlockAddress;
    private DataObject superClassBlockDO = null;
    private DataObject currentClassBlockDO = null;
    private boolean staticsOnly = false;
    private AddressSpaceProxy context;
    private static int fieldBlockSize = -1;

    FieldIterator(JavaObjectProxyImpl impl) throws CorruptDataException {
        this.impl = impl;
        this.context = impl.getContext();
        try {
            if (this.superClassBlockDO == null) {
                this.superClassBlockDO = new DataObject(null, "Hjava_lang_Class", this.context);
            }
            if (fieldBlockSize == -1) {
                fieldBlockSize = this.context.getDescriptor("fieldblock").getByteSize();
            }
            this.maxFields = this.impl.classBlockDO.getReader().getShort("obj.fields_count").shortValue();
            this.fieldBlockAddress = this.impl.classBlockDO.getMemberAddress("obj.fields");
        }
        catch (MemoryAccessException e) {
            throw new CorruptDataException(new CorruptDataImpl(e.getPointer(), e.getMessage()));
        }
        this.currentClassBlockDO = this.impl.classBlockDO;
    }

    public FieldIterator(JavaClassProxyImpl javaClassProxyImpl) throws CorruptDataException {
        this.impl = null;
        this.currentClassBlockDO = javaClassProxyImpl.myDataObject;
        this.context = javaClassProxyImpl.context;
        try {
            if (this.superClassBlockDO == null) {
                this.superClassBlockDO = new DataObject(null, "Hjava_lang_Class", this.context);
            }
            if (fieldBlockSize == -1) {
                fieldBlockSize = this.context.getDescriptor("fieldblock").getByteSize();
            }
            this.maxFields = this.currentClassBlockDO.getReader().getShort("obj.fields_count").shortValue();
            this.fieldBlockAddress = this.currentClassBlockDO.getMemberAddress("obj.fields");
            this.staticsOnly = true;
        }
        catch (MemoryAccessException e) {
            throw new CorruptDataException(new CorruptDataImpl(e.getPointer(), e.getMessage()));
        }
    }

    private boolean getSuperClass() {
        long superClassBlockAddress = 0L;
        try {
            superClassBlockAddress = this.currentClassBlockDO.getReader().getLong("obj.(Long)superclass");
        }
        catch (CorruptDataException e) {
            return false;
        }
        catch (MemoryAccessException e) {
            return false;
        }
        if (superClassBlockAddress == 0L) {
            return false;
        }
        this.superClassBlockDO.setAddress(superClassBlockAddress);
        this.currentClassBlockDO = this.superClassBlockDO;
        try {
            this.maxFields = this.superClassBlockDO.getReader().getShort("obj.fields_count").shortValue();
            this.fieldBlockAddress = this.superClassBlockDO.getMemberAddress("obj.fields");
            this.currentFieldNo = 0;
            return true;
        }
        catch (MemoryAccessException e) {
            return false;
        }
        catch (CorruptDataException e) {
            return false;
        }
    }

    public boolean hasNext() {
        while (true) {
            if ((long)this.currentFieldNo >= this.maxFields) {
                if (this.getSuperClass()) continue;
                return false;
            }
            if (!this.staticsOnly) {
                return true;
            }
            try {
                if (ObjectFieldProxyImpl.isStatic(this.fieldBlockAddress, this.context)) {
                    return true;
                }
            }
            catch (MemoryAccessException e) {
                return false;
            }
            catch (CorruptDataException e) {
                return false;
            }
            this.fieldBlockAddress += (long)fieldBlockSize;
            ++this.currentFieldNo;
        }
    }

    public Object next() {
        try {
            if (this.hasNext()) {
                long currentFieldBlockAddress = this.fieldBlockAddress;
                this.fieldBlockAddress += (long)fieldBlockSize;
                ++this.currentFieldNo;
                if (this.staticsOnly) {
                    return new ObjectFieldProxyImpl(currentFieldBlockAddress, 0L, 0, this.context);
                }
                return new ObjectFieldProxyImpl(currentFieldBlockAddress, this.impl.getDataAddress(), this.impl.sharedClassId, this.context);
            }
        }
        catch (MemoryAccessException e) {
            return new CorruptDataImpl(e.getPointer(), e.toString());
        }
        catch (CorruptDataException e) {
            return e.getCorruptData();
        }
        return null;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

