/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.sov.java.imp;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.sov.image.AddressSpaceProxy;
import com.ibm.dtfj.sov.image.CorruptDataImpl;
import com.ibm.dtfj.sov.java.imp.JavaRuntimeProxyImpl;

class HeapChunk {
    private static final long threadMask = 0x7FFF0000L;
    private static final long monitorMask = 0x7FFFFF00L;
    private static final long shapeMask = Integer.MIN_VALUE;
    private static final long threadShift = 16L;
    private static final long monitorShift = 8L;
    private static final long OBJECTGRAIN = 8L;

    private HeapChunk() {
    }

    static boolean isObject(long olinkAddress, AddressSpaceProxy context) throws CorruptDataException {
        return context.getJavaRuntimeProxy().isLiveChunk(olinkAddress);
    }

    static boolean isLocked(long olinkAddress, AddressSpaceProxy context) throws CorruptDataException {
        int locknflags;
        if (!HeapChunk.isObject(olinkAddress, context)) {
            return false;
        }
        try {
            locknflags = (int)context.readInt(olinkAddress + (long)(context.getWordLength().size * 2));
        }
        catch (MemoryAccessException e) {
            throw new CorruptDataException(new CorruptDataImpl(e.getPointer(), e.getMessage()));
        }
        if (((long)locknflags & Integer.MIN_VALUE) == 0L) {
            return (int)((long)locknflags & 0x7FFF0000L) >> 16 != 0;
        }
        return (int)((long)locknflags & 0x7FFFFF00L) >> 8 != 0;
    }

    static long olinkLen(long olinkAddress, AddressSpaceProxy context) throws CorruptDataException {
        JavaRuntimeProxyImpl jvmProxyImpl = (JavaRuntimeProxyImpl)context.getJavaRuntimeProxy();
        long len = jvmProxyImpl.tlhChunkLength(olinkAddress);
        if (len == -1L) {
            long olink;
            try {
                olink = context.readPointer(olinkAddress);
            }
            catch (MemoryAccessException e) {
                throw new CorruptDataException(new CorruptDataImpl(e.getPointer(), e.getMessage()));
            }
            int WORD_LENGTH = context.getWordLength().size;
            long OLINK_IsHashed = 1 << WORD_LENGTH * 8 - 1;
            long OLINK_IsContendedFor = 1 << WORD_LENGTH * 8 - 2;
            long OLINK_LenMask = (OLINK_IsHashed | OLINK_IsContendedFor | 7L) ^ 0xFFFFFFFFFFFFFFFFL;
            return olink & OLINK_LenMask;
        }
        return len;
    }
}

