/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.sov.java.imp;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.sov.data.DataObject;
import com.ibm.dtfj.sov.image.AddressSpaceProxy;
import com.ibm.dtfj.sov.image.CorruptDataImpl;
import com.ibm.dtfj.sov.imp.JavaClassLoaderEffigy;
import com.ibm.dtfj.sov.java.JavaClassLoaderProxy;
import com.ibm.dtfj.sov.java.JavaClassProxy;
import com.ibm.dtfj.sov.java.JavaObjectProxy;
import com.ibm.dtfj.sov.java.imp.JavaClassProxyImpl;
import com.ibm.dtfj.sov.java.imp.JavaObjectProxyImpl;
import com.ibm.dtfj.sov.java.imp.JavaRuntimeProxyImpl;
import com.ibm.dtfj.sov.java.imp.ObjectFieldProxyImpl;
import com.ibm.dtfj.sov.utils.JoinedIterator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class JavaClassLoaderProxyImpl
implements JavaClassLoaderProxy {
    private DataObject myDataObject;
    private AddressSpaceProxy context;
    private DataObject classLoaderObject = null;
    private JavaObjectProxyImpl classesVectorObject = null;
    private JavaObjectProxyImpl classesArray = null;
    private long loadedClassesCount = -1L;
    private HashMap classLoaderHash = null;
    private Vector prunedPrimitiveArrays;
    private JavaObjectProxyImpl classLoaderObjectProxy = null;

    public JavaClassLoaderProxyImpl(DataObject dataObject, AddressSpaceProxy context) {
        this.myDataObject = dataObject;
        this.context = context;
    }

    public JavaClassLoaderProxyImpl(long address, AddressSpaceProxy context) throws CorruptDataException {
        this.myDataObject = new DataObject(null, "ClassLoaderShadow", context);
        this.myDataObject.setAddress(address);
        this.context = context;
    }

    private void getData(AddressSpaceProxy context) throws CorruptDataException, MemoryAccessException {
        long classLoaderObjectAddress = this.myDataObject.getReader().getLong("(Long)loader");
        this.loadedClassesCount = this.myDataObject.getReader().getLong("loadedCount");
        if (classLoaderObjectAddress != 0L) {
            this.classLoaderObject = new DataObject(null, "Hjava_lang_ClassLoader", context);
            this.classLoaderObject.setAddress(classLoaderObjectAddress);
            long classesAddress = this.classLoaderObject.getReader().getLong("obj.(Long)classes");
            this.classesVectorObject = JavaObjectProxyImpl.getInstance(classesAddress, context);
            Iterator fields = this.classesVectorObject.getFields();
            while (fields.hasNext()) {
                ObjectFieldProxyImpl field = (ObjectFieldProxyImpl)fields.next();
                if (!field.getName().equals("elementData")) continue;
                long classesArrayAddress = (Long)field.getValue();
                this.classesArray = JavaObjectProxyImpl.getInstance(classesArrayAddress, context);
                break;
            }
        }
    }

    private String decode(String className) {
        if (className.charAt(0) != '[') {
            return className;
        }
        StringBuffer result = new StringBuffer(className.length() + 20);
        int i = 0;
        while (className.charAt(i) == '[') {
            result.append("Array of ");
            ++i;
        }
        try {
            switch (className.charAt(i)) {
                case 'Z': {
                    result.append("boolean");
                    break;
                }
                case 'B': {
                    result.append("byte");
                    break;
                }
                case 'C': {
                    result.append("char");
                    break;
                }
                case 'I': {
                    result.append("int");
                    break;
                }
                case 'J': {
                    result.append("long");
                    break;
                }
                case 'S': {
                    result.append("short");
                    break;
                }
                case 'F': {
                    result.append("float");
                    break;
                }
                case 'D': {
                    result.append("double");
                    break;
                }
                case 'L': {
                    result.append(className.substring(++i, className.length() - 1));
                    break;
                }
                default: {
                    return className;
                }
            }
            return result.toString();
        }
        catch (Exception e) {
            return e.toString() + className;
        }
    }

    public Iterator getDefinedClasses() {
        if (this.loadedClassesCount == -1L) {
            try {
                this.getData(this.context);
            }
            catch (CorruptDataException e) {
                Vector<CorruptData> badvec = new Vector<CorruptData>();
                badvec.add(e.getCorruptData());
                return badvec.iterator();
            }
            catch (MemoryAccessException e) {
                Vector<CorruptDataImpl> badvec = new Vector<CorruptDataImpl>();
                badvec.add(new CorruptDataImpl(e.getPointer(), e.toString()));
                return badvec.iterator();
            }
        }
        if (this.classesArray == null) {
            return this.getCachedClasses();
        }
        return new ClassVectorIterator();
    }

    public JavaClassProxy findClass(String name) {
        if (this.classLoaderHash == null) {
            Iterator classes = this.getCachedClasses();
            this.classLoaderHash = new HashMap();
            while (classes.hasNext()) {
                Object aclass = classes.next();
                if (!(aclass instanceof JavaClassProxy)) continue;
                try {
                    this.classLoaderHash.put(((JavaClassProxy)aclass).getName(), aclass);
                }
                catch (CorruptDataException e) {}
            }
        }
        return (JavaClassProxy)this.classLoaderHash.get(name);
    }

    private void initPrunedPrimitiveArrays() throws CorruptDataException, MemoryAccessException {
        this.prunedPrimitiveArrays = (Vector)((JavaRuntimeProxyImpl)this.context.getJavaRuntimeProxy()).getPrimitiveArrays().clone();
        classCacheIterator classes = new classCacheIterator();
        while (classes.hasNext()) {
            Object obj = classes.next();
            try {
                JavaClassProxyImpl jcpl;
                String name;
                if (!(obj instanceof JavaClassProxyImpl) || (name = (jcpl = (JavaClassProxyImpl)obj).getName()).charAt(0) != '[' || name.length() != 2) continue;
                Iterator primArrays = this.prunedPrimitiveArrays.iterator();
                while (primArrays.hasNext()) {
                    JavaClassProxyImpl javaClass = (JavaClassProxyImpl)primArrays.next();
                    if (!javaClass.getName().equals(name)) continue;
                    this.prunedPrimitiveArrays.remove(obj);
                }
            }
            catch (CorruptDataException corruptDataException) {}
        }
    }

    public Iterator getCachedClasses() {
        try {
            if (this.loadedClassesCount == -1L) {
                this.getData(this.context);
            }
            if (this.classesArray != null) {
                return new classCacheIterator();
            }
            if (this.prunedPrimitiveArrays == null) {
                this.initPrunedPrimitiveArrays();
            }
            Iterator[] iterators = new Iterator[]{((JavaRuntimeProxyImpl)this.context.getJavaRuntimeProxy()).getPrimitiveClasses().iterator(), new classCacheIterator(), this.prunedPrimitiveArrays.iterator()};
            return new JoinedIterator(iterators, 3);
        }
        catch (CorruptDataException e) {
            Vector<CorruptData> badvec = new Vector<CorruptData>();
            badvec.add(e.getCorruptData());
            return badvec.iterator();
        }
        catch (MemoryAccessException e) {
            Vector<CorruptDataImpl> badvec = new Vector<CorruptDataImpl>();
            badvec.add(new CorruptDataImpl(e.getPointer(), e.toString()));
            return badvec.iterator();
        }
    }

    public JavaObjectProxy getObject() throws CorruptDataException {
        if (this.loadedClassesCount == -1L) {
            try {
                this.getData(this.context);
            }
            catch (MemoryAccessException e) {
                throw new CorruptDataException(new CorruptDataImpl(e.getPointer(), e.getMessage()));
            }
        }
        if (this.classesArray == null) {
            return null;
        }
        if (this.classLoaderObjectProxy == null) {
            try {
                this.classLoaderObjectProxy = JavaObjectProxyImpl.getInstance(this.classLoaderObject.getAddress(), this.context);
            }
            catch (MemoryAccessException e) {
                throw new CorruptDataException(new CorruptDataImpl(e.getPointer(), e.getMessage()));
            }
        }
        return this.classLoaderObjectProxy;
    }

    public int hashCode() {
        return this.myDataObject.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof JavaClassLoaderEffigy) {
            return ((JavaClassLoaderProxyImpl)((JavaClassLoaderEffigy)obj).getProxy()).myDataObject.equals(this.myDataObject);
        }
        if (obj instanceof JavaClassLoaderProxyImpl) {
            return ((JavaClassLoaderProxyImpl)obj).myDataObject.equals(this.myDataObject);
        }
        return false;
    }

    public long getAddress() {
        return this.myDataObject.getAddress();
    }

    private final class ClassVectorIterator
    implements Iterator {
        int currentEntry = 0;
        long currentReference = 0L;

        ClassVectorIterator() {
            this.findNextReference();
        }

        private void findNextReference() {
            this.currentReference = 0L;
            while ((long)this.currentEntry < JavaClassLoaderProxyImpl.this.loadedClassesCount) {
                try {
                    this.currentReference = JavaClassLoaderProxyImpl.this.context.readPointer(JavaClassLoaderProxyImpl.this.classesArray.getDataAddress() + (long)(this.currentEntry * ((JavaClassLoaderProxyImpl)JavaClassLoaderProxyImpl.this).context.getWordLength().size));
                    if (this.currentReference != 0L) break;
                    ++this.currentEntry;
                }
                catch (MemoryAccessException e) {
                    this.currentEntry = (int)JavaClassLoaderProxyImpl.this.loadedClassesCount;
                }
            }
        }

        public boolean hasNext() {
            return this.currentReference != 0L;
        }

        public Object next() {
            if (this.hasNext()) {
                Object result;
                long referenceToUse = this.currentReference;
                try {
                    result = new JavaClassProxyImpl(referenceToUse, JavaClassLoaderProxyImpl.this.context);
                }
                catch (CorruptDataException e) {
                    result = e.getCorruptData();
                }
                ++this.currentEntry;
                this.findNextReference();
                return result;
            }
            return null;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private final class classCacheIterator
    implements Iterator {
        DataObject classCacheEntryDO;
        private static final int LOADER_CACHE_TABLE_SIZE = 101;
        private int bucketNumber = 0;
        private long bucketAddress = 0L;
        private long cceAddress = 0L;
        private long currentReference = 0L;

        public classCacheIterator() throws CorruptDataException, MemoryAccessException {
            this.classCacheEntryDO = new DataObject(null, "ClassCacheEntry", JavaClassLoaderProxyImpl.this.context);
            this.bucketAddress = JavaClassLoaderProxyImpl.this.myDataObject.getReader().getLong("cache.(Long)utf8_bucket");
            this.getNextNonEmptyBucket();
            this.getNextReference();
        }

        private void getNextNonEmptyBucket() {
            while (this.bucketNumber < 101) {
                block4: {
                    try {
                        this.cceAddress = JavaClassLoaderProxyImpl.this.context.readPointer(this.bucketAddress);
                        if (this.cceAddress != 0L) {
                        }
                        break block4;
                    }
                    catch (MemoryAccessException e) {
                        this.cceAddress = 0L;
                        this.bucketNumber = 101;
                        this.currentReference = 0L;
                    }
                    break;
                }
                this.nextBucket();
            }
        }

        private void nextBucket() {
            ++this.bucketNumber;
            this.bucketAddress += (long)((JavaClassLoaderProxyImpl)JavaClassLoaderProxyImpl.this).context.getWordLength().size;
        }

        private void getNextCce() throws CorruptDataException, MemoryAccessException {
            this.cceAddress = this.classCacheEntryDO.getReader().getLong("(Long)next");
            if (this.cceAddress != 0L) {
                return;
            }
            this.nextBucket();
            this.getNextNonEmptyBucket();
        }

        private void getNextReference() throws CorruptDataException, MemoryAccessException {
            this.currentReference = 0L;
            while (this.bucketNumber < 101) {
                this.classCacheEntryDO.setAddress(this.cceAddress);
                this.currentReference = this.classCacheEntryDO.getReader().getLong("(Long)cb");
                if (this.currentReference != 0L) break;
                this.getNextCce();
            }
        }

        public boolean hasNext() {
            return this.currentReference != 0L;
        }

        public Object next() {
            long referenceToUse = this.currentReference;
            try {
                this.getNextCce();
                this.getNextReference();
                JavaClassProxyImpl result = new JavaClassProxyImpl(referenceToUse, JavaClassLoaderProxyImpl.this.context);
                return result;
            }
            catch (CorruptDataException e) {
                return e.getCorruptData();
            }
            catch (MemoryAccessException e) {
                return new CorruptDataImpl(e.getPointer(), e.toString());
            }
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

