/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.sov.java.imp;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.sov.data.DataObject;
import com.ibm.dtfj.sov.image.AddressSpaceProxy;
import com.ibm.dtfj.sov.image.CorruptDataImpl;
import com.ibm.dtfj.sov.image.ImagePointerProxy;
import com.ibm.dtfj.sov.imp.JavaClassEffigy;
import com.ibm.dtfj.sov.java.JavaClassLoaderProxy;
import com.ibm.dtfj.sov.java.JavaClassProxy;
import com.ibm.dtfj.sov.java.JavaObjectProxy;
import com.ibm.dtfj.sov.java.imp.JavaFieldProxyImpl;
import com.ibm.dtfj.sov.java.imp.JavaMethodProxyImpl;
import com.ibm.dtfj.sov.java.imp.JavaObjectProxyImpl;
import com.ibm.dtfj.sov.java.imp.JavaRuntimeProxyImpl;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import java.util.Vector;

public class JavaClassProxyImpl
implements JavaClassProxy {
    DataObject myDataObject;
    long address = -1L;
    AddressSpaceProxy context;
    ConstantPool constantPool;
    private Vector interfaceNames = null;
    ImagePointerProxy myID = null;
    String myName = null;
    public JavaObjectProxyImpl myJavaObjectProxtImpl = null;
    JavaClassProxy mySuperclass = null;

    public JavaClassProxyImpl(long address, AddressSpaceProxy context) throws CorruptDataException {
        this.address = address;
        this.myDataObject = new DataObject(null, "Hjava_lang_Class", context);
        this.myDataObject.setAddress(address);
        this.context = context;
        try {
            this.constantPool = new ConstantPool();
        }
        catch (MemoryAccessException e) {
            throw new CorruptDataException(new CorruptDataImpl(e.getPointer(), e.getMessage()));
        }
    }

    public JavaClassProxyImpl(DataObject dataObject, AddressSpaceProxy context) throws CorruptDataException {
        this.myDataObject = dataObject;
        this.address = this.myDataObject.getAddress();
        this.context = context;
        try {
            this.constantPool = new ConstantPool();
        }
        catch (MemoryAccessException e) {
            throw new CorruptDataException(new CorruptDataImpl(e.getPointer(), e.getMessage()));
        }
    }

    public JavaClassProxyImpl() {
    }

    public long getCBAddress() {
        return this.address;
    }

    private String decode(String className) {
        if (className.charAt(0) != '[') {
            return className;
        }
        StringBuffer result = new StringBuffer(className.length() + 20);
        int i = 0;
        while (className.charAt(i) == '[') {
            result.append("Array of ");
            ++i;
        }
        try {
            switch (className.charAt(i)) {
                case 'Z': {
                    result.append("boolean");
                    break;
                }
                case 'B': {
                    result.append("byte");
                    break;
                }
                case 'C': {
                    result.append("char");
                    break;
                }
                case 'I': {
                    result.append("int");
                    break;
                }
                case 'J': {
                    result.append("long");
                    break;
                }
                case 'S': {
                    result.append("short");
                    break;
                }
                case 'F': {
                    result.append("float");
                    break;
                }
                case 'D': {
                    result.append("double");
                    break;
                }
                case 'L': {
                    result.append(className.substring(++i, className.length() - 1));
                    break;
                }
                default: {
                    return className;
                }
            }
            return result.toString();
        }
        catch (Exception e) {
            return e.toString() + className;
        }
    }

    public JavaClassProxy getComponentType() throws IllegalArgumentException, CorruptDataException {
        if (!this.isArray()) {
            throw new IllegalArgumentException("JavaClass is not an Array");
        }
        try {
            char typeChar = this.getName().charAt(1);
            switch (typeChar) {
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'V': 
                case 'Z': {
                    long classBlockAddress = ((JavaRuntimeProxyImpl)this.context.getJavaRuntimeProxy()).getPrimitiveClass(typeChar);
                    return new JavaClassProxyImpl(classBlockAddress, this.context);
                }
                case 'L': 
                case '[': {
                    this.constantPool.getClass();
                    Object type = this.constantPool.getConstantPoolEntry(3);
                    if (type instanceof JavaClassProxyImpl) {
                        return (JavaClassProxyImpl)type;
                    }
                    throw new CorruptDataException(new CorruptDataImpl("Unable to find class with name " + this.getName().substring(1)));
                }
            }
            throw new CorruptDataException(new CorruptDataImpl("Unable to find class with name " + typeChar));
        }
        catch (MemoryAccessException e) {
            throw new CorruptDataException(new CorruptDataImpl(e.getPointer(), e.getMessage()));
        }
    }

    public Iterator getInterfaces() {
        if (this.interfaceNames == null) {
            int interfaceCount = 0;
            try {
                interfaceCount = this.myDataObject.getReader().getshort("obj.implements_count");
                if (interfaceCount == 0) {
                    this.interfaceNames = new Vector();
                } else {
                    this.interfaceNames = new Vector(interfaceCount);
                    long implementsAddress = this.myDataObject.getReader().getlong("obj.(long)implements");
                    for (int intface = 0; intface < interfaceCount; ++intface) {
                        try {
                            long indexAddress = implementsAddress + (long)(intface * 2);
                            short index = (short)this.context.readShort(indexAddress);
                            Object cpEntry = this.constantPool.getConstantPoolEntry(index);
                            if (cpEntry instanceof String) {
                                this.interfaceNames.add(cpEntry);
                                continue;
                            }
                            if (cpEntry instanceof JavaClassProxyImpl) {
                                this.interfaceNames.add(((JavaClassProxyImpl)cpEntry).getName());
                                continue;
                            }
                            this.interfaceNames.add(new CorruptDataImpl("Encountered invalid constant pool entry"));
                            continue;
                        }
                        catch (CorruptDataException e) {
                            this.interfaceNames.add(e.getCorruptData());
                            continue;
                        }
                        catch (MemoryAccessException e) {
                            this.interfaceNames.add(new CorruptDataImpl(e.getPointer(), e.getMessage()));
                        }
                    }
                }
            }
            catch (CorruptDataException e) {
                this.interfaceNames = new Vector();
                this.interfaceNames.add(e.getCorruptData());
            }
            catch (MemoryAccessException e) {
                this.interfaceNames = new Vector();
                this.interfaceNames.add(new CorruptDataImpl(e.getPointer(), e.getMessage()));
            }
        }
        return this.interfaceNames.iterator();
    }

    public ImagePointerProxy getID() {
        if (this.myID == null) {
            this.myID = new ImagePointerProxy(this.myDataObject.getAddress(), this.context);
        }
        return this.myID;
    }

    public String getName() throws CorruptDataException {
        if (this.myName == null) {
            try {
                this.myName = this.myDataObject.getReader().getString("obj.name");
            }
            catch (MemoryAccessException e) {
                throw new CorruptDataException(new CorruptDataImpl(e.getPointer(), e.toString()));
            }
        }
        return this.myName;
    }

    public Iterator getDeclaredFields() {
        try {
            return new FieldIterator(this.myDataObject.getMemberAddress("obj.fields"), this.myDataObject.getReader().getshort("obj.fields_count"), this.context);
        }
        catch (CorruptDataException e) {
            Vector<CorruptData> fields = new Vector<CorruptData>();
            fields.add(e.getCorruptData());
            return fields.iterator();
        }
        catch (MemoryAccessException e) {
            Vector<CorruptDataImpl> fields = new Vector<CorruptDataImpl>();
            fields.add(new CorruptDataImpl(e.getPointer(), e.getMessage()));
            return fields.iterator();
        }
    }

    public Iterator getDeclaredMethods() {
        try {
            return new MethodIterator(this.myDataObject.getMemberAddress("obj.methods"), this.myDataObject.getReader().getshort("obj.methods_count"), this.context);
        }
        catch (CorruptDataException e) {
            Vector<CorruptData> methods = new Vector<CorruptData>();
            methods.add(e.getCorruptData());
            return methods.iterator();
        }
        catch (MemoryAccessException e) {
            Vector<CorruptDataImpl> methods = new Vector<CorruptDataImpl>();
            methods.add(new CorruptDataImpl(e.getPointer(), e.getMessage()));
            return methods.iterator();
        }
    }

    public Iterator getConstantPoolReferences() {
        return this.constantPool.getConstantPoolReferences();
    }

    public boolean isArray() throws CorruptDataException {
        return this.getName().startsWith("[");
    }

    public JavaObjectProxy getObject() throws CorruptDataException {
        if (this.myJavaObjectProxtImpl == null) {
            try {
                this.myJavaObjectProxtImpl = JavaObjectProxyImpl.getInstance(this.myDataObject.getAddress(), this.context);
            }
            catch (MemoryAccessException e) {
                throw new CorruptDataException(new CorruptDataImpl(e.getPointer(), e.getMessage()));
            }
        }
        return this.myJavaObjectProxtImpl;
    }

    public JavaClassProxy getSuperclass() throws CorruptDataException {
        DataObject superclassDO = new DataObject(this.myDataObject, "obj.superclass", this.context);
        this.mySuperclass = superclassDO.getAddress() == 0L ? null : new JavaClassProxyImpl(superclassDO, this.context);
        return this.mySuperclass;
    }

    public int getModifiers() throws CorruptDataException {
        short myModifiers = 0;
        try {
            myModifiers = this.myDataObject.getReader().getshort("obj.access");
        }
        catch (MemoryAccessException e) {
            throw new CorruptDataException(new CorruptDataImpl(e.getPointer(), "Corruption found when getting modifiers for " + this.getName()));
        }
        return myModifiers;
    }

    public int hashCode() {
        return this.myDataObject.hashCode();
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof JavaClassEffigy) {
            JavaClassProxy proxy = ((JavaClassEffigy)obj).getProxy();
            if (proxy instanceof JavaClassProxyImpl) {
                result = ((JavaClassProxyImpl)proxy).myDataObject.equals(this.myDataObject);
            }
        } else if (obj instanceof JavaClassProxyImpl) {
            result = ((JavaClassProxyImpl)obj).myDataObject.equals(this.myDataObject);
        }
        return result;
    }

    public JavaClassLoaderProxy getClassLoader() throws CorruptDataException {
        long classLoaderShadowAddress;
        try {
            long classLoaderAddress = this.myDataObject.getReader().getlong("obj.mirrored_data.(long)loader");
            if (classLoaderAddress == 0L) {
                long jvmAddress = this.context.getJavaRuntimeProxy().getJavaVM().getAddress();
                DataObject jvmDO = new DataObject(null, "Jvm", this.context);
                jvmDO.setAddress(jvmAddress);
                classLoaderShadowAddress = jvmDO.getReader().getlong("facade.cl.(ClData*)dataP.(long)system_loader_shadow");
            } else {
                DataObject cloDO = new DataObject(null, "Hjava_lang_ClassLoader", this.context);
                cloDO.setAddress(classLoaderAddress);
                classLoaderShadowAddress = cloDO.getReader().getlong("obj.(long)loaderCachePointer");
            }
        }
        catch (MemoryAccessException e) {
            throw new CorruptDataException(new CorruptDataImpl(e.getPointer(), e.getMessage()));
        }
        if (this.context.getWordLength().size == 4) {
            classLoaderShadowAddress &= 0xFFFFFFFFL;
        }
        return ((JavaRuntimeProxyImpl)this.context.getJavaRuntimeProxy()).findClassLoader(classLoaderShadowAddress);
    }

    public class MethodIterator
    implements Iterator {
        private AddressSpaceProxy context;
        private int methodsCount;
        private long address;
        TreeMap compiledMethods = null;

        public MethodIterator(long methodBlock, int count, AddressSpaceProxy context) {
            this.context = context;
            this.methodsCount = count;
            this.address = methodBlock;
            this.compiledMethods = ((JavaRuntimeProxyImpl)context.getJavaRuntimeProxy()).getJITCompiledMethods();
        }

        public boolean hasNext() {
            return this.methodsCount > 0;
        }

        public Object next() {
            if (this.methodsCount == 0) {
                throw new NoSuchElementException();
            }
            try {
                long methodBlockAddress = this.address;
                --this.methodsCount;
                this.address += (long)this.context.getDescriptor("methodblock").getByteSize();
                JavaMethodProxyImpl method = (JavaMethodProxyImpl)this.compiledMethods.get(String.valueOf(methodBlockAddress));
                if (method == null) {
                    return new JavaMethodProxyImpl(methodBlockAddress, this.context);
                }
                return method;
            }
            catch (CorruptDataException e) {
                return e.getCorruptData();
            }
            catch (MemoryAccessException e) {
                return new CorruptDataImpl(e.getPointer(), "Error retrieving method");
            }
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public class FieldIterator
    implements Iterator {
        private AddressSpaceProxy context;
        private int fieldsCount;
        private long address;

        public FieldIterator(long fbBlock, int count, AddressSpaceProxy context) {
            this.context = context;
            this.fieldsCount = count;
            this.address = fbBlock;
        }

        public boolean hasNext() {
            return this.fieldsCount > 0;
        }

        public Object next() {
            if (this.fieldsCount == 0) {
                throw new NoSuchElementException();
            }
            try {
                long fbAddress = this.address;
                --this.fieldsCount;
                this.address += (long)this.context.getDescriptor("fieldblock").getByteSize();
                return new JavaFieldProxyImpl(fbAddress, this.context);
            }
            catch (CorruptDataException e) {
                return e.getCorruptData();
            }
            catch (MemoryAccessException e) {
                return new CorruptDataImpl(e.getPointer(), "Error retrieving field");
            }
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class ConstantPool {
        private long poolItemAddress;
        private long poolTypeAddress;
        private int cpLength;
        public final byte CONSTANT_Utf8 = 1;
        public final byte CONSTANT_Unicode = (byte)2;
        public final byte CONSTANT_Integer = (byte)3;
        public final byte CONSTANT_Float = (byte)4;
        public final byte CONSTANT_Long = (byte)5;
        public final byte CONSTANT_Double = (byte)6;
        public final byte CONSTANT_Class = (byte)7;
        public final byte CONSTANT_String = (byte)8;
        public final byte CONSTANT_Fieldref = (byte)9;
        public final byte CONSTANT_Methodref = (byte)10;
        public final byte CONSTANT_InterfaceMethodref = (byte)11;
        public final byte CONSTANT_NameAndType = (byte)12;
        public final byte CONSTANT_POOL_ENTRY_RESOLVED = (byte)-128;
        public final byte CONSTANT_POOL_ENTRY_TYPEMASK = (byte)127;
        public final byte CONSTANT_POOL_ARRAY_DEPTH_INDEX = 1;
        public final byte CONSTANT_POOL_ARRAY_TYPE_INDEX = (byte)2;
        public final byte CONSTANT_POOL_ARRAY_CLASS_INDEX = (byte)3;
        public final byte CONSTANT_POOL_ARRAY_CLASSNAME_INDEX = (byte)4;
        public final byte CONSTANT_POOL_ARRAY_SUPERNAME_INDEX = (byte)5;
        public final byte CONSTANT_POOL_ARRAY_LENGTH = (byte)6;

        public ConstantPool() throws CorruptDataException, MemoryAccessException {
            this.poolItemAddress = JavaClassProxyImpl.this.myDataObject.getReader().getlong("obj.(long)constantpool");
            DataObject myTypeDO = new DataObject(null, "cp_item_type", JavaClassProxyImpl.this.context);
            myTypeDO.setAddress(this.poolItemAddress);
            this.poolTypeAddress = myTypeDO.getReader().getlong("(long)type");
            this.cpLength = JavaClassProxyImpl.this.myDataObject.getReader().getshort("obj.(short)constantpool_count");
        }

        public byte getConstantPoolType(int index) throws MemoryAccessException {
            return (byte)JavaClassProxyImpl.this.context.readByte(this.poolTypeAddress + (long)index);
        }

        Object getConstantPoolEntry(int index) throws MemoryAccessException, CorruptDataException {
            byte type = this.getConstantPoolType(index);
            DataObject cpItemDO = new DataObject(null, "cp_item_type", JavaClassProxyImpl.this.context);
            cpItemDO.setAddress(this.poolItemAddress + (long)(index * cpItemDO.getDescriptor().getByteSize()));
            if (type == -127) {
                return cpItemDO.getReader().getString("utf8String");
            }
            if (type == 7) {
                return this.getConstantPoolEntry(cpItemDO.getReader().getint("i"));
            }
            if (type == -121) {
                return new JavaClassProxyImpl(cpItemDO.getReader().getlong("(long)clazz"), JavaClassProxyImpl.this.context);
            }
            if (type == 8) {
                return this.getConstantPoolEntry(cpItemDO.getReader().getint("i"));
            }
            if (type == -120) {
                return JavaObjectProxyImpl.getInstance(cpItemDO.getReader().getlong("(long)str"), JavaClassProxyImpl.this.context);
            }
            return null;
        }

        public int length() {
            return this.cpLength;
        }

        Iterator getConstantPoolReferences() {
            Vector<Object> refVec = new Vector<Object>(this.cpLength);
            for (int index = 1; index < this.cpLength; ++index) {
                try {
                    byte type = this.getConstantPoolType(index);
                    if (type == -121) {
                        Object clazz = this.getConstantPoolEntry(index);
                        if (clazz instanceof JavaClassProxyImpl) {
                            refVec.add(((JavaClassProxyImpl)clazz).getObject());
                        } else {
                            refVec.add(clazz);
                        }
                    }
                    if (type != -120) continue;
                    Object obj = this.getConstantPoolEntry(index);
                    if (obj instanceof JavaObjectProxyImpl) {
                        refVec.add(obj);
                        continue;
                    }
                    refVec.add(obj);
                    continue;
                }
                catch (CorruptDataException e) {
                    refVec.add(e.getCorruptData());
                    continue;
                }
                catch (MemoryAccessException e) {
                    refVec.add(new CorruptDataImpl(e.getPointer(), e.getMessage()));
                }
            }
            return refVec.iterator();
        }
    }
}

