/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.sov.java.imp;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.sov.Effigy;
import com.ibm.dtfj.sov.data.DataObject;
import com.ibm.dtfj.sov.data.StructuredDataLocator;
import com.ibm.dtfj.sov.image.AddressSpaceProxy;
import com.ibm.dtfj.sov.image.CorruptDataImpl;
import com.ibm.dtfj.sov.imp.JavaFieldEffigy;
import com.ibm.dtfj.sov.imp.JavaObjectEffigy;
import com.ibm.dtfj.sov.java.JavaClassProxy;
import com.ibm.dtfj.sov.java.JavaFieldProxy;
import com.ibm.dtfj.sov.java.imp.JavaClassProxyImpl;
import com.ibm.dtfj.sov.java.imp.JavaObjectProxyImpl;

public class JavaFieldProxyImpl
implements JavaFieldProxy {
    private AddressSpaceProxy context;
    private DataObject myDataObject;
    private StructuredDataLocator myReader;
    private JavaClassProxyImpl myDeclaringClass;
    private static final short MBF_MB_IsTrusted = 1;
    private static final short MBF_MB_MethodTraceOn = 2;
    private static final short MBF_MB_MethodTraceArgsOn = 4;
    private static final short MBF_MB_IsOverride = 8;
    private static final short MBF_MB_IsUnnecessary = 16;
    private static final short MBF_MB_IsNecessary = 32;
    private static final short MBF_MB_HasRun = 64;
    private static final short MBF_MB_IsTriggerMethodTraceOn = 128;
    private static final short MBF_MB_JVMTagged = 256;
    private static final short MBF_FB_IsTwoWordValue = 1;
    private static final short MBF_FB_IsReferenceValue = 2;
    private static final short MBF_FB_IsMarkExcluded = 4;
    private boolean isTwoWordValue = false;
    private boolean isReferenceValue = false;
    private boolean isMarkExcluded = false;
    private boolean isStatic = false;
    private String mySignature = null;
    short myModifiers;
    private String myName = null;
    private String myClassName;
    long offset;
    long staticAddress;
    long shared_static_offset;
    int sharedClassId;

    public JavaFieldProxyImpl(long address, AddressSpaceProxy context) throws MemoryAccessException, CorruptDataException {
        this.myDataObject = new DataObject(null, "fieldblock", context);
        this.myDataObject.setAddress(address);
        this.context = context;
        this.myReader = this.myDataObject.getReader();
        this.fixup();
    }

    public JavaFieldProxyImpl(DataObject dataObject, AddressSpaceProxy context) throws CorruptDataException, MemoryAccessException {
        this.myDataObject = dataObject;
        this.context = context;
        this.myReader = this.myDataObject.getReader();
        this.fixup();
    }

    private void fixup() throws CorruptDataException, MemoryAccessException {
        this.myDeclaringClass = new JavaClassProxyImpl(new DataObject(this.myDataObject, "member.clazz", this.context), this.context);
        short flags = this.myReader.getshort("member.flags");
        this.mySignature = this.myReader.getString("member.signature");
        this.myName = this.myReader.getString("member.name");
        if ((flags & 1) != 0) {
            this.isTwoWordValue = true;
        }
        if ((flags & 2) != 0) {
            this.isReferenceValue = true;
        }
        if ((flags & 4) != 0) {
            this.isMarkExcluded = true;
        }
        this.myModifiers = this.myReader.getshort("member.access");
        this.isStatic = (this.myModifiers & 8) != 0;
        this.staticAddress = this.myDataObject.getMemberAddress("value.(Hjava_lang_Object*)nonshared_static");
        this.shared_static_offset = this.myReader.getint("value.shared_static_offset");
        this.offset = this.myReader.getint("value.instance_offset");
        this.sharedClassId = this.myReader.getint("shared_class_id");
        this.myClassName = this.myDeclaringClass.getName();
    }

    public String getName() {
        return this.myName;
    }

    public String getSignature() {
        return this.mySignature;
    }

    public int getModifiers() {
        return this.myModifiers;
    }

    public Object get(JavaObject object) throws CorruptDataException, MemoryAccessException {
        if (!this.isStatic && !this.isCompatible(object)) {
            throw new IllegalArgumentException("Can't get field " + this.myName + " as object of type " + object.getJavaClass().getName() + " is incompatible with the class " + this.myClassName);
        }
        return this.getValue(this.unwrapObj(object));
    }

    public Object get(JavaObjectProxyImpl object) throws CorruptDataException, MemoryAccessException {
        if (!this.isStatic && !this.isCompatible(object)) {
            throw new IllegalArgumentException("Can't get field " + this.myName + " as object of type " + object.getJavaClass().getName() + " is incompatible with the class " + this.myClassName);
        }
        return this.getValue(object);
    }

    public boolean getBoolean(JavaObject object) throws CorruptDataException, MemoryAccessException {
        Object myObj = this.get(object);
        if (!(myObj instanceof Boolean)) {
            throw new IllegalArgumentException();
        }
        return (Boolean)myObj;
    }

    public byte getByte(JavaObject object) throws CorruptDataException, MemoryAccessException {
        Object myObj = this.get(object);
        if (!(myObj instanceof Number)) {
            throw new IllegalArgumentException();
        }
        return ((Number)myObj).byteValue();
    }

    public double getDouble(JavaObject object) throws CorruptDataException, MemoryAccessException {
        Object myObj = this.get(object);
        if (!(myObj instanceof Number)) {
            throw new IllegalArgumentException();
        }
        return ((Number)myObj).doubleValue();
    }

    public float getFloat(JavaObject object) throws CorruptDataException, MemoryAccessException {
        Object myObj = this.get(object);
        if (!(myObj instanceof Number)) {
            throw new IllegalArgumentException();
        }
        return ((Number)myObj).floatValue();
    }

    public String getString(JavaObject object) throws CorruptDataException, MemoryAccessException {
        Object myObj = this.get(object);
        if (myObj == null) {
            return null;
        }
        if (!(myObj instanceof JavaObjectEffigy)) {
            throw new IllegalArgumentException("Trying to convert object of type " + myObj.getClass().getName() + " into a String");
        }
        JavaObjectProxyImpl myJavaObj = (JavaObjectProxyImpl)((JavaObjectEffigy)myObj).getProxy();
        if (!myJavaObj.getJavaClass().getName().equals("java/lang/String")) {
            throw new IllegalArgumentException("Field to be retrieved must be a java/lang/String object.");
        }
        DataObject stringDO = new DataObject(null, "Hjava_lang_String", this.context);
        stringDO.setAddress(myJavaObj.getAddress());
        StringBuffer arrayValue = new StringBuffer(stringDO.getReader().getString("obj.value"));
        int count = stringDO.getReader().getint("obj.count");
        int offset = stringDO.getReader().getint("obj.offset");
        try {
            return arrayValue.substring(offset, count);
        }
        catch (StringIndexOutOfBoundsException e) {
            CorruptDataException cde = new CorruptDataException(new CorruptDataImpl("Error extracting at offset " + offset + ", count " + count + " from string \"" + arrayValue.toString() + "\""));
            cde.initCause(e);
            throw cde;
        }
    }

    public JavaClassProxy getDeclaringClass() {
        return this.myDeclaringClass;
    }

    public long getLong(JavaObject object) throws CorruptDataException, MemoryAccessException {
        Object myObj = this.get(object);
        if (!(myObj instanceof Number)) {
            throw new IllegalArgumentException();
        }
        return ((Number)myObj).longValue();
    }

    public long getLong(JavaObjectProxyImpl object) throws CorruptDataException, MemoryAccessException {
        Object myObj = this.get(object);
        if (!(myObj instanceof Number)) {
            throw new IllegalArgumentException();
        }
        return ((Number)myObj).longValue();
    }

    public short getShort(JavaObject object) throws CorruptDataException, MemoryAccessException {
        Object myObj = this.get(object);
        if (!(myObj instanceof Number)) {
            throw new IllegalArgumentException();
        }
        return ((Number)myObj).shortValue();
    }

    public char getChar(JavaObject object) throws CorruptDataException, MemoryAccessException {
        Object myObj = this.get(object);
        if (!(myObj instanceof Character)) {
            throw new IllegalArgumentException();
        }
        return ((Character)myObj).charValue();
    }

    public int getInt(JavaObject object) throws CorruptDataException, MemoryAccessException {
        Object myObj = this.get(object);
        if (!(myObj instanceof Number)) {
            throw new IllegalArgumentException();
        }
        return ((Number)myObj).intValue();
    }

    public JavaObjectProxyImpl unwrapObj(JavaObject obj) {
        if (obj == null && this.isStatic) {
            return null;
        }
        if (obj == null && !this.isStatic) {
            throw new NullPointerException();
        }
        if (obj instanceof JavaObjectEffigy) {
            return (JavaObjectProxyImpl)((JavaObjectEffigy)obj).getProxy();
        }
        throw new IllegalArgumentException();
    }

    public Object getValue(JavaObjectProxyImpl obj) throws MemoryAccessException, CorruptDataException {
        long returnValueAddress;
        long objectDataAddress = obj.getDataAddress();
        if (this.isStatic && this.sharedClassId != 0) {
            long mirrorArray = this.context.getJavaRuntimeProxy().getMyObject().getMemberAddress("facade.cl.mirrored_data_map.(char*)static_variable_mirrors");
            long slotAddress = mirrorArray + (long)(this.sharedClassId * this.context.getWordLength().size);
            returnValueAddress = this.context.readPointer(slotAddress) + this.shared_static_offset;
        } else {
            returnValueAddress = this.isStatic ? this.staticAddress : objectDataAddress + this.offset;
        }
        long returnValue = this.isTwoWordValue ? this.context.readLong(returnValueAddress) : this.context.readInt(returnValueAddress);
        if (this.isReferenceValue) {
            if (returnValue == 0L) {
                return null;
            }
            return Effigy.create("JavaObjectEffigy", JavaObjectProxyImpl.getInstance(returnValue, this.context), this.context, this.context.getPlatformName());
        }
        switch (this.mySignature.charAt(0)) {
            case 'Z': {
                return new Boolean(returnValue != 0L);
            }
            case 'C': {
                return new Character((char)returnValue);
            }
            case 'B': {
                return new Byte((byte)returnValue);
            }
            case 'S': {
                return new Short((short)returnValue);
            }
            case 'I': {
                return new Integer((int)returnValue);
            }
            case 'J': {
                return new Long(returnValue);
            }
            case 'F': {
                return new Double(Float.intBitsToFloat((int)returnValue));
            }
            case 'D': {
                return new Double(Double.longBitsToDouble(returnValue));
            }
        }
        throw new CorruptDataException(new CorruptDataImpl("Invalid field signature " + this));
    }

    public boolean isCompatible(JavaObject obj) throws CorruptDataException {
        return this.isCompatible((JavaObjectProxyImpl)((JavaObjectEffigy)obj).getProxy());
    }

    public boolean isCompatible(JavaObjectProxyImpl obj) throws CorruptDataException {
        JavaClassProxy objClass = obj.getJavaClass();
        do {
            if (!objClass.equals(this.myDeclaringClass)) continue;
            return true;
        } while ((objClass = (JavaClassProxyImpl)objClass.getSuperclass()) != null);
        return false;
    }

    public int hashCode() {
        return this.myDataObject.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof JavaFieldEffigy) {
            return ((JavaFieldProxyImpl)((JavaFieldEffigy)obj).getProxy()).myDataObject.equals(this.myDataObject);
        }
        if (obj instanceof JavaFieldProxyImpl) {
            return ((JavaFieldProxyImpl)obj).myDataObject.equals(this.myDataObject);
        }
        return false;
    }

    public String toString() {
        return "JavaField: " + this.myClassName + ", " + this.mySignature + ", " + this.myName;
    }
}

