/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.sov.java.imp;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.sov.Effigy;
import com.ibm.dtfj.sov.data.DataObject;
import com.ibm.dtfj.sov.data.StructuredDataLocator;
import com.ibm.dtfj.sov.image.AddressSpaceProxy;
import com.ibm.dtfj.sov.image.CorruptDataImpl;
import com.ibm.dtfj.sov.image.ImagePointerProxy;
import com.ibm.dtfj.sov.image.ImageSectionImpl;
import com.ibm.dtfj.sov.imp.ImagePointerEffigy;
import com.ibm.dtfj.sov.imp.JavaHeapEffigy;
import com.ibm.dtfj.sov.java.JavaHeapProxy;
import com.ibm.dtfj.sov.java.imp.HeapChunk;
import com.ibm.dtfj.sov.java.imp.JavaObjectProxyImpl;
import com.ibm.dtfj.sov.java.imp.JavaRuntimeProxyImpl;
import java.util.Iterator;
import java.util.Vector;

public class JavaHeapProxyImpl
implements JavaHeapProxy {
    private String name;
    private long base;
    private long limit;
    private static final String GC_TYPE = "Mark, Sweep & Compact";
    private AddressSpaceProxy context;
    private StructuredDataLocator reader;
    private JavaRuntimeProxyImpl jvmProxy;

    public JavaHeapProxyImpl(String name, long base, long top, AddressSpaceProxy context, JavaRuntimeProxyImpl jvmProxy) {
        this.name = name;
        this.base = base;
        this.limit = top;
        this.context = context;
        this.jvmProxy = jvmProxy;
        this.reader = jvmProxy.getReader();
    }

    public String getName() {
        return this.name;
    }

    public long getBase() {
        return this.base;
    }

    public long getLimit() {
        return this.limit;
    }

    public Iterator getObjects(boolean lockedOnly) {
        try {
            if (this.base != -1L) {
                return new SovHeapIterator(this.base, this.limit, this.context, lockedOnly);
            }
            return new SovSystemHeapIterator(this.context, lockedOnly);
        }
        catch (CorruptDataException e) {
            Vector<CorruptData> sovSystemObjects = new Vector<CorruptData>();
            sovSystemObjects.add(e.getCorruptData());
            return sovSystemObjects.iterator();
        }
    }

    public String getGCType() {
        if (this.base != -1L) {
            return GC_TYPE;
        }
        return "NONE";
    }

    public boolean equals(Object obj) {
        boolean isEqual = false;
        if (obj instanceof JavaHeapEffigy) {
            JavaHeapEffigy local = (JavaHeapEffigy)obj;
            isEqual = this.context.equals(((JavaHeapProxyImpl)local.getProxy()).context) && this.base == ((JavaHeapProxyImpl)local.getProxy()).base;
        }
        return isEqual;
    }

    public int hashCode() {
        return this.context.hashCode() ^ (int)this.base;
    }

    public Iterator getObjects() {
        return this.getObjects(false);
    }

    public Iterator getLockedObjects() {
        return this.getObjects(true);
    }

    public Iterator getSections() {
        if (this.name.equals("Middleware Heap") || this.name.equals("Transient Heap")) {
            return this.getTHandMHSections();
        }
        return this.getSHSections();
    }

    public Iterator getSHSections() {
        SovSystemHeapSections SSHSections = new SovSystemHeapSections(this.context);
        return SSHSections.getSHSections();
    }

    public Iterator getTHandMHSections() {
        ImagePointerProxy basePointer = new ImagePointerProxy(this.base, this.context);
        ImagePointerEffigy myBasePointer = (ImagePointerEffigy)Effigy.create("ImagePointerEffigy", basePointer, this.context, this.context.getPlatformName());
        long size = this.limit - this.base;
        Vector<ImageSectionImpl> mySections = new Vector<ImageSectionImpl>();
        mySections.add(new ImageSectionImpl(myBasePointer, size, this.name, false, false, false, false));
        return mySections.iterator();
    }

    private class SovSystemHeapSections {
        private long currentAddress;
        private long heapLimit;
        private long currentExtent;
        private Vector sections = new Vector();
        private AddressSpaceProxy sshContext;
        private DataObject heapExtentInfoDO;
        private StructuredDataLocator heapExtentInfoReader;
        boolean lockedOnly;
        boolean finished = false;

        SovSystemHeapSections(AddressSpaceProxy context) {
            this.sshContext = context;
            this.lockedOnly = true;
            try {
                this.heapExtentInfoDO = new DataObject(null, "heap_extent_info", this.sshContext);
                this.currentExtent = JavaHeapProxyImpl.this.reader.getLong("facade.st.(STGlobal*)dataP.st_jab.(Long)system_heap_this_extent");
                this.heapExtentInfoDO.setAddress(this.currentExtent);
                this.heapExtentInfoReader = this.heapExtentInfoDO.getReader();
                this.currentAddress = this.heapExtentInfoReader.getLong("(Long)base");
                this.heapLimit = JavaHeapProxyImpl.this.reader.getLong("facade.st.(STGlobal*)dataP.st_jab.(Long)system_heap_next");
                ImagePointerProxy base = new ImagePointerProxy(this.currentAddress, context);
                ImagePointerEffigy myBasePointer = (ImagePointerEffigy)Effigy.create("ImagePointerEffigy", base, this.sshContext, this.sshContext.getPlatformName());
                this.sections.add(new ImageSectionImpl(myBasePointer, this.heapLimit - this.currentAddress, null, false, false, false, false));
                while (!this.finished) {
                    this.nextExtent();
                }
            }
            catch (CorruptDataException e) {
                this.sections.add(e.getCorruptData());
            }
            catch (MemoryAccessException e) {
                this.sections.add(new CorruptDataImpl(e.getPointer(), e.getMessage()));
            }
        }

        private void nextExtent() throws CorruptDataException {
            long previousExtent = 0L;
            try {
                previousExtent = this.heapExtentInfoReader.getLong("(Long)prev");
                if (previousExtent > 0L) {
                    this.currentExtent = previousExtent;
                    this.heapExtentInfoDO.setAddress(this.currentExtent);
                    this.currentAddress = this.heapExtentInfoReader.getLong("(Long)base");
                    this.heapLimit = this.heapExtentInfoReader.getLong("(Long)limit");
                    ImagePointerProxy base = new ImagePointerProxy(this.currentAddress, JavaHeapProxyImpl.this.context);
                    ImagePointerEffigy myBasePointer = (ImagePointerEffigy)Effigy.create("ImagePointerEffigy", base, this.sshContext, this.sshContext.getPlatformName());
                    this.sections.add(new ImageSectionImpl(myBasePointer, this.heapLimit - this.currentAddress, null, false, false, false, false));
                } else {
                    this.heapLimit = 0L;
                    this.currentAddress = 1L;
                    this.finished = true;
                }
            }
            catch (MemoryAccessException m) {
                this.finished = true;
                throw new CorruptDataException(new CorruptDataImpl(m.getPointer(), m.getMessage()));
            }
        }

        public Iterator getSHSections() {
            return this.sections.iterator();
        }
    }

    private class SovSystemHeapIterator
    implements Iterator {
        private long currentAddress;
        private long heapLimit;
        private long currentExtent;
        private AddressSpaceProxy sshContext;
        private DataObject heapExtentInfoDO;
        private StructuredDataLocator heapExtentInfoReader;
        boolean lockedOnly;
        boolean finished = false;

        SovSystemHeapIterator(AddressSpaceProxy context, boolean lockedOnly) throws CorruptDataException {
            this.sshContext = context;
            this.lockedOnly = lockedOnly;
            try {
                this.heapExtentInfoDO = new DataObject(null, "heap_extent_info", this.sshContext);
                this.currentExtent = JavaHeapProxyImpl.this.reader.getLong("facade.st.(STGlobal*)dataP.st_jab.(Long)system_heap_this_extent");
                this.heapExtentInfoDO.setAddress(this.currentExtent);
                this.heapExtentInfoReader = this.heapExtentInfoDO.getReader();
                this.currentAddress = this.heapExtentInfoReader.getLong("(Long)base");
                this.heapLimit = JavaHeapProxyImpl.this.reader.getLong("facade.st.(STGlobal*)dataP.st_jab.(Long)system_heap_next");
                this.findNextObject();
            }
            catch (MemoryAccessException e) {
                throw new CorruptDataException(new CorruptDataImpl(e.getPointer(), e.getMessage()));
            }
        }

        private void findNextObject() throws CorruptDataException {
            while (!this.finished && this.lockedOnly && !HeapChunk.isLocked(this.currentAddress, this.sshContext)) {
                this.getNextChunk();
            }
        }

        private void getNextChunk() throws CorruptDataException {
            this.currentAddress += HeapChunk.olinkLen(this.currentAddress, this.sshContext);
            if (this.currentAddress >= this.heapLimit) {
                this.nextExtent();
            }
        }

        public boolean hasNext() {
            return !this.finished;
        }

        private void nextExtent() throws CorruptDataException {
            long previousExtent = 0L;
            try {
                previousExtent = this.heapExtentInfoReader.getLong("(Long)prev");
                if (previousExtent > 0L) {
                    this.currentExtent = previousExtent;
                    this.heapExtentInfoDO.setAddress(this.currentExtent);
                    this.currentAddress = this.heapExtentInfoReader.getLong("(Long)base");
                    this.heapLimit = this.heapExtentInfoReader.getLong("(Long)limit");
                } else {
                    this.heapLimit = 0L;
                    this.currentAddress = 1L;
                    this.finished = true;
                }
            }
            catch (MemoryAccessException e) {
                this.finished = true;
                throw new CorruptDataException(new CorruptDataImpl(e.getPointer(), e.getMessage()));
            }
        }

        public Object next() {
            if (this.hasNext()) {
                long objectAddress = this.currentAddress + (long)this.sshContext.getWordLength().size;
                try {
                    JavaObjectProxyImpl ho = JavaObjectProxyImpl.getInstance(objectAddress, this.sshContext, false);
                    this.getNextChunk();
                    this.findNextObject();
                    return ho;
                }
                catch (MemoryAccessException e) {
                    return new CorruptDataImpl(e.getPointer(), e.getMessage());
                }
                catch (CorruptDataException e) {
                    return e.getCorruptData();
                }
            }
            return null;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class SovHeapIterator
    implements Iterator {
        private long currentAddress;
        private long heapLimit;
        private AddressSpaceProxy svhContext;
        private boolean lockedOnly;

        SovHeapIterator(long heapBase, long heapLimit, AddressSpaceProxy context, boolean lockedOnly) throws CorruptDataException {
            this.currentAddress = heapBase;
            this.heapLimit = heapLimit;
            this.svhContext = context;
            this.lockedOnly = lockedOnly;
            this.findNextObject();
        }

        private void findNextObject() throws CorruptDataException {
            while (this.currentAddress < this.heapLimit) {
                if (!HeapChunk.isObject(this.currentAddress, this.svhContext)) {
                    this.getNextChunk();
                    continue;
                }
                if (!this.lockedOnly || HeapChunk.isLocked(this.currentAddress, this.svhContext)) break;
                this.getNextChunk();
            }
        }

        private void getNextChunk() throws CorruptDataException {
            long olinkLen = HeapChunk.olinkLen(this.currentAddress, this.svhContext);
            this.currentAddress = olinkLen == -1L ? this.heapLimit + 1L : (this.currentAddress += olinkLen);
        }

        public boolean hasNext() {
            return this.currentAddress < this.heapLimit;
        }

        public Object next() {
            if (this.hasNext()) {
                JavaObjectProxyImpl ho;
                try {
                    long tmpAddress = this.currentAddress;
                    this.getNextChunk();
                    this.findNextObject();
                    ho = JavaObjectProxyImpl.getInstance(tmpAddress + (long)this.svhContext.getWordLength().size, this.svhContext, true);
                }
                catch (MemoryAccessException e) {
                    return new CorruptDataImpl(e.getPointer(), e.getMessage());
                }
                catch (CorruptDataException e) {
                    return e.getCorruptData();
                }
                return ho;
            }
            return null;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

